/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.menu;

import com.enderio.api.capability.IEntityStorage;
import com.enderio.api.capability.StoredEntityData;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.core.common.menu.FilterSlot;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;

public class EntityFilterSlot
extends FilterSlot<StoredEntityData> {
    public EntityFilterSlot(Consumer<StoredEntityData> consumer, int pSlot, int pX, int pY) {
        super(consumer, pSlot, pX, pY);
    }

    @Override
    public Optional<StoredEntityData> getResourceFrom(ItemStack itemStack) {
        SpawnEggItem spawnEggItem;
        Entity entity;
        LazyOptional entityStorageOptional = itemStack.getCapability(EIOCapabilities.ENTITY_STORAGE);
        if (entityStorageOptional.isPresent()) {
            IEntityStorage storage = (IEntityStorage)entityStorageOptional.resolve().get();
            return Optional.of(storage.getStoredEntityData());
        }
        Item item = itemStack.m_41720_();
        if (item instanceof SpawnEggItem && (entity = (spawnEggItem = (SpawnEggItem)item).m_43228_(itemStack.m_41783_()).m_20615_((Level)Minecraft.m_91087_().f_91073_)) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            StoredEntityData ghost = new StoredEntityData(livingEntity.serializeNBT(), livingEntity.m_21233_());
            return Optional.of(ghost);
        }
        return Optional.empty();
    }
}

