/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.capability;

import com.enderio.api.filter.FluidStackFilter;
import com.enderio.core.common.capability.IFilterCapability;
import com.enderio.core.common.util.NbtUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FluidFilterCapability
implements IFilterCapability<FluidStack>,
FluidStackFilter {
    private static final String NBT_KEY = "IsNbt";
    private static final String INVERTED_KEY = "IsInverted";
    private static final String ENTRIES_KEY = "FluidEntries";
    private final ItemStack container;
    private final int size;

    public FluidFilterCapability(ItemStack container, int size) {
        this.container = container;
        this.size = size;
        CompoundTag tag = container.m_41784_();
        if (!tag.m_128425_(ENTRIES_KEY, 9)) {
            ListTag entriesList = new ListTag();
            this.ensureSize(entriesList);
            tag.m_128365_(ENTRIES_KEY, (Tag)entriesList);
        }
    }

    @Override
    public void setNbt(Boolean nbt) {
        CompoundTag tag = this.container.m_41784_();
        tag.m_128379_(NBT_KEY, nbt.booleanValue());
    }

    @Override
    public boolean isNbt() {
        CompoundTag tag = this.container.m_41784_();
        return tag.m_128425_(NBT_KEY, 1) && tag.m_128471_(NBT_KEY);
    }

    @Override
    public void setInverted(Boolean inverted) {
        CompoundTag tag = this.container.m_41784_();
        tag.m_128379_(INVERTED_KEY, inverted.booleanValue());
    }

    @Override
    public boolean isInvert() {
        CompoundTag tag = this.container.m_41784_();
        return tag.m_128425_(INVERTED_KEY, 1) && tag.m_128471_(INVERTED_KEY);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<FluidStack> getEntries() {
        CompoundTag tag = this.container.m_41784_();
        ArrayList<FluidStack> entries = new ArrayList<FluidStack>();
        if (tag.m_128425_(ENTRIES_KEY, 9)) {
            ListTag entriesList = tag.m_128437_(ENTRIES_KEY, 10);
            this.ensureSize(entriesList);
            for (Tag entry : entriesList) {
                entries.add(FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)entry)));
            }
        }
        return entries;
    }

    @Override
    public FluidStack getEntry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(index);
        }
        CompoundTag tag = this.container.m_41784_();
        if (!tag.m_128425_(ENTRIES_KEY, 9)) {
            return FluidStack.EMPTY;
        }
        ListTag entriesList = tag.m_128437_(ENTRIES_KEY, 10);
        this.ensureSize(entriesList);
        return FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)entriesList.get(index)));
    }

    @Override
    public void setEntry(int index, FluidStack entry) {
        ListTag entriesList;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(index);
        }
        CompoundTag tag = this.container.m_41784_();
        if (tag.m_128425_(ENTRIES_KEY, 9)) {
            entriesList = tag.m_128437_(ENTRIES_KEY, 10);
        } else {
            entriesList = new ListTag();
            tag.m_128365_(ENTRIES_KEY, (Tag)entriesList);
        }
        this.ensureSize(entriesList);
        entriesList.set(index, (Tag)entry.writeToNBT(new CompoundTag()));
    }

    @Override
    public boolean test(FluidStack stack) {
        for (FluidStack testStack : this.getEntries()) {
            boolean test = this.isNbt() ? FluidStack.areFluidStackTagsEqual((FluidStack)testStack, (FluidStack)stack) : testStack.isFluidEqual(stack);
            if (!test) continue;
            return !this.isInvert();
        }
        return this.isInvert();
    }

    private void ensureSize(ListTag list) {
        NbtUtil.ensureSize(list, this.size, () -> FluidStack.EMPTY.writeToNBT(new CompoundTag()));
    }
}

