/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.EnderIO;
import com.enderio.api.capability.StoredEntityData;
import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.QuadraticScalable;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.core.common.network.slot.BooleanNetworkDataSlot;
import com.enderio.core.common.network.slot.ResourceLocationNetworkDataSlot;
import com.enderio.machines.common.blockentity.MachineState;
import com.enderio.machines.common.blockentity.MachineStateType;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.blockentity.task.IMachineTask;
import com.enderio.machines.common.blockentity.task.SpawnerMachineTask;
import com.enderio.machines.common.blockentity.task.host.MachineTaskHost;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.lang.MachineLang;
import com.enderio.machines.common.menu.PoweredSpawnerMenu;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PoweredSpawnerBlockEntity
extends PoweredMachineBlockEntity {
    public static final QuadraticScalable CAPACITY = new QuadraticScalable(CapacitorModifier.ENERGY_CAPACITY, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.POWERED_SPAWNER_CAPACITY);
    public static final QuadraticScalable USAGE = new QuadraticScalable(CapacitorModifier.ENERGY_USE, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.POWERED_SPAWNER_USAGE);
    public static final ResourceLocation NO_MOB = EnderIO.loc("no_mob");
    private StoredEntityData entityData = StoredEntityData.empty();
    private SpawnerBlockedReason reason = SpawnerBlockedReason.NONE;
    private final MachineTaskHost taskHost;

    public PoweredSpawnerBlockEntity(BlockEntityType type, BlockPos worldPosition, BlockState blockState) {
        super(EnergyIOMode.Input, CAPACITY, USAGE, type, worldPosition, blockState);
        this.rangeVisibleDataSlot = new BooleanNetworkDataSlot(this::isRangeVisible, b -> {
            this.rangeVisible = b;
        });
        this.addDataSlot(this.rangeVisibleDataSlot);
        this.addDataSlot(new ResourceLocationNetworkDataSlot(() -> this.getEntityType().orElse(NO_MOB), rl -> {
            this.setEntityType((ResourceLocation)rl);
            EnderIO.LOGGER.info("UPDATED ENTITY TYPE.");
        }));
        this.range = 4;
        this.taskHost = new MachineTaskHost(this, this::hasEnergy){

            @Override
            @Nullable
            protected IMachineTask getNewTask() {
                return PoweredSpawnerBlockEntity.this.createTask();
            }

            @Override
            @Nullable
            protected IMachineTask loadTask(CompoundTag nbt) {
                SpawnerMachineTask task = PoweredSpawnerBlockEntity.this.createTask();
                task.deserializeNBT(nbt);
                return task;
            }
        };
        this.updateMachineState(new MachineState(MachineStateType.ERROR, this.reason.component), false);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new PoweredSpawnerMenu(this, pPlayerInventory, pContainerId);
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.canAct()) {
            this.taskHost.tick();
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.taskHost.onLevelReady();
    }

    @Override
    public MachineInventoryLayout createInventoryLayout() {
        return MachineInventoryLayout.builder().capacitor().build();
    }

    @Override
    protected void onInventoryContentsChanged(int slot) {
        super.onInventoryContentsChanged(slot);
        this.taskHost.newTaskAvailable();
    }

    @Override
    public String getColor() {
        return (String)MachinesConfig.CLIENT.BLOCKS.POWERED_SPAWNER_RANGE_COLOR.get();
    }

    @Override
    public int getMaxRange() {
        return 3;
    }

    public float getSpawnProgress() {
        return this.taskHost.getProgress();
    }

    @Override
    protected boolean isActive() {
        return this.canAct() && this.hasEnergy() && this.taskHost.hasTask();
    }

    private SpawnerMachineTask createTask() {
        return new SpawnerMachineTask(this, this.getEnergyStorage(), this.getEntityType());
    }

    public Optional<ResourceLocation> getEntityType() {
        return this.entityData.getEntityType();
    }

    public void setEntityType(ResourceLocation entityType) {
        this.entityData = StoredEntityData.of(entityType);
    }

    public StoredEntityData getEntityData() {
        return this.entityData;
    }

    public void setReason(SpawnerBlockedReason reason) {
        this.updateMachineState(new MachineState(MachineStateType.ERROR, this.reason.component), false);
        this.updateMachineState(new MachineState(MachineStateType.ERROR, reason.component), true);
        this.reason = reason;
    }

    @Override
    public void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("EntityStorage", this.entityData.serializeNBT());
        this.taskHost.save(pTag);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.entityData.deserializeNBT((Tag)pTag.m_128469_("EntityStorage"));
        this.taskHost.load(pTag);
    }

    public static enum SpawnerBlockedReason {
        TOO_MANY_MOB(MachineLang.TOO_MANY_MOB),
        TOO_MANY_SPAWNER(MachineLang.TOO_MANY_SPAWNER),
        UNKNOWN_MOB(MachineLang.UNKNOWN),
        OTHER_MOD(MachineLang.OTHER_MOD),
        DISABLED(MachineLang.DISABLED),
        NONE(Component.m_237113_((String)"NONE"));

        private final MutableComponent component;

        private SpawnerBlockedReason(MutableComponent component) {
            this.component = component;
        }

        public MutableComponent getComponent() {
            return this.component;
        }
    }
}

