/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.entity.misc.TrailDescriptor;
import immersive_aircraft.item.upgrade.VehicleStat;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class AirshipEntity
extends Rotorcraft {
    public AirshipEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world, true);
    }

    @Override
    protected float getEngineReactionSpeed() {
        return 50.0f;
    }

    @Override
    protected SoundEvent getEngineSound() {
        return Sounds.PROPELLER_SMALL.get();
    }

    @Override
    public Item asItem() {
        return Items.AIRSHIP.get();
    }

    @Override
    protected float getGravity() {
        return this.f_19798_ ? 0.04f : (1.0f - this.getEnginePower()) * super.getGravity();
    }

    @Override
    protected void updateController() {
        super.updateController();
        if (this.canTurnOnEngine((Entity)this.m_6688_())) {
            this.setEngineTarget(1.0f);
        }
        this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(this.getEnginePower() * this.getProperties().get(VehicleStat.VERTICAL_SPEED) * this.pressingInterpolatedY.getSmooth()), 0.0));
        Vector3f direction = this.getForwardDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 5.0) * (double)this.getProperties().get(VehicleStat.ENGINE_SPEED)) * this.pressingInterpolatedZ.getSmooth();
        Vector3f f = direction.mul(thrust);
        this.m_20256_(this.m_20184_().m_82520_((double)f.x, (double)f.y, (double)f.z));
    }

    @Override
    protected float getBaseTrailWidth(Matrix4f transform, int index, TrailDescriptor trail) {
        return Math.max(0.0f, Math.min(1.0f, (float)(this.m_20184_().m_82553_() - (double)0.05f)));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        float power = this.getEnginePower();
        if (this.m_9236_().f_46443_ && this.isWithinParticleRange() && (double)power > 0.01) {
            Matrix4f transform = this.getVehicleTransform();
            if (this.f_19797_ % 2 == 0) {
                Vector4f p = this.transformPosition(transform, (this.f_19796_.m_188501_() - 0.5f) * 0.4f, 0.8f, -0.8f);
                Vec3 velocity = this.m_20184_();
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)p.x, (double)p.y, (double)p.z, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
            }
        }
    }

    @Override
    public double getZoom() {
        return 5.0;
    }

    @Override
    public float getPropellerSpeed() {
        return super.getPropellerSpeed() * (0.25f + Math.abs(this.pressingInterpolatedZ.get(0.0f)));
    }
}

