/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.common.blockentities.base.EnergyContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.machines.CoalGeneratorMenu;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.ExtractOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.util.CommonHooks;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CoalGeneratorBlockEntity
extends EnergyContainerMachineBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_SLOTS), new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.PUSH, ConstantComponents.SIDE_CONFIG_ENERGY));
    protected int cookTime;
    protected int cookTimeTotal;

    public CoalGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, 2);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new CoalGeneratorMenu(id, inventory, this);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer != null) {
            return this.energyContainer;
        }
        this.energyContainer = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)new ExtractOnlyEnergyContainer(MachineConfig.ironTierEnergyCapacity, MachineConfig.ironTierMaxEnergyInOut));
        return this.energyContainer;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.cookTime = tag.m_128451_("CookTime");
        this.cookTimeTotal = tag.m_128451_("CookTimeTotal");
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("CookTime", this.cookTime);
        tag.m_128405_("CookTimeTotal", this.cookTimeTotal);
    }

    @Override
    public EnergyContainerMachineBlockEntity.ChargeSlotType getChargeSlotType() {
        return EnergyContainerMachineBlockEntity.ChargeSlotType.POWER_ITEM;
    }

    @Override
    public void serverTick(ServerLevel level, long time, BlockState state, BlockPos pos) {
        if (!this.canFunction()) {
            if (time % 10L == 0L) {
                this.setLit(false);
            }
            return;
        }
        ItemStack input = this.m_8020_(1);
        if (this.getEnergyStorage().internalInsert(MachineConfig.coalGeneratorEnergyGenerationPerTick, true) == 0L) {
            if (time % 10L == 0L) {
                this.setLit(false);
            }
            return;
        }
        if (this.cookTime > 0) {
            --this.cookTime;
            this.getEnergyStorage().internalInsert(MachineConfig.coalGeneratorEnergyGenerationPerTick, false);
            if (time % 10L == 0L) {
                this.setLit(true);
            }
        } else if (!input.m_41619_() && !(input.m_41720_() instanceof BucketItem)) {
            int burnTime = Math.min(20000, CommonHooks.getBurnTime((ItemStack)input));
            if (burnTime > 0) {
                input.m_41774_(1);
                this.cookTimeTotal = burnTime;
                this.cookTime = burnTime;
            }
        } else if (time % 10L == 0L) {
            this.setLit(false);
        }
    }

    @Override
    public void tickSideInteractions(BlockPos pos, Predicate<Direction> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pushItemsNearby(this, pos, new int[]{1}, sideConfig.get(0), filter);
        TransferUtils.pullItemsNearby(this, pos, new int[]{1}, sideConfig.get(0), filter);
        TransferUtils.pushEnergyNearby(this, pos, this.getEnergyStorage().maxExtract(), sideConfig.get(1), filter);
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int cookTime() {
        return this.cookTime;
    }

    public int cookTimeTotal() {
        return this.cookTimeTotal;
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        return new int[]{1};
    }
}

