/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.lyivx.ls_furniture.common.blocks.ShelfBlock;
import net.lyivx.ls_furniture.common.blocks.entity.PlateBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlateRenderer
implements BlockEntityRenderer<PlateBlockEntity> {
    public PlateRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PlateBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Direction direction = (Direction)blockEntity.m_58900_().m_61143_((Property)ShelfBlock.FACING);
        float rotation = -direction.m_122435_() + 180.0f;
        NonNullList<ItemStack> items = blockEntity.getItems();
        poseStack.m_85836_();
        if (rotation == 0.0f) {
            poseStack.m_85837_(0.7, 0.275, 0.47);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation - 180.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(rotation - 180.0f));
        } else if (rotation == 90.0f) {
            poseStack.m_85837_(0.47, -0.1, 0.7);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation - 180.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation - 90.0f));
        } else if (rotation == 180.0f) {
            poseStack.m_85837_(0.7, -0.125, 0.53);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation - 180.0f));
        } else {
            poseStack.m_85837_(0.53, -0.1, 0.3);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation));
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(rotation - 90.0f));
        for (int j = 0; j < items.size(); ++j) {
            ItemStack stack = (ItemStack)items.get(j);
            if (stack.m_41619_()) continue;
            int renderCount = this.getAmount(stack.m_41613_());
            for (int i = 0; i < renderCount; ++i) {
                float fx = -0.10375f * (float)(i - 1) * 0.5f % 0.09f;
                float fy = -0.04375f * (float)(i - 1) * 0.5f % 0.09f;
                float fz = -0.05375f * (float)(i - 1) * 0.5f % 0.09f;
                poseStack.m_85836_();
                poseStack.m_85837_(0.15 - 0.05 * (double)(j % 2), 0.0 - 0.02 * (double)(j % 2), -0.225 + 0.13 * ((double)j / 0.75));
                poseStack.m_252880_(fx, fy, fz);
                poseStack.m_85841_(0.6f, 0.6f, 0.6f);
                Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.m_58904_(), 0);
                poseStack.m_85849_();
            }
        }
        poseStack.m_85849_();
    }

    public int getAmount(int count) {
        if (count > 48) {
            return 5;
        }
        if (count > 32) {
            return 4;
        }
        if (count > 16) {
            return 3;
        }
        if (count > 1) {
            return 2;
        }
        return 1;
    }
}

