/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.lyivx.ls_furniture.common.blocks.RailingBlock;
import net.lyivx.ls_furniture.common.blocks.entity.RailingBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RailingPreviewRenderer
implements BlockEntityRenderer<RailingBlockEntity> {
    private final BlockRenderDispatcher blockRenderer;

    public RailingPreviewRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderer = context.m_173584_();
    }

    public void render(@NotNull RailingBlockEntity blockEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource source, int light, int overlay) {
        BlockState blockState;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        BlockPos blockPos = blockEntity.m_58899_();
        Minecraft mc = Minecraft.m_91087_();
        Vec3 eyePosition = player.m_20299_(partialTicks);
        Vec3 viewVector = player.m_20252_(1.0f);
        float reachDistance = mc.f_91072_.m_105286_();
        Vec3 endVec = eyePosition.m_82549_(viewVector.m_82490_((double)reachDistance));
        BlockHitResult hitResult = mc.f_91073_.m_45547_(new ClipContext(eyePosition, endVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        InteractionHand hand = player.m_7655_();
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item.equals((blockState = blockEntity.m_58900_()).m_60734_().m_5456_()) && hitResult.m_82425_().equals((Object)blockPos)) {
            Vec3 hitPosition = hitResult.m_82450_();
            double xOffset = hitPosition.f_82479_ - (double)blockPos.m_123341_();
            double zOffset = hitPosition.f_82481_ - (double)blockPos.m_123343_();
            if (xOffset > 0.01 && xOffset < 0.99 && zOffset > 0.01 && zOffset < 0.99) {
                poseStack.m_85836_();
                poseStack.m_85841_(1.0f, 1.0f, 1.0f);
                long time = Minecraft.m_91087_().f_91073_.m_46467_();
                float pulseFactor = (float)Math.sin((double)time / 5.0) * 0.5f / 16.0f + 1.0f;
                poseStack.m_85841_(1.0f, pulseFactor, 1.0f);
                Direction hitFace = hitResult.m_82434_();
                if (hitFace == Direction.SOUTH) {
                    if (zOffset < 0.5) {
                        if (xOffset < 0.5) {
                            if (((Boolean)blockState.m_61143_((Property)RailingBlock.WEST_RAILING)).equals(false)) {
                                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                                poseStack.m_252880_(-1.0f, 0.0f, 0.0f);
                            } else {
                                poseStack.m_85841_(0.0f, 0.0f, 0.0f);
                            }
                        } else if (((Boolean)blockState.m_61143_((Property)RailingBlock.EAST_RAILING)).equals(false)) {
                            poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                            poseStack.m_252880_(0.0f, 0.0f, -1.0f);
                        } else {
                            poseStack.m_85841_(0.0f, 0.0f, 0.0f);
                        }
                    } else {
                        poseStack.m_85841_(0.0f, 0.0f, 0.0f);
                    }
                }
                if (hitFace == Direction.WEST) {
                    if (xOffset < 0.5) {
                        poseStack.m_85841_(0.0f, 0.0f, 0.0f);
                    } else if (zOffset < 0.5) {
                        if (((Boolean)blockState.m_61143_((Property)RailingBlock.NORTH_RAILING)).equals(false)) {
                            poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                            poseStack.m_252880_(0.0f, 0.0f, 0.0f);
                        } else {
                            poseStack.m_85841_(0.0f, 0.0f, 0.0f);
                        }
                    } else if (((Boolean)blockState.m_61143_((Property)RailingBlock.SOUTH_RAILING)).equals(false)) {
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                        poseStack.m_252880_(-1.0f, 0.0f, -1.0f);
                    } else {
                        poseStack.m_85841_(0.0f, 0.0f, 0.0f);
                    }
                }
                if (hitFace == Direction.EAST) {
                    if (xOffset < 0.5) {
                        if (zOffset < 0.5) {
                            if (((Boolean)blockState.m_61143_((Property)RailingBlock.NORTH_RAILING)).equals(false)) {
                                poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                                poseStack.m_252880_(0.0f, 0.0f, 0.0f);
                            } else {
                                poseStack.m_85841_(0.0f, 0.0f, 0.0f);
                            }
                        } else if (((Boolean)blockState.m_61143_((Property)RailingBlock.SOUTH_RAILING)).equals(false)) {
                            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                            poseStack.m_252880_(-1.0f, 0.0f, -1.0f);
                        } else {
                            poseStack.m_85841_(0.0f, 0.0f, 0.0f);
                        }
                    } else {
                        poseStack.m_85841_(0.0f, 0.0f, 0.0f);
                    }
                }
                if (hitFace == Direction.NORTH) {
                    if (zOffset < 0.5) {
                        poseStack.m_85841_(0.0f, 0.0f, 0.0f);
                    } else if (xOffset < 0.5) {
                        if (((Boolean)blockState.m_61143_((Property)RailingBlock.WEST_RAILING)).equals(false)) {
                            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                            poseStack.m_252880_(-1.0f, 0.0f, 0.0f);
                        } else {
                            poseStack.m_85841_(0.0f, 0.0f, 0.0f);
                        }
                    } else if (((Boolean)blockState.m_61143_((Property)RailingBlock.EAST_RAILING)).equals(false)) {
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                        poseStack.m_252880_(0.0f, 0.0f, -1.0f);
                    } else {
                        poseStack.m_85841_(0.0f, 0.0f, 0.0f);
                    }
                }
                if (hitFace == Direction.UP) {
                    poseStack.m_85841_(0.0f, 0.0f, 0.0f);
                }
                if (hitFace == Direction.DOWN) {
                    poseStack.m_85841_(0.0f, 0.0f, 0.0f);
                }
                this.blockRenderer.m_110937_().m_111067_(poseStack.m_85850_(), source.m_6299_(Sheets.m_110790_()), blockEntity.m_58900_().m_60734_().m_49966_(), Minecraft.m_91087_().m_91289_().m_110910_(blockState), 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
                this.blockRenderer.m_110937_().m_111067_(poseStack.m_85850_(), source.m_6299_(RenderType.m_110490_()), blockEntity.m_58900_().m_60734_().m_49966_(), Minecraft.m_91087_().m_91289_().m_110910_(blockState), 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
                poseStack.m_85849_();
            }
        }
    }
}

