/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirePlaceBlock
extends Block
implements WrenchItem.WrenchableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape NORTH = Stream.of(Block.m_49796_((double)8.0, (double)-0.01, (double)10.0, (double)18.0, (double)2.0, (double)15.99), Block.m_49796_((double)-2.0, (double)-0.01, (double)10.0, (double)8.0, (double)2.0, (double)15.99), Block.m_49796_((double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0), Block.m_49796_((double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0, (double)15.0), Block.m_49796_((double)0.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0, (double)15.0), Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0, (double)15.0), Block.m_49796_((double)0.0, (double)2.0, (double)14.99, (double)16.0, (double)16.0, (double)15.99), Block.m_49796_((double)4.0, (double)4.0, (double)13.0, (double)12.0, (double)8.0, (double)13.0), Block.m_49796_((double)4.0, (double)3.1, (double)13.1, (double)12.0, (double)4.1, (double)15.1)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final BooleanProperty ON = BooleanProperty.m_61465_((String)"on");
    private static final VoxelShape[] SHAPES = new VoxelShape[4];

    public FirePlaceBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(state -> (Boolean)state.m_61143_((Property)ON) != false ? 15 : 0));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ON, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ON, FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return SHAPES[direction.m_122416_()];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)ON, (Comparable)Boolean.valueOf(false));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof WrenchItem) {
            return InteractionResult.FAIL;
        }
        if (stack.m_41619_() && ((Boolean)state.m_61143_((Property)ON)).booleanValue()) {
            BlockState offState = (BlockState)state.m_61124_((Property)ON, (Comparable)Boolean.valueOf(false));
            level.m_46597_(pos, offState);
            level.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, (Boolean)offState.m_61143_((Property)ON) != false ? 0.6f : 0.5f);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_(Items.f_42409_) && !((Boolean)state.m_61143_((Property)ON)).booleanValue()) {
            BlockState onState = (BlockState)state.m_61124_((Property)ON, (Comparable)Boolean.valueOf(true));
            level.m_46597_(pos, onState);
            level.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, (Boolean)onState.m_61143_((Property)ON) != false ? 0.6f : 0.5f);
            if (!player.m_7500_()) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.fire_place"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.fire_place_off"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }

    static {
        FirePlaceBlock.SHAPES[0] = ShapeUtil.rotateShape(NORTH, Direction.SOUTH);
        FirePlaceBlock.SHAPES[1] = ShapeUtil.rotateShape(NORTH, Direction.WEST);
        FirePlaceBlock.SHAPES[2] = ShapeUtil.rotateShape(NORTH, Direction.NORTH);
        FirePlaceBlock.SHAPES[3] = ShapeUtil.rotateShape(NORTH, Direction.EAST);
    }
}

