/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.lyivx.ls_furniture.common.blocks.entity.LockableBlockEntity;
import net.lyivx.ls_furniture.common.blocks.properties.ColorType;
import net.lyivx.ls_furniture.common.blocks.properties.ModBlockStateProperties;
import net.lyivx.ls_furniture.common.blocks.properties.VerticalConnectionType;
import net.lyivx.ls_furniture.common.items.HammerItem;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.lyivx.ls_furniture.registry.ModItemTags;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LampBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
WrenchItem.WrenchableBlock,
HammerItem.HammerableBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty FACING = ModBlockStateProperties.FACING_EXCEPT_DOWN;
    public static final EnumProperty<VerticalConnectionType> VERTICAL = ModBlockStateProperties.VERTICAL_CONNECTION_TYPE;
    public static final EnumProperty<ColorType> COLOR = ModBlockStateProperties.COLOR;
    protected static final VoxelShape SINGLE = Stream.of(Block.m_49796_((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0), Block.m_49796_((double)7.0, (double)10.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0), Block.m_49796_((double)12.0, (double)6.0, (double)4.0, (double)13.0, (double)13.0, (double)12.0), Block.m_49796_((double)3.0, (double)6.0, (double)4.0, (double)4.0, (double)13.0, (double)12.0), Block.m_49796_((double)3.0, (double)6.0, (double)12.0, (double)13.0, (double)13.0, (double)13.0), Block.m_49796_((double)4.0, (double)12.0, (double)6.0, (double)6.0, (double)15.0, (double)10.0), Block.m_49796_((double)10.0, (double)12.0, (double)6.0, (double)12.0, (double)15.0, (double)10.0), Block.m_49796_((double)4.0, (double)12.0, (double)10.0, (double)12.0, (double)15.0, (double)12.0), Block.m_49796_((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0, (double)6.0), Block.m_49796_((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)13.0, (double)4.0), Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape BOTTOM = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape MIDDLE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    protected static final VoxelShape TOP = Stream.of(Block.m_49796_((double)7.0, (double)10.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0), Block.m_49796_((double)12.0, (double)6.0, (double)4.0, (double)13.0, (double)13.0, (double)12.0), Block.m_49796_((double)3.0, (double)6.0, (double)4.0, (double)4.0, (double)13.0, (double)12.0), Block.m_49796_((double)3.0, (double)6.0, (double)12.0, (double)13.0, (double)13.0, (double)13.0), Block.m_49796_((double)4.0, (double)12.0, (double)6.0, (double)6.0, (double)15.0, (double)10.0), Block.m_49796_((double)10.0, (double)12.0, (double)6.0, (double)12.0, (double)15.0, (double)10.0), Block.m_49796_((double)4.0, (double)12.0, (double)10.0, (double)12.0, (double)15.0, (double)12.0), Block.m_49796_((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0, (double)6.0), Block.m_49796_((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)13.0, (double)4.0), Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape WALL_NORTH = Stream.of(Block.m_49796_((double)7.0, (double)10.0, (double)9.0, (double)9.0, (double)12.0, (double)11.0), Block.m_49796_((double)7.0, (double)2.0, (double)11.0, (double)9.0, (double)4.0, (double)14.0), Block.m_49796_((double)7.0, (double)2.0, (double)9.0, (double)9.0, (double)10.0, (double)11.0), Block.m_49796_((double)5.0, (double)0.0, (double)14.0, (double)11.0, (double)6.0, (double)16.0), Block.m_49796_((double)12.0, (double)6.0, (double)6.0, (double)13.0, (double)13.0, (double)14.0), Block.m_49796_((double)3.0, (double)6.0, (double)6.0, (double)4.0, (double)13.0, (double)14.0), Block.m_49796_((double)3.0, (double)6.0, (double)14.0, (double)13.0, (double)13.0, (double)15.0), Block.m_49796_((double)4.0, (double)12.0, (double)8.0, (double)6.0, (double)15.0, (double)12.0), Block.m_49796_((double)10.0, (double)12.0, (double)8.0, (double)12.0, (double)15.0, (double)12.0), Block.m_49796_((double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)15.0, (double)14.0), Block.m_49796_((double)4.0, (double)12.0, (double)6.0, (double)12.0, (double)15.0, (double)8.0), Block.m_49796_((double)3.0, (double)6.0, (double)5.0, (double)13.0, (double)13.0, (double)6.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape[] WALL = new VoxelShape[4];

    public LampBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(state -> (Boolean)state.m_61143_((Property)LIT) != false ? 15 : 0));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(VERTICAL, (Comparable)((Object)VerticalConnectionType.SINGLE))).m_61124_(COLOR, (Comparable)((Object)ColorType.WHITE)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        VerticalConnectionType verticalType = (VerticalConnectionType)((Object)state.m_61143_(VERTICAL));
        if (direction == null) {
            throw new IllegalStateException("Direction must not be null.");
        }
        switch (verticalType) {
            case SINGLE: {
                if (direction == Direction.NORTH || direction == Direction.SOUTH || direction == Direction.EAST || direction == Direction.WEST) {
                    return WALL[direction.m_122416_()];
                }
            }
            case TOP: {
                return TOP;
            }
            case MIDDLE: {
                return MIDDLE;
            }
            case BOTTOM: {
                return BOTTOM;
            }
        }
        return SINGLE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction clickedFace = context.m_43719_();
        BlockState blockstate = this.m_49966_();
        if (level.m_276867_(pos)) {
            blockstate = (BlockState)blockstate.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return clickedFace != Direction.DOWN ? (BlockState)((BlockState)blockstate.m_61124_((Property)FACING, (Comparable)clickedFace)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)) : null;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (state.m_61143_((Property)FACING) == Direction.UP && (direction == Direction.UP || direction == Direction.DOWN)) {
            return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
        }
        return state;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos facingPos = pos.m_121945_(direction.m_122424_());
        BlockState facingState = level.m_8055_(facingPos);
        return direction == Direction.UP || facingState.m_60783_((BlockGetter)level, facingPos, direction);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered;
        if (level.f_46443_) {
            return;
        }
        BlockState below = level.m_8055_(pos.m_7495_());
        boolean bl = powered = level.m_276867_(pos) || below.m_60734_() instanceof LampBlock && (Boolean)below.m_61143_((Property)POWERED) != false;
        if (powered != (Boolean)state.m_61143_((Property)POWERED)) {
            if ((Boolean)state.m_61143_((Property)LIT) != powered) {
                state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(powered));
                level.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered));
        }
        level.m_7731_(pos, state, 3);
        VerticalConnectionType type = this.getType(state, level.m_8055_(pos.m_7494_()), level.m_8055_(pos.m_7495_()));
        state = (BlockState)state.m_61124_(VERTICAL, (Comparable)((Object)type));
        level.m_7731_(pos, state, 3);
    }

    public VerticalConnectionType getType(BlockState state, BlockState above, BlockState below) {
        boolean up = this.isConnected(state, above);
        boolean down = this.isConnected(state, below);
        if (up && down) {
            return VerticalConnectionType.MIDDLE;
        }
        if (up) {
            return VerticalConnectionType.BOTTOM;
        }
        if (down) {
            return VerticalConnectionType.TOP;
        }
        return VerticalConnectionType.SINGLE;
    }

    public boolean isConnected(BlockState state, BlockState other) {
        return other.m_60713_(state.m_60734_()) && other.m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        BlockState below = level.m_8055_(pos.m_7495_());
        BlockState above = level.m_8055_(pos.m_7494_());
        ColorType colorBelow = below.m_60734_() instanceof LampBlock ? (ColorType)((Object)below.m_61143_(COLOR)) : null;
        ColorType colorAbove = above.m_60734_() instanceof LampBlock ? (ColorType)((Object)above.m_61143_(COLOR)) : null;
        ColorType newColor = (ColorType)((Object)state.m_61143_(COLOR));
        boolean shouldDropDye = false;
        if (colorBelow != null && colorBelow.equals((Object)ColorType.WHITE) && colorAbove != null) {
            newColor = colorAbove;
        } else if (colorBelow != null && !colorBelow.equals((Object)ColorType.WHITE)) {
            newColor = colorBelow;
            if (colorAbove != null && !colorBelow.equals((Object)colorAbove)) {
                shouldDropDye = true;
            }
        } else if (colorAbove != null) {
            newColor = colorAbove;
        }
        if (newColor != null && !newColor.equals(state.m_61143_(COLOR))) {
            ItemStack dyeItem;
            state = (BlockState)state.m_61124_(COLOR, (Comparable)((Object)newColor));
            level.m_7731_(pos, state, 3);
            this.updateBlockEntityColor(level, pos, state);
            if (shouldDropDye && colorAbove != null && !colorBelow.equals((Object)ColorType.WHITE) && !(dyeItem = colorAbove.getDyeItemStack()).m_41619_()) {
                LampBlock.m_49840_((Level)level, (BlockPos)pos.m_7494_(), (ItemStack)dyeItem);
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        if (state.m_60734_() != newState.m_60734_()) {
            this.updateBlockEntityColor(level, pos, state);
        }
    }

    private void updateBlockEntityColor(Level level, BlockPos pos, BlockState state) {
        ColorType color = (ColorType)((Object)state.m_61143_(COLOR));
        state.m_61124_(COLOR, (Comparable)((Object)color));
        level.m_7260_(pos, state, state, 3);
    }

    public static ColorType getColorTypeFromDye(DyeColor dyeColor) {
        for (ColorType colorType : ColorType.values()) {
            if (colorType.getDyeColor() != dyeColor) continue;
            return colorType;
        }
        return ColorType.WHITE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        DyeColor dye;
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof HammerItem || item instanceof WrenchItem) {
            return InteractionResult.FAIL;
        }
        this.useWithoutItem(state, level, pos, player, hit);
        Item item2 = stack.m_41720_();
        if (item2 instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item2;
            v0 = dyeItem.m_41089_();
        } else {
            v0 = dye = null;
        }
        if (dye != null) {
            ColorType newColorType = LampBlock.getColorTypeFromDye(dye);
            this.dyeConnectedBlocks(level, pos, newColorType);
            state = (BlockState)state.m_61124_(COLOR, (Comparable)((Object)newColorType));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            level.m_7731_(pos, state, 3);
            level.m_7260_(pos, state, state, 3);
            return InteractionResult.SUCCESS;
        }
        if (player.m_21120_(hand).m_204117_(ModItemTags.LAMPS) && state.m_61143_((Property)FACING) == Direction.UP && hit.m_82434_() == Direction.UP) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        state = (BlockState)state.m_61122_((Property)LIT);
        level.m_7731_(pos, state, 3);
        level.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private void dyeConnectedBlocks(Level level, BlockPos startPos, ColorType color) {
        BlockState startState = level.m_8055_(startPos);
        if (startState.m_60734_() instanceof LampBlock && startState.m_61143_(COLOR) != color) {
            level.m_7731_(startPos, (BlockState)startState.m_61124_(COLOR, (Comparable)((Object)color)), 3);
            this.updateBlockEntityColor(level, startPos, (BlockState)startState.m_61124_(COLOR, (Comparable)((Object)color)));
            this.dyeBlocksInDirection(level, startPos.m_122032_().m_122173_(Direction.UP), Direction.UP, color);
            this.dyeBlocksInDirection(level, startPos.m_122032_().m_122173_(Direction.DOWN), Direction.DOWN, color);
        }
    }

    private void dyeBlocksInDirection(Level level, BlockPos.MutableBlockPos pos, Direction direction, ColorType color) {
        BlockState state = level.m_8055_((BlockPos)pos);
        while (state.m_60734_() instanceof LampBlock && state.m_61143_(COLOR) != color) {
            level.m_7731_((BlockPos)pos, (BlockState)state.m_61124_(COLOR, (Comparable)((Object)color)), 3);
            this.updateBlockEntityColor(level, (BlockPos)pos, (BlockState)state.m_61124_(COLOR, (Comparable)((Object)color)));
            pos.m_122173_(direction);
            state = level.m_8055_((BlockPos)pos);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, LIT, POWERED, FACING, VERTICAL, COLOR});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public DyeColor getColor() {
        return ((ColorType)((Object)this.m_49966_().m_61143_(COLOR))).getDyeColor();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new LockableBlockEntity(pos, state);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.connectable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.lockable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.hammerable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }

    @Override
    public List<Property<?>> getHammerableProperties() {
        return List.of(VERTICAL);
    }

    @Override
    public BlockState updateAfterCycle(BlockState state, LevelAccessor level, BlockPos pos) {
        return WrenchItem.WrenchableBlock.super.updateAfterCycle(state, level, pos);
    }

    static {
        LampBlock.WALL[0] = ShapeUtil.rotateShape(WALL_NORTH, Direction.SOUTH);
        LampBlock.WALL[1] = ShapeUtil.rotateShape(WALL_NORTH, Direction.WEST);
        LampBlock.WALL[2] = ShapeUtil.rotateShape(WALL_NORTH, Direction.NORTH);
        LampBlock.WALL[3] = ShapeUtil.rotateShape(WALL_NORTH, Direction.EAST);
    }
}

