/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.stream.Stream;
import net.lyivx.ls_furniture.common.blocks.properties.ModBlockStateProperties;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RoofSteepBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty IS_DOUBLE = ModBlockStateProperties.IS_DOUBLE;
    private final Block base;
    private final BlockState baseState;
    protected static final VoxelShape BOTTOM_SHAPE_STRAIGHT = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape BOTTOM_SHAPE_INNER_LEFT = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), Block.m_49796_((double)12.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0), Block.m_49796_((double)0.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape BOTTOM_SHAPE_INNER_RIGHT = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0), Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)4.0, (double)16.0, (double)12.0), Block.m_49796_((double)0.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape BOTTOM_SHAPE_OUTER_LEFT = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)12.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape BOTTOM_SHAPE_OUTER_RIGHT = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape TOP_SHAPE_STRAIGHT = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape TOP_SHAPE_INNER_LEFT = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape TOP_SHAPE_INNER_RIGHT = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)12.0), Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape TOP_SHAPE_OUTER_LEFT = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape TOP_SHAPE_OUTER_RIGHT = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape DOUBLE_BOTTOM_SHAPE_STRAIGHT = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape DOUBLE_BOTTOM_SHAPE_INNER_LEFT = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)8.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)4.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape DOUBLE_BOTTOM_SHAPE_INNER_RIGHT = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)8.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape DOUBLE_BOTTOM_SHAPE_OUTER_LEFT = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape DOUBLE_BOTTOM_SHAPE_OUTER_RIGHT = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape DOUBLE_TOP_SHAPE_STRAIGHT = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape DOUBLE_TOP_SHAPE_INNER_LEFT = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0), Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape DOUBLE_TOP_SHAPE_INNER_RIGHT = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)4.0), Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape DOUBLE_TOP_SHAPE_OUTER_LEFT = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape DOUBLE_TOP_SHAPE_OUTER_RIGHT = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape[] BOTTOM_SHAPES_STRAIGHT = new VoxelShape[4];
    private static final VoxelShape[] BOTTOM_SHAPES_INNER_LEFT;
    private static final VoxelShape[] BOTTOM_SHAPES_INNER_RIGHT;
    private static final VoxelShape[] BOTTOM_SHAPES_OUTER_LEFT;
    private static final VoxelShape[] BOTTOM_SHAPES_OUTER_RIGHT;
    private static final VoxelShape[] TOP_SHAPES_STRAIGHT;
    private static final VoxelShape[] TOP_SHAPES_INNER_LEFT;
    private static final VoxelShape[] TOP_SHAPES_INNER_RIGHT;
    private static final VoxelShape[] TOP_SHAPES_OUTER_LEFT;
    private static final VoxelShape[] TOP_SHAPES_OUTER_RIGHT;
    private static final VoxelShape[] DOUBLE_BOTTOM_SHAPES_STRAIGHT;
    private static final VoxelShape[] DOUBLE_BOTTOM_SHAPES_INNER_LEFT;
    private static final VoxelShape[] DOUBLE_BOTTOM_SHAPES_INNER_RIGHT;
    private static final VoxelShape[] DOUBLE_BOTTOM_SHAPES_OUTER_LEFT;
    private static final VoxelShape[] DOUBLE_BOTTOM_SHAPES_OUTER_RIGHT;
    private static final VoxelShape[] DOUBLE_TOP_SHAPES_STRAIGHT;
    private static final VoxelShape[] DOUBLE_TOP_SHAPES_INNER_LEFT;
    private static final VoxelShape[] DOUBLE_TOP_SHAPES_INNER_RIGHT;
    private static final VoxelShape[] DOUBLE_TOP_SHAPES_OUTER_LEFT;
    private static final VoxelShape[] DOUBLE_TOP_SHAPES_OUTER_RIGHT;

    public RoofSteepBlock(BlockState baseState, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_DOUBLE, (Comparable)Boolean.valueOf(false)));
        this.base = baseState.m_60734_();
        this.baseState = baseState;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        boolean isTOP = state.m_61143_(HALF) == Half.TOP;
        boolean isDOUBLE = (Boolean)state.m_61143_((Property)IS_DOUBLE);
        StairsShape shape = (StairsShape)state.m_61143_(SHAPE);
        if (!isTOP) {
            if (!isDOUBLE) {
                if (shape.equals((Object)StairsShape.STRAIGHT)) {
                    return BOTTOM_SHAPES_STRAIGHT[direction.m_122416_()];
                }
                if (shape.equals((Object)StairsShape.INNER_LEFT)) {
                    return BOTTOM_SHAPES_INNER_LEFT[direction.m_122416_()];
                }
                if (shape.equals((Object)StairsShape.INNER_RIGHT)) {
                    return BOTTOM_SHAPES_INNER_RIGHT[direction.m_122416_()];
                }
                if (shape.equals((Object)StairsShape.OUTER_LEFT)) {
                    return BOTTOM_SHAPES_OUTER_LEFT[direction.m_122416_()];
                }
                if (shape.equals((Object)StairsShape.OUTER_RIGHT)) {
                    return BOTTOM_SHAPES_OUTER_RIGHT[direction.m_122416_()];
                }
            } else {
                if (shape.equals((Object)StairsShape.STRAIGHT)) {
                    return DOUBLE_BOTTOM_SHAPES_STRAIGHT[direction.m_122416_()];
                }
                if (shape.equals((Object)StairsShape.INNER_LEFT)) {
                    return DOUBLE_BOTTOM_SHAPES_INNER_LEFT[direction.m_122416_()];
                }
                if (shape.equals((Object)StairsShape.INNER_RIGHT)) {
                    return DOUBLE_BOTTOM_SHAPES_INNER_RIGHT[direction.m_122416_()];
                }
                if (shape.equals((Object)StairsShape.OUTER_LEFT)) {
                    return DOUBLE_BOTTOM_SHAPES_OUTER_LEFT[direction.m_122416_()];
                }
                if (shape.equals((Object)StairsShape.OUTER_RIGHT)) {
                    return DOUBLE_BOTTOM_SHAPES_OUTER_RIGHT[direction.m_122416_()];
                }
            }
        } else if (!isDOUBLE) {
            if (shape.equals((Object)StairsShape.STRAIGHT)) {
                return TOP_SHAPES_STRAIGHT[direction.m_122416_()];
            }
            if (shape.equals((Object)StairsShape.INNER_LEFT)) {
                return TOP_SHAPES_INNER_LEFT[direction.m_122416_()];
            }
            if (shape.equals((Object)StairsShape.INNER_RIGHT)) {
                return TOP_SHAPES_INNER_RIGHT[direction.m_122416_()];
            }
            if (shape.equals((Object)StairsShape.OUTER_LEFT)) {
                return TOP_SHAPES_OUTER_LEFT[direction.m_122416_()];
            }
            if (shape.equals((Object)StairsShape.OUTER_RIGHT)) {
                return TOP_SHAPES_OUTER_RIGHT[direction.m_122416_()];
            }
        } else {
            if (shape.equals((Object)StairsShape.STRAIGHT)) {
                return DOUBLE_TOP_SHAPES_STRAIGHT[direction.m_122416_()];
            }
            if (shape.equals((Object)StairsShape.INNER_LEFT)) {
                return DOUBLE_TOP_SHAPES_INNER_LEFT[direction.m_122416_()];
            }
            if (shape.equals((Object)StairsShape.INNER_RIGHT)) {
                return DOUBLE_TOP_SHAPES_INNER_RIGHT[direction.m_122416_()];
            }
            if (shape.equals((Object)StairsShape.OUTER_LEFT)) {
                return DOUBLE_TOP_SHAPES_OUTER_LEFT[direction.m_122416_()];
            }
            if (shape.equals((Object)StairsShape.OUTER_RIGHT)) {
                return DOUBLE_TOP_SHAPES_OUTER_RIGHT[direction.m_122416_()];
            }
        }
        return BOTTOM_SHAPES_STRAIGHT[direction.m_122416_()];
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        this.base.m_214162_(state, level, pos, random);
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        this.baseState.m_60686_(level, pos, player);
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        this.base.m_6786_(level, pos, state);
    }

    public float m_7325_() {
        return this.base.m_7325_();
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (!state.m_60713_(state.m_60734_())) {
            level.m_213960_(this.baseState, pos, Blocks.f_50016_, pos, false);
            this.base.m_6807_(this.baseState, level, pos, oldState, false);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.m_60713_(newState.m_60734_())) {
            this.baseState.m_60753_(level, pos, newState, movedByPiston);
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        this.base.m_141947_(level, pos, state, entity);
    }

    public boolean m_6724_(BlockState state) {
        return this.base.m_6724_(state);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.base.m_213898_(state, level, pos, random);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.base.m_213897_(state, level, pos, random);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (state.m_61143_(HALF) == Half.BOTTOM ? hit.m_82434_() != ((Direction)state.m_61143_((Property)FACING)).m_122424_() : hit.m_82434_() != state.m_61143_((Property)FACING)) {
            return InteractionResult.FAIL;
        }
        if (!level.m_5776_() && stack.m_41720_() == this.m_5456_()) {
            BlockState newState = (BlockState)state.m_61124_((Property)IS_DOUBLE, (Comparable)Boolean.valueOf(true));
            level.m_7731_(pos, newState, 3);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return this.baseState.m_60664_(level, player, hand, hit);
    }

    private <T extends Comparable<T>> BlockState copyProperty(BlockState fromState, BlockState toState, Property<T> property) {
        Comparable value = fromState.m_61143_(property);
        return (BlockState)toState.m_61124_(property, value);
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        this.base.m_7592_(level, pos, explosion);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        BlockPos blockPos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(blockPos);
        BlockState blockState = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)blockPos.m_123342_() > 0.5) ? Half.BOTTOM : Half.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return (BlockState)blockState.m_61124_(SHAPE, (Comparable)RoofSteepBlock.getStairsShape(blockState, (BlockGetter)context.m_43725_(), blockPos));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction.m_122434_().m_122479_() ? (BlockState)state.m_61124_(SHAPE, (Comparable)RoofSteepBlock.getStairsShape(state, (BlockGetter)level, pos)) : super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    private static StairsShape getStairsShape(BlockState state, BlockGetter level, BlockPos pos) {
        Direction direction3;
        Direction direction2;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockState blockState = level.m_8055_(pos.m_121945_(direction));
        if (RoofSteepBlock.isStairs(blockState) && state.m_61143_(HALF) == blockState.m_61143_(HALF) && (direction2 = (Direction)blockState.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && RoofSteepBlock.canTakeShape(state, level, pos, direction2.m_122424_())) {
            if (direction2 == direction.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockState2 = level.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (RoofSteepBlock.isStairs(blockState2) && state.m_61143_(HALF) == blockState2.m_61143_(HALF) && (direction3 = (Direction)blockState2.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && RoofSteepBlock.canTakeShape(state, level, pos, direction3)) {
            if (direction3 == direction.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        BlockState blockState = level.m_8055_(pos.m_121945_(face));
        return !RoofSteepBlock.isStairs(blockState) || blockState.m_61143_((Property)FACING) != state.m_61143_((Property)FACING) || blockState.m_61143_(HALF) != state.m_61143_(HALF);
    }

    public static boolean isStairs(BlockState state) {
        return state.m_60734_() instanceof RoofSteepBlock;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        StairsShape stairsShape = (StairsShape)state.m_61143_(SHAPE);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                switch (stairsShape) {
                    case INNER_LEFT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return state.m_60717_(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                switch (stairsShape) {
                    case INNER_LEFT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return state.m_60717_(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.m_6943_(state, mirror);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF, SHAPE, WATERLOGGED, IS_DOUBLE});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    static {
        RoofSteepBlock.BOTTOM_SHAPES_STRAIGHT[0] = ShapeUtil.rotateShape(BOTTOM_SHAPE_STRAIGHT, Direction.NORTH);
        RoofSteepBlock.BOTTOM_SHAPES_STRAIGHT[1] = ShapeUtil.rotateShape(BOTTOM_SHAPE_STRAIGHT, Direction.EAST);
        RoofSteepBlock.BOTTOM_SHAPES_STRAIGHT[2] = ShapeUtil.rotateShape(BOTTOM_SHAPE_STRAIGHT, Direction.SOUTH);
        RoofSteepBlock.BOTTOM_SHAPES_STRAIGHT[3] = ShapeUtil.rotateShape(BOTTOM_SHAPE_STRAIGHT, Direction.WEST);
        BOTTOM_SHAPES_INNER_LEFT = new VoxelShape[4];
        RoofSteepBlock.BOTTOM_SHAPES_INNER_LEFT[0] = ShapeUtil.rotateShape(BOTTOM_SHAPE_INNER_LEFT, Direction.NORTH);
        RoofSteepBlock.BOTTOM_SHAPES_INNER_LEFT[1] = ShapeUtil.rotateShape(BOTTOM_SHAPE_INNER_LEFT, Direction.EAST);
        RoofSteepBlock.BOTTOM_SHAPES_INNER_LEFT[2] = ShapeUtil.rotateShape(BOTTOM_SHAPE_INNER_LEFT, Direction.SOUTH);
        RoofSteepBlock.BOTTOM_SHAPES_INNER_LEFT[3] = ShapeUtil.rotateShape(BOTTOM_SHAPE_INNER_LEFT, Direction.WEST);
        BOTTOM_SHAPES_INNER_RIGHT = new VoxelShape[4];
        RoofSteepBlock.BOTTOM_SHAPES_INNER_RIGHT[0] = ShapeUtil.rotateShape(BOTTOM_SHAPE_INNER_RIGHT, Direction.NORTH);
        RoofSteepBlock.BOTTOM_SHAPES_INNER_RIGHT[1] = ShapeUtil.rotateShape(BOTTOM_SHAPE_INNER_RIGHT, Direction.EAST);
        RoofSteepBlock.BOTTOM_SHAPES_INNER_RIGHT[2] = ShapeUtil.rotateShape(BOTTOM_SHAPE_INNER_RIGHT, Direction.SOUTH);
        RoofSteepBlock.BOTTOM_SHAPES_INNER_RIGHT[3] = ShapeUtil.rotateShape(BOTTOM_SHAPE_INNER_RIGHT, Direction.WEST);
        BOTTOM_SHAPES_OUTER_LEFT = new VoxelShape[4];
        RoofSteepBlock.BOTTOM_SHAPES_OUTER_LEFT[0] = ShapeUtil.rotateShape(BOTTOM_SHAPE_OUTER_LEFT, Direction.NORTH);
        RoofSteepBlock.BOTTOM_SHAPES_OUTER_LEFT[1] = ShapeUtil.rotateShape(BOTTOM_SHAPE_OUTER_LEFT, Direction.EAST);
        RoofSteepBlock.BOTTOM_SHAPES_OUTER_LEFT[2] = ShapeUtil.rotateShape(BOTTOM_SHAPE_OUTER_LEFT, Direction.SOUTH);
        RoofSteepBlock.BOTTOM_SHAPES_OUTER_LEFT[3] = ShapeUtil.rotateShape(BOTTOM_SHAPE_OUTER_LEFT, Direction.WEST);
        BOTTOM_SHAPES_OUTER_RIGHT = new VoxelShape[4];
        RoofSteepBlock.BOTTOM_SHAPES_OUTER_RIGHT[0] = ShapeUtil.rotateShape(BOTTOM_SHAPE_OUTER_RIGHT, Direction.NORTH);
        RoofSteepBlock.BOTTOM_SHAPES_OUTER_RIGHT[1] = ShapeUtil.rotateShape(BOTTOM_SHAPE_OUTER_RIGHT, Direction.EAST);
        RoofSteepBlock.BOTTOM_SHAPES_OUTER_RIGHT[2] = ShapeUtil.rotateShape(BOTTOM_SHAPE_OUTER_RIGHT, Direction.SOUTH);
        RoofSteepBlock.BOTTOM_SHAPES_OUTER_RIGHT[3] = ShapeUtil.rotateShape(BOTTOM_SHAPE_OUTER_RIGHT, Direction.WEST);
        TOP_SHAPES_STRAIGHT = new VoxelShape[4];
        RoofSteepBlock.TOP_SHAPES_STRAIGHT[0] = ShapeUtil.rotateShape(TOP_SHAPE_STRAIGHT, Direction.NORTH);
        RoofSteepBlock.TOP_SHAPES_STRAIGHT[1] = ShapeUtil.rotateShape(TOP_SHAPE_STRAIGHT, Direction.EAST);
        RoofSteepBlock.TOP_SHAPES_STRAIGHT[2] = ShapeUtil.rotateShape(TOP_SHAPE_STRAIGHT, Direction.SOUTH);
        RoofSteepBlock.TOP_SHAPES_STRAIGHT[3] = ShapeUtil.rotateShape(TOP_SHAPE_STRAIGHT, Direction.WEST);
        TOP_SHAPES_INNER_LEFT = new VoxelShape[4];
        RoofSteepBlock.TOP_SHAPES_INNER_LEFT[0] = ShapeUtil.rotateShape(TOP_SHAPE_INNER_LEFT, Direction.NORTH);
        RoofSteepBlock.TOP_SHAPES_INNER_LEFT[1] = ShapeUtil.rotateShape(TOP_SHAPE_INNER_LEFT, Direction.EAST);
        RoofSteepBlock.TOP_SHAPES_INNER_LEFT[2] = ShapeUtil.rotateShape(TOP_SHAPE_INNER_LEFT, Direction.SOUTH);
        RoofSteepBlock.TOP_SHAPES_INNER_LEFT[3] = ShapeUtil.rotateShape(TOP_SHAPE_INNER_LEFT, Direction.WEST);
        TOP_SHAPES_INNER_RIGHT = new VoxelShape[4];
        RoofSteepBlock.TOP_SHAPES_INNER_RIGHT[0] = ShapeUtil.rotateShape(TOP_SHAPE_INNER_RIGHT, Direction.NORTH);
        RoofSteepBlock.TOP_SHAPES_INNER_RIGHT[1] = ShapeUtil.rotateShape(TOP_SHAPE_INNER_RIGHT, Direction.EAST);
        RoofSteepBlock.TOP_SHAPES_INNER_RIGHT[2] = ShapeUtil.rotateShape(TOP_SHAPE_INNER_RIGHT, Direction.SOUTH);
        RoofSteepBlock.TOP_SHAPES_INNER_RIGHT[3] = ShapeUtil.rotateShape(TOP_SHAPE_INNER_RIGHT, Direction.WEST);
        TOP_SHAPES_OUTER_LEFT = new VoxelShape[4];
        RoofSteepBlock.TOP_SHAPES_OUTER_LEFT[0] = ShapeUtil.rotateShape(TOP_SHAPE_OUTER_LEFT, Direction.NORTH);
        RoofSteepBlock.TOP_SHAPES_OUTER_LEFT[1] = ShapeUtil.rotateShape(TOP_SHAPE_OUTER_LEFT, Direction.EAST);
        RoofSteepBlock.TOP_SHAPES_OUTER_LEFT[2] = ShapeUtil.rotateShape(TOP_SHAPE_OUTER_LEFT, Direction.SOUTH);
        RoofSteepBlock.TOP_SHAPES_OUTER_LEFT[3] = ShapeUtil.rotateShape(TOP_SHAPE_OUTER_LEFT, Direction.WEST);
        TOP_SHAPES_OUTER_RIGHT = new VoxelShape[4];
        RoofSteepBlock.TOP_SHAPES_OUTER_RIGHT[0] = ShapeUtil.rotateShape(TOP_SHAPE_OUTER_RIGHT, Direction.NORTH);
        RoofSteepBlock.TOP_SHAPES_OUTER_RIGHT[1] = ShapeUtil.rotateShape(TOP_SHAPE_OUTER_RIGHT, Direction.EAST);
        RoofSteepBlock.TOP_SHAPES_OUTER_RIGHT[2] = ShapeUtil.rotateShape(TOP_SHAPE_OUTER_RIGHT, Direction.SOUTH);
        RoofSteepBlock.TOP_SHAPES_OUTER_RIGHT[3] = ShapeUtil.rotateShape(TOP_SHAPE_OUTER_RIGHT, Direction.WEST);
        DOUBLE_BOTTOM_SHAPES_STRAIGHT = new VoxelShape[4];
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_STRAIGHT[0] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_STRAIGHT, Direction.NORTH);
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_STRAIGHT[1] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_STRAIGHT, Direction.EAST);
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_STRAIGHT[2] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_STRAIGHT, Direction.SOUTH);
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_STRAIGHT[3] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_STRAIGHT, Direction.WEST);
        DOUBLE_BOTTOM_SHAPES_INNER_LEFT = new VoxelShape[4];
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_INNER_LEFT[0] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_INNER_LEFT, Direction.NORTH);
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_INNER_LEFT[1] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_INNER_LEFT, Direction.EAST);
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_INNER_LEFT[2] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_INNER_LEFT, Direction.SOUTH);
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_INNER_LEFT[3] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_INNER_LEFT, Direction.WEST);
        DOUBLE_BOTTOM_SHAPES_INNER_RIGHT = new VoxelShape[4];
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_INNER_RIGHT[0] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_INNER_RIGHT, Direction.NORTH);
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_INNER_RIGHT[1] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_INNER_RIGHT, Direction.EAST);
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_INNER_RIGHT[2] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_INNER_RIGHT, Direction.SOUTH);
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_INNER_RIGHT[3] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_INNER_RIGHT, Direction.WEST);
        DOUBLE_BOTTOM_SHAPES_OUTER_LEFT = new VoxelShape[4];
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_OUTER_LEFT[0] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_OUTER_LEFT, Direction.NORTH);
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_OUTER_LEFT[1] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_OUTER_LEFT, Direction.EAST);
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_OUTER_LEFT[2] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_OUTER_LEFT, Direction.SOUTH);
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_OUTER_LEFT[3] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_OUTER_LEFT, Direction.WEST);
        DOUBLE_BOTTOM_SHAPES_OUTER_RIGHT = new VoxelShape[4];
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_OUTER_RIGHT[0] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_OUTER_RIGHT, Direction.NORTH);
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_OUTER_RIGHT[1] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_OUTER_RIGHT, Direction.EAST);
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_OUTER_RIGHT[2] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_OUTER_RIGHT, Direction.SOUTH);
        RoofSteepBlock.DOUBLE_BOTTOM_SHAPES_OUTER_RIGHT[3] = ShapeUtil.rotateShape(DOUBLE_BOTTOM_SHAPE_OUTER_RIGHT, Direction.WEST);
        DOUBLE_TOP_SHAPES_STRAIGHT = new VoxelShape[4];
        RoofSteepBlock.DOUBLE_TOP_SHAPES_STRAIGHT[0] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_STRAIGHT, Direction.NORTH);
        RoofSteepBlock.DOUBLE_TOP_SHAPES_STRAIGHT[1] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_STRAIGHT, Direction.EAST);
        RoofSteepBlock.DOUBLE_TOP_SHAPES_STRAIGHT[2] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_STRAIGHT, Direction.SOUTH);
        RoofSteepBlock.DOUBLE_TOP_SHAPES_STRAIGHT[3] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_STRAIGHT, Direction.WEST);
        DOUBLE_TOP_SHAPES_INNER_LEFT = new VoxelShape[4];
        RoofSteepBlock.DOUBLE_TOP_SHAPES_INNER_LEFT[0] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_INNER_LEFT, Direction.NORTH);
        RoofSteepBlock.DOUBLE_TOP_SHAPES_INNER_LEFT[1] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_INNER_LEFT, Direction.EAST);
        RoofSteepBlock.DOUBLE_TOP_SHAPES_INNER_LEFT[2] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_INNER_LEFT, Direction.SOUTH);
        RoofSteepBlock.DOUBLE_TOP_SHAPES_INNER_LEFT[3] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_INNER_LEFT, Direction.WEST);
        DOUBLE_TOP_SHAPES_INNER_RIGHT = new VoxelShape[4];
        RoofSteepBlock.DOUBLE_TOP_SHAPES_INNER_RIGHT[0] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_INNER_RIGHT, Direction.NORTH);
        RoofSteepBlock.DOUBLE_TOP_SHAPES_INNER_RIGHT[1] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_INNER_RIGHT, Direction.EAST);
        RoofSteepBlock.DOUBLE_TOP_SHAPES_INNER_RIGHT[2] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_INNER_RIGHT, Direction.SOUTH);
        RoofSteepBlock.DOUBLE_TOP_SHAPES_INNER_RIGHT[3] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_INNER_RIGHT, Direction.WEST);
        DOUBLE_TOP_SHAPES_OUTER_LEFT = new VoxelShape[4];
        RoofSteepBlock.DOUBLE_TOP_SHAPES_OUTER_LEFT[0] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_OUTER_LEFT, Direction.NORTH);
        RoofSteepBlock.DOUBLE_TOP_SHAPES_OUTER_LEFT[1] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_OUTER_LEFT, Direction.EAST);
        RoofSteepBlock.DOUBLE_TOP_SHAPES_OUTER_LEFT[2] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_OUTER_LEFT, Direction.SOUTH);
        RoofSteepBlock.DOUBLE_TOP_SHAPES_OUTER_LEFT[3] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_OUTER_LEFT, Direction.WEST);
        DOUBLE_TOP_SHAPES_OUTER_RIGHT = new VoxelShape[4];
        RoofSteepBlock.DOUBLE_TOP_SHAPES_OUTER_RIGHT[0] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_OUTER_RIGHT, Direction.NORTH);
        RoofSteepBlock.DOUBLE_TOP_SHAPES_OUTER_RIGHT[1] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_OUTER_RIGHT, Direction.EAST);
        RoofSteepBlock.DOUBLE_TOP_SHAPES_OUTER_RIGHT[2] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_OUTER_RIGHT, Direction.SOUTH);
        RoofSteepBlock.DOUBLE_TOP_SHAPES_OUTER_RIGHT[3] = ShapeUtil.rotateShape(DOUBLE_TOP_SHAPE_OUTER_RIGHT, Direction.WEST);
    }
}

