/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import net.lyivx.ls_furniture.common.blocks.entity.LockableBlockEntity;
import net.lyivx.ls_furniture.common.blocks.properties.ModBlockStateProperties;
import net.lyivx.ls_furniture.common.items.HammerItem;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.lyivx.ls_furniture.common.utils.block.ILockable;
import net.lyivx.ls_furniture.registry.ModBlocksTags;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TableBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
WrenchItem.WrenchableBlock,
HammerItem.HammerableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LEG1 = ModBlockStateProperties.NORTH_TABLE;
    public static final BooleanProperty LEG2 = ModBlockStateProperties.EAST_TABLE;
    public static final BooleanProperty LEG3 = ModBlockStateProperties.SOUTH_TABLE;
    public static final BooleanProperty LEG4 = ModBlockStateProperties.WEST_TABLE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty UPDATE = ModBlockStateProperties.UPDATE;
    protected static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape LEG_1 = Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)3.0);
    protected static final VoxelShape LEG_2 = ShapeUtil.rotateShape(LEG_1, Direction.EAST);
    protected static final VoxelShape LEG_3 = ShapeUtil.rotateShape(LEG_1, Direction.SOUTH);
    protected static final VoxelShape LEG_4 = ShapeUtil.rotateShape(LEG_1, Direction.WEST);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{TOP, Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)LEG_1), Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)LEG_2), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2}), Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)LEG_3), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_3}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_2, LEG_3}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2, LEG_3}), Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)LEG_4), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_2, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_3, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_3, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_2, LEG_3, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2, LEG_3, LEG_4})};

    public TableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LEG1, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEG2, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEG3, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEG4, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int shape = 0;
        if (((Boolean)state.m_61143_((Property)LEG1)).booleanValue()) {
            ++shape;
        }
        if (((Boolean)state.m_61143_((Property)LEG2)).booleanValue()) {
            shape += 2;
        }
        if (((Boolean)state.m_61143_((Property)LEG3)).booleanValue()) {
            shape += 4;
        }
        if (((Boolean)state.m_61143_((Property)LEG4)).booleanValue()) {
            shape += 8;
        }
        return SHAPES[shape];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        return this.getConnections(state, (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        ILockable lockable;
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if ((blockEntity = level.m_7702_(currentPos)) instanceof ILockable && (lockable = (ILockable)blockEntity).isLocked()) {
            return state;
        }
        return this.getConnections(state, level, currentPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LEG1, LEG2, LEG3, LEG4, UPDATE, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        boolean leg1 = (Boolean)state.m_61143_((Property)LEG1);
        boolean leg2 = (Boolean)state.m_61143_((Property)LEG2);
        boolean leg3 = (Boolean)state.m_61143_((Property)LEG3);
        boolean leg4 = (Boolean)state.m_61143_((Property)LEG4);
        return switch (rotation) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)LEG1, (Comparable)Boolean.valueOf(leg4))).m_61124_((Property)LEG2, (Comparable)Boolean.valueOf(leg1))).m_61124_((Property)LEG3, (Comparable)Boolean.valueOf(leg2))).m_61124_((Property)LEG4, (Comparable)Boolean.valueOf(leg3));
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)LEG1, (Comparable)Boolean.valueOf(leg3))).m_61124_((Property)LEG2, (Comparable)Boolean.valueOf(leg4))).m_61124_((Property)LEG3, (Comparable)Boolean.valueOf(leg1))).m_61124_((Property)LEG4, (Comparable)Boolean.valueOf(leg2));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)LEG1, (Comparable)Boolean.valueOf(leg2))).m_61124_((Property)LEG2, (Comparable)Boolean.valueOf(leg3))).m_61124_((Property)LEG3, (Comparable)Boolean.valueOf(leg4))).m_61124_((Property)LEG4, (Comparable)Boolean.valueOf(leg1));
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockState getConnections(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean north = this.validConnection(level.m_8055_(pos.m_122012_()));
        boolean east = this.validConnection(level.m_8055_(pos.m_122029_()));
        boolean south = this.validConnection(level.m_8055_(pos.m_122019_()));
        boolean west = this.validConnection(level.m_8055_(pos.m_122024_()));
        boolean leg1 = !north && !east || north && east && !this.validConnection(level.m_8055_(pos.m_122012_().m_122029_()));
        boolean leg2 = !east && !south || east && south && !this.validConnection(level.m_8055_(pos.m_122019_().m_122029_()));
        boolean leg3 = !south && !west || south && west && !this.validConnection(level.m_8055_(pos.m_122019_().m_122024_()));
        boolean leg4 = !north && !west || north && west && !this.validConnection(level.m_8055_(pos.m_122012_().m_122024_()));
        boolean update = ((north ? 1 : 0) + (east ? 1 : 0) + (south ? 1 : 0) + (west ? 1 : 0)) % 2 == 0;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)LEG1, (Comparable)Boolean.valueOf(leg1))).m_61124_((Property)LEG2, (Comparable)Boolean.valueOf(leg2))).m_61124_((Property)LEG3, (Comparable)Boolean.valueOf(leg3))).m_61124_((Property)LEG4, (Comparable)Boolean.valueOf(leg4))).m_61124_((Property)UPDATE, (Comparable)Boolean.valueOf(update));
    }

    public boolean validConnection(BlockState state) {
        return state.m_204336_(ModBlocksTags.TABLES_CONNECTABLE);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.connectable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.lockable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.hammerable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Override
    public List<Property<?>> getHammerableProperties() {
        return List.of(LEG1, LEG2, LEG3, LEG4);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }

    @Override
    public BlockState updateAfterCycle(BlockState state, LevelAccessor level, BlockPos pos) {
        return WrenchItem.WrenchableBlock.super.updateAfterCycle(state, level, pos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LockableBlockEntity(pos, state);
    }
}

