/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.lyivx.ls_furniture.client.LYIVXsFurnitureModClient;
import net.lyivx.ls_furniture.common.blocks.entity.TombstoneBlockEntity;
import net.lyivx.ls_furniture.common.blocks.properties.ModBlockStateProperties;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TombstoneBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
WrenchItem.WrenchableBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty HAS_DIRT = ModBlockStateProperties.HAS_DIRT;
    protected static final VoxelShape NORTH = Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape DIRT_NORTH = Stream.of(Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)1.75, (double)0.0, (double)3.0, (double)14.25, (double)1.0, (double)14.25), Block.m_49796_((double)2.75, (double)0.0, (double)14.25, (double)13.25, (double)1.0, (double)15.25), Block.m_49796_((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)1.0, (double)3.0), Block.m_49796_((double)4.0, (double)1.0, (double)8.0, (double)12.0, (double)2.0, (double)14.5), Block.m_49796_((double)4.0, (double)1.0, (double)6.0, (double)12.0, (double)2.0, (double)8.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape[] SHAPE = new VoxelShape[4];
    private static final VoxelShape[] DIRT_SHAPE;

    public TombstoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_DIRT, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING, HAS_DIRT});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        boolean hasDirt = (Boolean)state.m_61143_((Property)HAS_DIRT);
        if (!hasDirt) {
            return SHAPE[direction.m_122416_()];
        }
        return DIRT_SHAPE[direction.m_122416_()];
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (item instanceof WrenchItem) {
            return InteractionResult.FAIL;
        }
        if (player.m_6047_()) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)HAS_DIRT), 3);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TombstoneBlockEntity) {
            TombstoneBlockEntity tombstoneBlockEntity = (TombstoneBlockEntity)blockEntity;
            if (tombstoneBlockEntity.isOwner(player) || player.m_7500_()) {
                if (item instanceof DyeItem && tombstoneBlockEntity.getColor() != ((DyeItem)item).m_41089_()) {
                    tombstoneBlockEntity.setColor(((DyeItem)item).m_41089_());
                    level.m_7260_(pos, state, state, 3);
                    level.m_247517_((Player)null, tombstoneBlockEntity.m_58899_(), SoundEvents.f_144133_, SoundSource.BLOCKS);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                if (item == Items.f_151056_ && !tombstoneBlockEntity.isGlowing()) {
                    tombstoneBlockEntity.setGlowing(true);
                    level.m_7260_(pos, state, state, 3);
                    level.m_247517_((Player)null, tombstoneBlockEntity.m_58899_(), SoundEvents.f_144153_, SoundSource.BLOCKS);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                if (item == Items.f_42532_ && tombstoneBlockEntity.isGlowing()) {
                    tombstoneBlockEntity.setGlowing(false);
                    level.m_7260_(pos, state, state, 3);
                    level.m_247517_((Player)null, tombstoneBlockEntity.m_58899_(), SoundEvents.f_144181_, SoundSource.BLOCKS);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                if (!level.f_46443_) {
                    LYIVXsFurnitureModClient.openTombstoneGUI(tombstoneBlockEntity);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TombstoneBlockEntity) {
            TombstoneBlockEntity tombstoneBlockEntity = (TombstoneBlockEntity)blockEntity;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                tombstoneBlockEntity.setOwner(player);
                player.m_5661_((Component)Component.m_237115_((String)"msg.ls_furniture.tombstone.set_owner"), true);
            }
            tombstoneBlockEntity.setWritten(true);
            tombstoneBlockEntity.setColor(DyeColor.BLACK);
            tombstoneBlockEntity.m_6596_();
            level.m_7260_(pos, state, state, 3);
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.tombstone"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TombstoneBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    static {
        TombstoneBlock.SHAPE[0] = ShapeUtil.rotateShape(NORTH, Direction.SOUTH);
        TombstoneBlock.SHAPE[1] = ShapeUtil.rotateShape(NORTH, Direction.WEST);
        TombstoneBlock.SHAPE[2] = ShapeUtil.rotateShape(NORTH, Direction.NORTH);
        TombstoneBlock.SHAPE[3] = ShapeUtil.rotateShape(NORTH, Direction.EAST);
        DIRT_SHAPE = new VoxelShape[4];
        TombstoneBlock.DIRT_SHAPE[0] = ShapeUtil.rotateShape(DIRT_NORTH, Direction.SOUTH);
        TombstoneBlock.DIRT_SHAPE[1] = ShapeUtil.rotateShape(DIRT_NORTH, Direction.WEST);
        TombstoneBlock.DIRT_SHAPE[2] = ShapeUtil.rotateShape(DIRT_NORTH, Direction.NORTH);
        TombstoneBlock.DIRT_SHAPE[3] = ShapeUtil.rotateShape(DIRT_NORTH, Direction.EAST);
    }
}

