/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.Locale;
import java.util.stream.Stream;
import net.lyivx.ls_furniture.common.menus.WorkstationMenu;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkstationBlock
extends HorizontalDirectionalBlock {
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"container.ls_furniture.workstation");
    public static final EnumProperty<WorkstationModelType> MODEL_TYPE = EnumProperty.m_61587_((String)"model", WorkstationModelType.class);
    private static final VoxelShape BASE_LOWER_RIGHT_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)4.0, (double)13.0, (double)4.0), Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)3.0, (double)11.0, (double)3.0), Block.m_49796_((double)1.0, (double)1.0, (double)13.0, (double)3.0, (double)11.0, (double)15.0), Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)11.0, (double)12.0, (double)4.0, (double)13.0, (double)16.0), Block.m_49796_((double)29.0, (double)1.0, (double)13.0, (double)31.0, (double)11.0, (double)15.0), Block.m_49796_((double)28.0, (double)0.0, (double)12.0, (double)32.0, (double)2.0, (double)16.0), Block.m_49796_((double)28.0, (double)11.0, (double)12.0, (double)32.0, (double)13.0, (double)16.0), Block.m_49796_((double)29.0, (double)1.0, (double)1.0, (double)31.0, (double)11.0, (double)3.0), Block.m_49796_((double)28.0, (double)0.0, (double)0.0, (double)32.0, (double)2.0, (double)4.0), Block.m_49796_((double)28.0, (double)11.0, (double)0.0, (double)32.0, (double)13.0, (double)4.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)32.0, (double)16.0, (double)16.0), Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)14.0, (double)3.0, (double)15.0), Block.m_49796_((double)14.25, (double)0.0, (double)2.0, (double)23.35, (double)2.0, (double)12.0), Block.m_49796_((double)16.049999999999997, (double)2.0, (double)2.0, (double)21.15, (double)3.0, (double)12.0), Block.m_49796_((double)5.0, (double)3.0, (double)2.0, (double)14.0, (double)6.0, (double)13.3), Block.m_49796_((double)0.0, (double)16.0, (double)14.0, (double)2.0, (double)26.0, (double)16.0), Block.m_49796_((double)10.0, (double)16.0, (double)14.0, (double)12.0, (double)26.0, (double)16.0), Block.m_49796_((double)20.0, (double)16.0, (double)14.0, (double)22.0, (double)26.0, (double)16.0), Block.m_49796_((double)30.0, (double)16.0, (double)14.0, (double)32.0, (double)26.0, (double)16.0), Block.m_49796_((double)22.0, (double)16.0, (double)14.5, (double)30.0, (double)26.0, (double)15.5), Block.m_49796_((double)12.0, (double)16.0, (double)14.5, (double)20.0, (double)26.0, (double)15.5), Block.m_49796_((double)2.0, (double)16.0, (double)14.5, (double)10.0, (double)26.0, (double)15.5), Block.m_49796_((double)21.2, (double)16.0, (double)3.1999999999999993, (double)31.0, (double)19.0, (double)13.0), Block.m_49796_((double)21.5, (double)19.0, (double)5.0, (double)31.299999999999997, (double)22.0, (double)11.2)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape BASE_UPPER_RIGHT_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)4.0, (double)-14.0, (double)4.0), Block.m_49796_((double)0.0, (double)-5.0, (double)0.0, (double)4.0, (double)-3.0, (double)4.0), Block.m_49796_((double)1.0, (double)-15.0, (double)1.0, (double)3.0, (double)-5.0, (double)3.0), Block.m_49796_((double)1.0, (double)-15.0, (double)13.0, (double)3.0, (double)-5.0, (double)15.0), Block.m_49796_((double)0.0, (double)-16.0, (double)12.0, (double)4.0, (double)-14.0, (double)16.0), Block.m_49796_((double)0.0, (double)-5.0, (double)12.0, (double)4.0, (double)-3.0, (double)16.0), Block.m_49796_((double)29.0, (double)-15.0, (double)13.0, (double)31.0, (double)-5.0, (double)15.0), Block.m_49796_((double)28.0, (double)-16.0, (double)12.0, (double)32.0, (double)-14.0, (double)16.0), Block.m_49796_((double)28.0, (double)-5.0, (double)12.0, (double)32.0, (double)-3.0, (double)16.0), Block.m_49796_((double)29.0, (double)-15.0, (double)1.0, (double)31.0, (double)-5.0, (double)3.0), Block.m_49796_((double)28.0, (double)-16.0, (double)0.0, (double)32.0, (double)-14.0, (double)4.0), Block.m_49796_((double)28.0, (double)-5.0, (double)0.0, (double)32.0, (double)-3.0, (double)4.0), Block.m_49796_((double)0.0, (double)-3.0, (double)0.0, (double)32.0, (double)0.0, (double)16.0), Block.m_49796_((double)5.0, (double)-16.0, (double)0.0, (double)14.0, (double)-13.0, (double)15.0), Block.m_49796_((double)14.25, (double)-16.0, (double)2.0, (double)23.35, (double)-14.0, (double)12.0), Block.m_49796_((double)16.049999999999997, (double)-14.0, (double)2.0, (double)21.15, (double)-13.0, (double)12.0), Block.m_49796_((double)5.0, (double)-13.0, (double)2.0, (double)14.0, (double)-10.0, (double)13.3), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)10.0, (double)16.0), Block.m_49796_((double)10.0, (double)0.0, (double)14.0, (double)12.0, (double)10.0, (double)16.0), Block.m_49796_((double)20.0, (double)0.0, (double)14.0, (double)22.0, (double)10.0, (double)16.0), Block.m_49796_((double)30.0, (double)0.0, (double)14.0, (double)32.0, (double)10.0, (double)16.0), Block.m_49796_((double)22.0, (double)0.0, (double)14.5, (double)30.0, (double)10.0, (double)15.5), Block.m_49796_((double)12.0, (double)0.0, (double)14.5, (double)20.0, (double)10.0, (double)15.5), Block.m_49796_((double)2.0, (double)0.0, (double)14.5, (double)10.0, (double)10.0, (double)15.5), Block.m_49796_((double)21.2, (double)0.0, (double)3.1999999999999993, (double)31.0, (double)3.0, (double)13.0), Block.m_49796_((double)21.5, (double)3.0, (double)5.0, (double)31.3, (double)6.0, (double)11.2)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape BASE_LOWER_LEFT_SHAPE = Stream.of(Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-16.0, (double)11.0, (double)0.0, (double)-12.0, (double)13.0, (double)4.0), Block.m_49796_((double)-15.0, (double)1.0, (double)1.0, (double)-13.0, (double)11.0, (double)3.0), Block.m_49796_((double)-15.0, (double)1.0, (double)13.0, (double)-13.0, (double)11.0, (double)15.0), Block.m_49796_((double)-16.0, (double)0.0, (double)12.0, (double)-12.0, (double)2.0, (double)16.0), Block.m_49796_((double)-16.0, (double)11.0, (double)12.0, (double)-12.0, (double)13.0, (double)16.0), Block.m_49796_((double)13.0, (double)1.0, (double)13.0, (double)15.0, (double)11.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)12.0, (double)11.0, (double)12.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)13.0, (double)1.0, (double)1.0, (double)15.0, (double)11.0, (double)3.0), Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)11.0, (double)0.0, (double)16.0, (double)13.0, (double)4.0), Block.m_49796_((double)-16.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)-11.0, (double)0.0, (double)0.0, (double)-2.0, (double)3.0, (double)15.0), Block.m_49796_((double)-1.75, (double)0.0, (double)2.0, (double)7.350000000000001, (double)2.0, (double)12.0), Block.m_49796_((double)0.04999999999999716, (double)2.0, (double)2.0, (double)5.149999999999999, (double)3.0, (double)12.0), Block.m_49796_((double)-11.0, (double)3.0, (double)2.0, (double)-2.0, (double)6.0, (double)13.3), Block.m_49796_((double)-16.0, (double)16.0, (double)14.0, (double)-14.0, (double)26.0, (double)16.0), Block.m_49796_((double)-6.0, (double)16.0, (double)14.0, (double)-4.0, (double)26.0, (double)16.0), Block.m_49796_((double)4.0, (double)16.0, (double)14.0, (double)6.0, (double)26.0, (double)16.0), Block.m_49796_((double)14.0, (double)16.0, (double)14.0, (double)16.0, (double)26.0, (double)16.0), Block.m_49796_((double)6.0, (double)16.0, (double)14.5, (double)14.0, (double)26.0, (double)15.5), Block.m_49796_((double)-4.0, (double)16.0, (double)14.5, (double)4.0, (double)26.0, (double)15.5), Block.m_49796_((double)-14.0, (double)16.0, (double)14.5, (double)-6.0, (double)26.0, (double)15.5), Block.m_49796_((double)5.199999999999999, (double)16.0, (double)3.1999999999999993, (double)15.0, (double)19.0, (double)13.0), Block.m_49796_((double)5.5, (double)19.0, (double)5.0, (double)15.3, (double)22.0, (double)11.2)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape BASE_UPPER_LEFT_SHAPE = Stream.of(Block.m_49796_((double)-16.0, (double)-16.0, (double)0.0, (double)-12.0, (double)-14.0, (double)4.0), Block.m_49796_((double)-16.0, (double)-5.0, (double)0.0, (double)-12.0, (double)-3.0, (double)4.0), Block.m_49796_((double)-15.0, (double)-15.0, (double)1.0, (double)-13.0, (double)-5.0, (double)3.0), Block.m_49796_((double)-15.0, (double)-15.0, (double)13.0, (double)-13.0, (double)-5.0, (double)15.0), Block.m_49796_((double)-16.0, (double)-16.0, (double)12.0, (double)-12.0, (double)-14.0, (double)16.0), Block.m_49796_((double)-16.0, (double)-5.0, (double)12.0, (double)-12.0, (double)-3.0, (double)16.0), Block.m_49796_((double)13.0, (double)-15.0, (double)13.0, (double)15.0, (double)-5.0, (double)15.0), Block.m_49796_((double)12.0, (double)-16.0, (double)12.0, (double)16.0, (double)-14.0, (double)16.0), Block.m_49796_((double)12.0, (double)-5.0, (double)12.0, (double)16.0, (double)-3.0, (double)16.0), Block.m_49796_((double)13.0, (double)-15.0, (double)1.0, (double)15.0, (double)-5.0, (double)3.0), Block.m_49796_((double)12.0, (double)-16.0, (double)0.0, (double)16.0, (double)-14.0, (double)4.0), Block.m_49796_((double)12.0, (double)-5.0, (double)0.0, (double)16.0, (double)-3.0, (double)4.0), Block.m_49796_((double)-16.0, (double)-3.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0), Block.m_49796_((double)-11.0, (double)-16.0, (double)0.0, (double)-2.0, (double)-13.0, (double)15.0), Block.m_49796_((double)-1.75, (double)-16.0, (double)2.0, (double)7.350000000000001, (double)-14.0, (double)12.0), Block.m_49796_((double)0.04999999999999716, (double)-14.0, (double)2.0, (double)5.149999999999999, (double)-13.0, (double)12.0), Block.m_49796_((double)-11.0, (double)-13.0, (double)2.0, (double)-2.0, (double)-10.0, (double)13.3), Block.m_49796_((double)-16.0, (double)0.0, (double)14.0, (double)-14.0, (double)10.0, (double)16.0), Block.m_49796_((double)-6.0, (double)0.0, (double)14.0, (double)-4.0, (double)10.0, (double)16.0), Block.m_49796_((double)4.0, (double)0.0, (double)14.0, (double)6.0, (double)10.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)6.0, (double)0.0, (double)14.5, (double)14.0, (double)10.0, (double)15.5), Block.m_49796_((double)-4.0, (double)0.0, (double)14.5, (double)4.0, (double)10.0, (double)15.5), Block.m_49796_((double)-14.0, (double)0.0, (double)14.5, (double)-6.0, (double)10.0, (double)15.5), Block.m_49796_((double)5.199999999999999, (double)0.0, (double)3.1999999999999993, (double)15.0, (double)3.0, (double)13.0), Block.m_49796_((double)5.5, (double)3.0, (double)5.0, (double)15.3, (double)6.0, (double)11.2)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape[] RIGHT_SHAPES = new VoxelShape[8];
    private static final VoxelShape[] LEFT_SHAPES = new VoxelShape[8];

    public WorkstationBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(MODEL_TYPE, (Comparable)((Object)WorkstationModelType.MAIN)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, MODEL_TYPE});
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockPos blockPos = blockPlaceContext.m_8083_();
        Level level = blockPlaceContext.m_43725_();
        Direction direction = blockPlaceContext.m_8125_().m_122428_();
        BlockPos posAbove = blockPos.m_7494_();
        BlockPos posClockWise = blockPos.m_121945_(direction);
        BlockPos posClockWiseAbove = blockPos.m_121945_(direction).m_7494_();
        if (blockPos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(posAbove).m_60629_(blockPlaceContext) && level.m_8055_(posClockWise).m_60629_(blockPlaceContext) && level.m_8055_(posClockWiseAbove).m_60629_(blockPlaceContext)) {
            return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)blockPlaceContext.m_8125_().m_122424_());
        }
        return null;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos containerPos = state.m_61143_(MODEL_TYPE) == WorkstationModelType.MAIN ? pos : pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122428_());
        player.m_5893_(state.m_60750_(level, pos));
        player.m_36220_(Stats.f_12978_);
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level level, BlockPos pos) {
        return new SimpleMenuProvider((i, inventory, player) -> new WorkstationMenu(i, inventory, ContainerLevelAccess.m_39289_((Level)level, (BlockPos)pos)), CONTAINER_TITLE);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos uppos;
        BlockPos leftpos;
        if (level.f_46443_) {
            super.m_5707_(level, pos, state, player);
            return;
        }
        WorkstationModelType workstationModel = (WorkstationModelType)((Object)state.m_61143_(MODEL_TYPE));
        if (workstationModel == WorkstationModelType.MAIN) {
            leftpos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122427_());
            BlockPos leftuppos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122427_()).m_7494_();
            uppos = pos.m_7494_();
            BlockState leftstate = level.m_8055_(leftpos);
            if (leftstate.m_60734_() == this) {
                level.m_7731_(leftpos, Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(leftuppos, Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(uppos, Blocks.f_50016_.m_49966_(), 3);
                level.m_5898_(player, 2001, leftpos, Block.m_49956_((BlockState)leftstate));
            }
        }
        if (workstationModel == WorkstationModelType.MAIN_UP) {
            leftpos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122427_());
            BlockPos leftbelowpos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122427_()).m_7495_();
            BlockPos belowpos = pos.m_7495_();
            BlockState belowstate = level.m_8055_(belowpos);
            if (belowstate.m_60734_() == this) {
                level.m_7731_(leftpos, Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(leftbelowpos, Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(belowpos, Blocks.f_50016_.m_49966_(), 3);
                level.m_5898_(player, 2001, belowpos, Block.m_49956_((BlockState)belowstate));
            }
        }
        if (workstationModel == WorkstationModelType.SIDE) {
            BlockPos rightpos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122428_());
            BlockPos rightuppos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122428_()).m_7494_();
            uppos = pos.m_7494_();
            BlockState rightstate = level.m_8055_(rightpos);
            if (rightstate.m_60734_() == this) {
                level.m_7731_(rightpos, Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(rightuppos, Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(uppos, Blocks.f_50016_.m_49966_(), 3);
                level.m_5898_(player, 2001, rightpos, Block.m_49956_((BlockState)rightstate));
            }
        }
        if (workstationModel == WorkstationModelType.SIDE_UP) {
            BlockPos belowpos = pos.m_7495_();
            BlockPos rightpos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122428_());
            BlockPos rightbelowpos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122428_()).m_7495_();
            BlockState otherstate = level.m_8055_(belowpos);
            if (otherstate.m_60734_() == this) {
                level.m_7731_(belowpos, Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(rightpos, Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(rightbelowpos, Blocks.f_50016_.m_49966_(), 3);
                level.m_5898_(player, 2001, belowpos, Block.m_49956_((BlockState)otherstate));
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.f_46443_) {
            BlockPos blockpos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122427_());
            level.m_7731_(blockpos, (BlockState)state.m_61124_(MODEL_TYPE, (Comparable)((Object)WorkstationModelType.SIDE)), 3);
            level.m_7731_(blockpos.m_7494_(), (BlockState)state.m_61124_(MODEL_TYPE, (Comparable)((Object)WorkstationModelType.SIDE_UP)), 3);
            level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(MODEL_TYPE, (Comparable)((Object)WorkstationModelType.MAIN_UP)), 3);
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return state.m_61143_(MODEL_TYPE) == WorkstationModelType.MAIN ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    @Deprecated
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122427_())).m_247087_();
    }

    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        if (direction == Direction.NORTH) {
            if (state.m_61143_(MODEL_TYPE) == WorkstationModelType.MAIN) {
                return BASE_LOWER_RIGHT_SHAPE;
            }
            if (state.m_61143_(MODEL_TYPE) == WorkstationModelType.MAIN_UP) {
                return BASE_UPPER_RIGHT_SHAPE;
            }
            if (state.m_61143_(MODEL_TYPE) == WorkstationModelType.SIDE) {
                return BASE_LOWER_LEFT_SHAPE;
            }
            if (state.m_61143_(MODEL_TYPE) == WorkstationModelType.SIDE_UP) {
                return BASE_UPPER_LEFT_SHAPE;
            }
        } else if (direction == Direction.EAST) {
            if (state.m_61143_(MODEL_TYPE) == WorkstationModelType.MAIN) {
                return RIGHT_SHAPES[4 + direction.m_122416_()];
            }
            if (state.m_61143_(MODEL_TYPE) == WorkstationModelType.MAIN_UP) {
                return RIGHT_SHAPES[direction.m_122416_()];
            }
            if (state.m_61143_(MODEL_TYPE) == WorkstationModelType.SIDE) {
                return LEFT_SHAPES[4 + direction.m_122416_()];
            }
            if (state.m_61143_(MODEL_TYPE) == WorkstationModelType.SIDE_UP) {
                return LEFT_SHAPES[direction.m_122416_()];
            }
        } else if (direction == Direction.SOUTH) {
            if (state.m_61143_(MODEL_TYPE) == WorkstationModelType.MAIN) {
                return RIGHT_SHAPES[4 + direction.m_122416_()];
            }
            if (state.m_61143_(MODEL_TYPE) == WorkstationModelType.MAIN_UP) {
                return RIGHT_SHAPES[direction.m_122416_()];
            }
            if (state.m_61143_(MODEL_TYPE) == WorkstationModelType.SIDE) {
                return LEFT_SHAPES[4 + direction.m_122416_()];
            }
            if (state.m_61143_(MODEL_TYPE) == WorkstationModelType.SIDE_UP) {
                return LEFT_SHAPES[direction.m_122416_()];
            }
        } else if (direction == Direction.WEST) {
            if (state.m_61143_(MODEL_TYPE) == WorkstationModelType.MAIN) {
                return RIGHT_SHAPES[4 + direction.m_122416_()];
            }
            if (state.m_61143_(MODEL_TYPE) == WorkstationModelType.MAIN_UP) {
                return RIGHT_SHAPES[direction.m_122416_()];
            }
            if (state.m_61143_(MODEL_TYPE) == WorkstationModelType.SIDE) {
                return LEFT_SHAPES[4 + direction.m_122416_()];
            }
            if (state.m_61143_(MODEL_TYPE) == WorkstationModelType.SIDE_UP) {
                return LEFT_SHAPES[direction.m_122416_()];
            }
        }
        return RIGHT_SHAPES[4 + direction.m_122416_()];
    }

    static {
        WorkstationBlock.RIGHT_SHAPES[0] = ShapeUtil.rotateShape(BASE_UPPER_RIGHT_SHAPE, Direction.SOUTH);
        WorkstationBlock.RIGHT_SHAPES[1] = ShapeUtil.rotateShape(BASE_UPPER_RIGHT_SHAPE, Direction.WEST);
        WorkstationBlock.RIGHT_SHAPES[2] = ShapeUtil.rotateShape(BASE_UPPER_RIGHT_SHAPE, Direction.NORTH);
        WorkstationBlock.RIGHT_SHAPES[3] = ShapeUtil.rotateShape(BASE_UPPER_RIGHT_SHAPE, Direction.EAST);
        WorkstationBlock.RIGHT_SHAPES[4] = ShapeUtil.rotateShape(BASE_LOWER_RIGHT_SHAPE, Direction.SOUTH);
        WorkstationBlock.RIGHT_SHAPES[5] = ShapeUtil.rotateShape(BASE_LOWER_RIGHT_SHAPE, Direction.WEST);
        WorkstationBlock.RIGHT_SHAPES[6] = ShapeUtil.rotateShape(BASE_LOWER_RIGHT_SHAPE, Direction.NORTH);
        WorkstationBlock.RIGHT_SHAPES[7] = ShapeUtil.rotateShape(BASE_LOWER_RIGHT_SHAPE, Direction.EAST);
        WorkstationBlock.LEFT_SHAPES[0] = ShapeUtil.rotateShape(BASE_UPPER_LEFT_SHAPE, Direction.SOUTH);
        WorkstationBlock.LEFT_SHAPES[1] = ShapeUtil.rotateShape(BASE_UPPER_LEFT_SHAPE, Direction.WEST);
        WorkstationBlock.LEFT_SHAPES[2] = ShapeUtil.rotateShape(BASE_UPPER_LEFT_SHAPE, Direction.NORTH);
        WorkstationBlock.LEFT_SHAPES[3] = ShapeUtil.rotateShape(BASE_UPPER_LEFT_SHAPE, Direction.EAST);
        WorkstationBlock.LEFT_SHAPES[4] = ShapeUtil.rotateShape(BASE_LOWER_LEFT_SHAPE, Direction.SOUTH);
        WorkstationBlock.LEFT_SHAPES[5] = ShapeUtil.rotateShape(BASE_LOWER_LEFT_SHAPE, Direction.WEST);
        WorkstationBlock.LEFT_SHAPES[6] = ShapeUtil.rotateShape(BASE_LOWER_LEFT_SHAPE, Direction.NORTH);
        WorkstationBlock.LEFT_SHAPES[7] = ShapeUtil.rotateShape(BASE_LOWER_LEFT_SHAPE, Direction.EAST);
    }

    public static enum WorkstationModelType implements StringRepresentable
    {
        MAIN,
        SIDE,
        MAIN_UP,
        SIDE_UP;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.m_7912_();
        }
    }
}

