/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.ai.phantom;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.entity.ai.AIGunEvent;
import ttv.migami.jeg.entity.monster.phantom.gunner.PhantomGunner;
import ttv.migami.jeg.event.GunEventBus;
import ttv.migami.jeg.item.GunItem;

public class PhantomGunnerGunAttackGoal<T extends PathfinderMob>
extends Goal {
    protected final PhantomGunner shooter;
    protected int seeTime;
    protected int attackTime;
    protected final float attackRadiusSqr;
    protected int reloadTick = 0;
    protected boolean isReloading = false;
    protected Vec3 lastKnownPosition;
    protected float spreadModifier = 10.0f;
    protected int burstAmount = 3;
    protected int burstTimer = 20;

    public PhantomGunnerGunAttackGoal(PhantomGunner shooter, double stopRange, int difficulty) {
        this.shooter = shooter;
        this.attackTime = -1;
        this.attackRadiusSqr = (float)(stopRange * stopRange);
        if (this.shooter.m_5448_() != null) {
            this.lastKnownPosition = this.shooter.m_5448_().m_20182_();
        }
        this.spreadModifier /= (float)difficulty;
        this.burstAmount *= difficulty;
        this.burstTimer /= difficulty;
    }

    public boolean m_8036_() {
        return !this.shooter.isDying() && this.shooter.m_5448_() != null && this.isHoldingGun() && !this.shooter.m_5448_().m_21224_();
    }

    protected boolean isHoldingGun() {
        return this.shooter.m_21093_(itemStack -> itemStack.m_41720_() instanceof GunItem);
    }

    public void m_8056_() {
        super.m_8056_();
        this.shooter.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.shooter.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.shooter.m_5810_();
        this.reloadTick = 0;
        this.isReloading = false;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        Item item;
        LivingEntity target = this.shooter.m_5448_();
        ItemStack heldItem = this.shooter.m_21205_();
        if (target != null && (item = heldItem.m_41720_()) instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            Gun gun = gunItem.getModifiedGun(heldItem);
            if (this.shooter.getAttackPhase().equals((Object)PhantomGunner.AttackPhase.SWOOP) && this.shooter.f_19797_ % 3 == 0) {
                this.shoot(target, gun);
            }
        }
    }

    private void shoot(LivingEntity target, Gun gun) {
        ItemStack heldItem = this.shooter.m_21205_();
        AIGunEvent.performGunAttack((Mob)this.shooter, target, heldItem, gun, this.spreadModifier);
        this.attackTime = gun.getGeneral().getRate() + 1;
        GunEventBus.ejectCasing(this.shooter.m_9236_(), (LivingEntity)this.shooter);
        ResourceLocation fireSound = gun.getSounds().getFire();
        if (fireSound != null) {
            double posX = this.shooter.m_20185_();
            double posY = this.shooter.m_20186_() + (double)this.shooter.m_20192_();
            double posZ = this.shooter.m_20189_();
            float volume = ((Integer)Config.COMMON.world.mobGunfireVolume.get()).intValue();
            float pitch = 0.9f + this.shooter.m_9236_().f_46441_.m_188501_() * 0.2f;
            this.shooter.m_9236_().m_6263_(null, posX, posY, posZ, SoundEvent.m_262824_((ResourceLocation)fireSound), SoundSource.HOSTILE, volume - 0.5f, pitch);
        }
    }

    public static Vec3 getDirectionToTarget(PhantomGunner entity, Entity target) {
        if (target == null) {
            return Vec3.f_82478_;
        }
        Vec3 entityPos = entity.m_20182_();
        Vec3 targetPos = target.m_20182_();
        return targetPos.m_82546_(entityPos).m_82541_();
    }
}

