/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.item;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.client.KeyBinds;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.item.attachment.impl.Side;
import ttv.migami.jeg.item.attachment.item.SpecialItem;

public class FlashlightItem
extends SpecialItem {
    private static final String TAG_POWERED = "Powered";
    public static final String TAG_BATTERY_LIFE = "BatteryLife";
    private static final int COOLDOWN_TICKS = 20;
    public static final int MAX_BATTERY_LIFE = 600;

    public FlashlightItem(Side side, Item.Properties properties) {
        super(side, properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)("info.jeg.tooltip_item." + this.m_5456_())).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)"").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)("info.jeg.tooltip_item." + this.m_5456_() + "_help")).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)("info.jeg.tooltip_item." + this.m_5456_() + "_help_gun"), (Object[])new Object[]{KeyBinds.KEY_MELEE.m_90863_().getString().toUpperCase(Locale.ENGLISH)}).m_130940_(ChatFormatting.GRAY));
    }

    public static void registerItemProperties() {
        ItemProperties.register((Item)((Item)ModItems.FLASHLIGHT.get()), (ResourceLocation)new ResourceLocation("powered"), (stack, level, entity, seed) -> stack.m_41782_() && stack.m_41783_().m_128471_(TAG_POWERED) ? 1.0f : 0.0f);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            CompoundTag tag = stack.m_41784_();
            boolean powered = tag.m_128471_(TAG_POWERED);
            int batteryLife = tag.m_128451_(TAG_BATTERY_LIFE);
            if (!tag.m_128441_(TAG_BATTERY_LIFE)) {
                tag.m_128405_(TAG_BATTERY_LIFE, 600);
            }
            if (powered && !player.m_7500_() && !player.m_5833_()) {
                if (batteryLife > 0) {
                    tag.m_128405_(TAG_BATTERY_LIFE, batteryLife - 1);
                } else {
                    tag.m_128379_(TAG_POWERED, false);
                }
            }
            if (batteryLife <= 0 && selected) {
                player.m_5661_((Component)Component.m_237115_((String)"chat.jeg.flashlight_battery_dead").m_130940_(ChatFormatting.RED), true);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player != null && !world.f_46443_) {
            CompoundTag tag = stack.m_41784_();
            boolean powered = tag.m_128471_(TAG_POWERED);
            int batteryLife = tag.m_128451_(TAG_BATTERY_LIFE);
            if (!((Boolean)Config.COMMON.gameplay.allowFlashlights.get()).booleanValue()) {
                MutableComponent message = Component.m_237115_((String)"chat.jeg.disabled_flashlights").m_130940_(ChatFormatting.GRAY);
                player.m_5661_((Component)message, true);
            }
            if (batteryLife <= 0) {
                if (powered) {
                    tag.m_128379_(TAG_POWERED, false);
                    world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.GOOSE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                player.m_36335_().m_41524_((Item)this, 10);
            } else {
                if (!(powered || player.m_7500_() || player.m_5833_())) {
                    tag.m_128405_(TAG_BATTERY_LIFE, batteryLife - 1);
                }
                tag.m_128379_(TAG_POWERED, !powered);
                player.m_36335_().m_41524_((Item)this, 20);
                world.m_220400_((Entity)player, GameEvent.f_223702_, player.m_20318_(1.0f));
            }
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.FLASHLIGHT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public boolean m_142522_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        int batteryLife = tag.m_128451_(TAG_BATTERY_LIFE);
        return batteryLife < 600;
    }

    public int m_142158_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        int batteryLife = tag.m_128451_(TAG_BATTERY_LIFE);
        return Math.round(13.0f * (float)batteryLife / 600.0f);
    }

    public int m_142159_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        int batteryLife = tag.m_128451_(TAG_BATTERY_LIFE);
        float percentage = (float)batteryLife / 600.0f;
        if (percentage > 0.5f) {
            int red = (int)(255.0f * (1.0f - 2.0f * (percentage - 0.5f)));
            return red << 16 | 0xFF00;
        }
        int green = (int)(510.0f * percentage);
        return 0xFF0000 | green << 8;
    }
}

