/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.particles;

import at.petrak.hexcasting.common.particles.ConjureParticleOptions;
import at.petrak.hexcasting.xplat.IClientXplatAbstractions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConjureParticle
extends TextureSheetParticle {
    private static final Random RANDOM = new Random();
    private final SpriteSet sprites;
    public static final ConjureRenderType CONJURE_RENDER_TYPE = new ConjureRenderType();

    ConjureParticle(ClientLevel pLevel, double x, double y, double z, double dx, double dy, double dz, SpriteSet pSprites, int color) {
        super(pLevel, x, y, z, dx, dy, dz);
        this.f_107663_ *= 0.9f;
        this.m_172260_(dx, dy, dz);
        int r = FastColor.ARGB32.m_13665_((int)color);
        int g = FastColor.ARGB32.m_13667_((int)color);
        int b = FastColor.ARGB32.m_13669_((int)color);
        this.m_107253_((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
        this.m_107271_(0.3f);
        this.f_172258_ = 0.96f;
        this.f_107226_ = dy != 0.0 && dx != 0.0 && dz != 0.0 ? -0.01f : 0.0f;
        this.f_172259_ = true;
        this.sprites = pSprites;
        this.f_107204_ = this.f_107231_ = RANDOM.nextFloat(360.0f);
        this.f_107225_ = (int)(64.0 / ((Math.random() + 3.0) * 0.25));
        this.f_107219_ = false;
        this.m_108339_(pSprites);
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return CONJURE_RENDER_TYPE;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
        this.f_107230_ = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        this.f_107230_ *= 0.3f;
        this.f_107663_ *= 0.96f;
    }

    public void m_108339_(@NotNull SpriteSet pSprite) {
        if (!this.f_107220_) {
            int age = this.f_107224_ * 4;
            if (age > this.f_107225_) {
                age /= 4;
            }
            this.m_108337_(pSprite.m_5819_(age, this.f_107225_));
        }
    }

    private record ConjureRenderType() implements ParticleRenderType
    {
        public void m_6505_(BufferBuilder buf, TextureManager texMan) {
            Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
            AbstractTexture tex = texMan.m_118506_(TextureAtlas.f_118260_);
            IClientXplatAbstractions.INSTANCE.setFilterSave(tex, true, false);
            buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            RenderSystem.enableDepthTest();
        }

        public void m_6294_(Tesselator tess) {
            tess.m_85914_();
            IClientXplatAbstractions.INSTANCE.restoreLastFilter(Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118260_));
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
        }

        @Override
        public String toString() {
            return "hexcasting:conjure";
        }
    }

    public static class Provider
    implements ParticleProvider<ConjureParticleOptions> {
        private final SpriteSet sprite;

        public Provider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Nullable
        public Particle createParticle(ConjureParticleOptions type, ClientLevel level, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new ConjureParticle(level, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, this.sprite, type.color());
        }
    }
}

