/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain;

import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.wildfire.WildfireBarrageAttackTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.wildfire.WildfireShockwaveAttackTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.wildfire.WildfireSummonBlazeTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;

public final class WildfireBrain {
    public static final List<MemoryModuleType<?>> MEMORY_MODULES;
    public static final List<SensorType<? extends Sensor<? super WildfireEntity>>> SENSORS;
    private static final UniformInt BARRAGE_ATTACK_COOLDOWN_PROVIDER;
    private static final UniformInt SHOCKWAVE_ATTACK_COOLDOWN_PROVIDER;
    private static final UniformInt SUMMON_BLAZE_COOLDOWN_PROVIDER;
    private static final UniformInt AVOID_MEMORY_DURATION;
    private static final TargetingConditions VALID_TARGET_PLAYER_PREDICATE;

    public static Brain<?> create(Dynamic<?> dynamic) {
        Brain.Provider profile = Brain.m_21923_(MEMORY_MODULES, SENSORS);
        Brain brain = profile.m_22073_(dynamic);
        WildfireBrain.addCoreActivities((Brain<WildfireEntity>)brain);
        WildfireBrain.addIdleActivities((Brain<WildfireEntity>)brain);
        WildfireBrain.addFightActivities((Brain<WildfireEntity>)brain);
        WildfireBrain.addAvoidActivities((Brain<WildfireEntity>)brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void addCoreActivities(Brain<WildfireEntity> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(FriendsAndFoesMemoryModuleTypes.WILDFIRE_BARRAGE_ATTACK_COOLDOWN.get()), (Object)new CountDownCooldownTicks(FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get()), (Object)new CountDownCooldownTicks(FriendsAndFoesMemoryModuleTypes.WILDFIRE_SUMMON_BLAZE_COOLDOWN.get())));
    }

    private static void addIdleActivities(Brain<WildfireEntity> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)StartAttacking.m_257741_(wildfire -> true, WildfireBrain::getTarget)), (Object)Pair.of((Object)1, WildfireBrain.makeRandomWanderTask())));
    }

    private static void addFightActivities(Brain<WildfireEntity> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)((Object)new WildfireSummonBlazeTask()), (Object)((Object)new WildfireBarrageAttackTask()), (Object)((Object)new WildfireShockwaveAttackTask())), MemoryModuleType.f_26372_);
    }

    private static void addAvoidActivities(Brain<WildfireEntity> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.m_257370_((MemoryModuleType)MemoryModuleType.f_26383_, (float)1.4f, (int)16, (boolean)true), WildfireBrain.makeRandomWanderTask()), MemoryModuleType.f_26383_);
    }

    private static RunOne<WildfireEntity> makeRandomWanderTask() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)0.6f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void updateActivities(WildfireEntity wildfire) {
        wildfire.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37988_, (Object)Activity.f_37991_, (Object)Activity.f_37979_));
    }

    public static void setBarrageAttackCooldown(WildfireEntity wildfire) {
        wildfire.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.WILDFIRE_BARRAGE_ATTACK_COOLDOWN.get(), (Object)BARRAGE_ATTACK_COOLDOWN_PROVIDER.m_214085_(wildfire.m_217043_()));
        WildfireBrain.onCooldown(wildfire);
    }

    public static void setShockwaveAttackCooldown(WildfireEntity wildfire) {
        wildfire.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get(), (Object)SHOCKWAVE_ATTACK_COOLDOWN_PROVIDER.m_214085_(wildfire.m_217043_()));
        WildfireBrain.onCooldown(wildfire);
    }

    public static void setSummonBlazeCooldown(WildfireEntity wildfire) {
        wildfire.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.WILDFIRE_SUMMON_BLAZE_COOLDOWN.get(), (Object)SUMMON_BLAZE_COOLDOWN_PROVIDER.m_214085_(wildfire.m_217043_()));
        WildfireBrain.onCooldown(wildfire);
    }

    public static boolean shouldRunAway(WildfireEntity wildfire) {
        return wildfire.m_6274_().m_21952_(FriendsAndFoesMemoryModuleTypes.WILDFIRE_BARRAGE_ATTACK_COOLDOWN.get()).isPresent() && wildfire.m_6274_().m_21952_(FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get()).isPresent() && (wildfire.m_6274_().m_21952_(FriendsAndFoesMemoryModuleTypes.WILDFIRE_SUMMON_BLAZE_COOLDOWN.get()).isPresent() || wildfire.getSummonedBlazesCount() == 2);
    }

    public static void onCooldown(WildfireEntity wildfire) {
        if (!WildfireBrain.shouldRunAway(wildfire)) {
            return;
        }
        LivingEntity attackTarget = wildfire.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
        if (attackTarget == null) {
            return;
        }
        WildfireBrain.runAwayFrom(wildfire, attackTarget);
    }

    public static void onAttacked(WildfireEntity wildfire, LivingEntity attacker) {
        WildfireBrain.setAttackTarget(wildfire, attacker);
        if (WildfireBrain.shouldRunAway(wildfire)) {
            WildfireBrain.runAwayFrom(wildfire, attacker);
        }
    }

    private static Optional<? extends LivingEntity> getTarget(WildfireEntity wildfire) {
        Player nearestVisibleTargetablePlayer = wildfire.m_6274_().m_21952_(MemoryModuleType.f_148206_).orElse(wildfire.m_9236_().m_45949_(VALID_TARGET_PLAYER_PREDICATE, (LivingEntity)wildfire, wildfire.m_20185_(), wildfire.m_20188_(), wildfire.m_20189_()));
        if (nearestVisibleTargetablePlayer == null) {
            return Optional.empty();
        }
        return Optional.of(nearestVisibleTargetablePlayer);
    }

    public static void setAttackTarget(WildfireEntity wildfire, LivingEntity target) {
        wildfire.m_6274_().m_21936_(MemoryModuleType.f_26326_);
        wildfire.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)target, 200L);
    }

    private static void runAwayFrom(WildfireEntity wildfire, LivingEntity target) {
        wildfire.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        wildfire.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        wildfire.m_6274_().m_21882_(MemoryModuleType.f_26383_, (Object)target, (long)AVOID_MEMORY_DURATION.m_214085_(wildfire.m_9236_().m_213780_()));
    }

    static {
        SENSORS = List.of(SensorType.f_26812_, SensorType.f_26814_);
        MEMORY_MODULES = List.of(MemoryModuleType.f_26377_, MemoryModuleType.f_148204_, MemoryModuleType.f_148205_, MemoryModuleType.f_148206_, MemoryModuleType.f_26372_, MemoryModuleType.f_26371_, MemoryModuleType.f_26370_, MemoryModuleType.f_26383_, MemoryModuleType.f_26326_, FriendsAndFoesMemoryModuleTypes.WILDFIRE_SUMMON_BLAZE_COOLDOWN.get(), FriendsAndFoesMemoryModuleTypes.WILDFIRE_BARRAGE_ATTACK_COOLDOWN.get(), FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get());
        SUMMON_BLAZE_COOLDOWN_PROVIDER = UniformInt.m_146622_((int)600, (int)1200);
        BARRAGE_ATTACK_COOLDOWN_PROVIDER = UniformInt.m_146622_((int)150, (int)300);
        SHOCKWAVE_ATTACK_COOLDOWN_PROVIDER = UniformInt.m_146622_((int)150, (int)300);
        VALID_TARGET_PLAYER_PREDICATE = TargetingConditions.m_148352_().m_26883_(32.0);
        AVOID_MEMORY_DURATION = TimeUtil.m_145020_((int)5, (int)20);
    }
}

