/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.GlareBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.BlockState;

public final class GlareShakeGlowBerriesTask
extends Behavior<GlareEntity> {
    private static final int MAX_SHAKING_TICKS = 200;
    private static final float WITHING_DISTANCE = 2.0f;
    private int shakingTicks;

    public GlareShakeGlowBerriesTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.GLARE_GLOW_BERRIES_POS.get(), MemoryStatus.VALUE_PRESENT), 200);
    }

    protected boolean shouldRun(ServerLevel world, GlareEntity glare) {
        GlobalPos glowBerriesPos = glare.getGlowBerriesPos();
        return glare.m_9236_().m_46469_().m_46207_(GameRules.f_46132_) && FriendsAndFoes.getConfig().enableGlareGriefing && !glare.m_21523_() && !glare.m_21827_() && glare.m_6844_(EquipmentSlot.MAINHAND).m_41619_() && glowBerriesPos != null && glare.canEatGlowBerriesAt(glowBerriesPos.m_122646_()) && glowBerriesPos.m_122646_().m_203195_((Position)glare.m_20182_(), 2.0);
    }

    protected void run(ServerLevel world, GlareEntity glare, long time) {
        this.shakingTicks = 0;
    }

    protected boolean shouldKeepRunning(ServerLevel world, GlareEntity glare, long time) {
        GlobalPos glowBerriesPos = glare.getGlowBerriesPos();
        return glare.m_9236_().m_46469_().m_46207_(GameRules.f_46132_) && FriendsAndFoes.getConfig().enableGlareGriefing && !glare.m_21523_() && !glare.m_21827_() && glare.m_6844_(EquipmentSlot.MAINHAND).m_41619_() && glowBerriesPos != null && glare.canEatGlowBerriesAt(glowBerriesPos.m_122646_()) && glowBerriesPos.m_122646_().m_203195_((Position)glare.m_20182_(), 2.0);
    }

    protected void keepRunning(ServerLevel world, GlareEntity glare, long time) {
        ++this.shakingTicks;
        if (this.shakingTicks % 5 == 0 && (double)glare.m_217043_().m_188501_() > 0.85) {
            glare.playRustleSound();
        }
        if (glare.m_217043_().m_188501_() < 0.05f && this.shakingTicks > 100) {
            glare.m_8032_();
            this.shakeOffGlowBerries(glare);
            GlareBrain.setLocatingGlowBerriesCooldown(glare);
        }
    }

    protected void finishRunning(ServerLevel world, GlareEntity glare, long time) {
        glare.m_6274_().m_21936_(FriendsAndFoesMemoryModuleTypes.GLARE_GLOW_BERRIES_POS.get());
    }

    private void shakeOffGlowBerries(GlareEntity glare) {
        if (!glare.m_9236_().m_46469_().m_46207_(GameRules.f_46132_) || !FriendsAndFoes.getConfig().enableGlareGriefing) {
            return;
        }
        GlobalPos glowBerriesPos = glare.getGlowBerriesPos();
        if (glowBerriesPos == null) {
            return;
        }
        BlockState blockState = glare.m_9236_().m_8055_(glowBerriesPos.m_122646_());
        if (!CaveVines.m_152951_((BlockState)blockState)) {
            return;
        }
        CaveVines.m_269473_((Entity)glare, (BlockState)blockState, (Level)glare.m_9236_(), (BlockPos)glowBerriesPos.m_122646_());
    }
}

