/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare;

import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.GlareBrain;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareLocateDarkSpotTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public final class GlareTravelToDarkSpotTask
extends Behavior<GlareEntity> {
    private static final int MAX_TRAVELLING_TICKS = 300;
    private static final float WITHING_DISTANCE = 1.5f;

    public GlareTravelToDarkSpotTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get(), MemoryStatus.VALUE_PRESENT), 300);
    }

    protected boolean shouldRun(ServerLevel world, GlareEntity glare) {
        GlobalPos darkSpotPos = glare.getDarkSpotPos();
        return GlareTravelToDarkSpotTask.canTravelToDarkSpot(glare) && !darkSpotPos.m_122646_().m_203195_((Position)glare.m_20182_(), 1.5);
    }

    protected void run(ServerLevel world, GlareEntity glare, long time) {
        this.flyTowardsDarkSpot(glare);
    }

    protected boolean shouldKeepRunning(ServerLevel world, GlareEntity glare, long time) {
        GlobalPos darkSpotPos = glare.getDarkSpotPos();
        return GlareTravelToDarkSpotTask.canTravelToDarkSpot(glare) && (!darkSpotPos.m_122646_().m_203195_((Position)glare.m_20182_(), 1.5) || glare.m_21573_().m_26572_());
    }

    protected void keepRunning(ServerLevel world, GlareEntity glare, long time) {
        if (glare.m_21573_().m_26572_()) {
            return;
        }
        this.flyTowardsDarkSpot(glare);
    }

    protected void finishRunning(ServerLevel world, GlareEntity glare, long time) {
        glare.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        GlobalPos darkSpotPos = glare.getDarkSpotPos();
        if (!(darkSpotPos == null || darkSpotPos.m_122646_().m_203195_((Position)glare.m_20182_(), 1.5) && glare.isDarkSpotDark(darkSpotPos.m_122646_()))) {
            glare.m_6274_().m_21936_(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get());
            GlareBrain.setDarkSpotLocatingCooldown(glare, TimeUtil.m_145020_((int)10, (int)20));
        }
    }

    private void flyTowardsDarkSpot(GlareEntity glare) {
        GlobalPos darkSpotPos = glare.getDarkSpotPos();
        if (darkSpotPos == null) {
            return;
        }
        BehaviorUtils.m_22617_((LivingEntity)glare, (BlockPos)new BlockPos((Vec3i)darkSpotPos.m_122646_()), (float)1.0f, (int)0);
    }

    public static boolean canTravelToDarkSpot(GlareEntity glare) {
        if (!GlareLocateDarkSpotTask.canLocateDarkSpot(glare)) {
            return false;
        }
        GlobalPos darkSpotPos = glare.getDarkSpotPos();
        return darkSpotPos != null && glare.isDarkSpotDark(darkSpotPos.m_122646_());
    }
}

