/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IVertexBufferHolder;
import blusunrize.immersiveengineering.api.utils.client.ModelDataUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.DynamicSubmodelCallbacks;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.common.blocks.wooden.WindmillBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.NonNullSupplier;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WindmillRenderer
extends IEBlockEntityRenderer<WindmillBlockEntity> {
    public static final String NAME = "windmill";
    public static DynamicModel MODEL;
    private static final IVertexBufferHolder[] BUFFERS;

    private static IVertexBufferHolder getBufferHolder(int sails) {
        if (BUFFERS[sails] == null) {
            WindmillRenderer.BUFFERS[sails] = IVertexBufferHolder.create((NonNullSupplier<List<BakedQuad>>)((NonNullSupplier)() -> {
                BakedModel model = MODEL.get();
                ArrayList<String> parts = new ArrayList<String>();
                parts.add("base");
                for (int i = 1; i <= sails; ++i) {
                    parts.add("sail_" + i);
                }
                ModelData data = ModelDataUtils.single(DynamicSubmodelCallbacks.getProperty(), IEProperties.VisibilityList.show(parts));
                return model.getQuads(null, null, ApiUtils.RANDOM_SOURCE, data, RenderType.m_110463_());
            }));
        }
        return BUFFERS[sails];
    }

    public void render(WindmillBlockEntity tile, float partialTicks, PoseStack transform, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.getLevelNonnull().m_46805_(tile.m_58899_())) {
            return;
        }
        transform.m_85836_();
        transform.m_85837_(0.5, 0.5, 0.5);
        float dir = tile.getFacing() == Direction.SOUTH ? 0.0f : (tile.getFacing() == Direction.NORTH ? (float)Math.PI : (tile.getFacing() == Direction.EAST ? 1.5707964f : -1.5707964f));
        float rot = (float)(6.2831854820251465 * ((double)tile.rotation + (double)partialTicks * tile.getActualTurnSpeed()));
        transform.m_252781_(new Quaternionf().rotateAxis(rot, (Vector3fc)new Vector3f(tile.getFacing().m_122434_() == Direction.Axis.X ? 1.0f : 0.0f, 0.0f, tile.getFacing().m_122434_() == Direction.Axis.Z ? 1.0f : 0.0f)).rotateY(dir));
        transform.m_85837_(-0.5, -0.5, -0.5);
        WindmillRenderer.getBufferHolder(tile.sails).render(RenderType.m_110463_(), combinedLightIn, combinedOverlayIn, bufferIn, transform);
        transform.m_85849_();
    }

    public static void reset() {
        for (IVertexBufferHolder vbo : BUFFERS) {
            if (vbo == null) continue;
            vbo.reset();
        }
    }

    static {
        BUFFERS = new IVertexBufferHolder[9];
    }
}

