/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.gui;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.gui.ExplorersCompassScreen;
import com.chaosthedude.explorerscompass.gui.StructureSearchList;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StructureSearchEntry
extends ObjectSelectionList.Entry<StructureSearchEntry> {
    private final Minecraft mc;
    private final ExplorersCompassScreen parentScreen;
    private final ResourceLocation structureKey;
    private final StructureSearchList structuresList;
    private long lastClickTime;

    public StructureSearchEntry(StructureSearchList structuresList, ResourceLocation structureKey) {
        this.structuresList = structuresList;
        this.structureKey = structureKey;
        this.parentScreen = structuresList.getParentScreen();
        this.mc = Minecraft.m_91087_();
    }

    public void m_6311_(GuiGraphics guiGraphics, int par1, int par2, int par3, int par4, int par5, int par6, int par7, boolean par8, float par9) {
        guiGraphics.m_280430_(this.mc.f_91062_, (Component)Component.m_237113_((String)StructureUtils.getPrettyStructureName(this.structureKey)), par3 + 1, par2 + 1, 0xFFFFFF);
        Font font = this.mc.f_91062_;
        MutableComponent mutableComponent = Component.m_237115_((String)"string.explorerscompass.source").m_7220_((Component)Component.m_237113_((String)(": " + StructureUtils.getPrettyStructureSource(this.structureKey))));
        Objects.requireNonNull(this.mc.f_91062_);
        guiGraphics.m_280430_(font, (Component)mutableComponent, par3 + 1, par2 + 9 + 3, 0x808080);
        Font font2 = this.mc.f_91062_;
        MutableComponent mutableComponent2 = Component.m_237115_((String)"string.explorerscompass.group").m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)StructureUtils.getPrettyStructureName(ExplorersCompass.structureKeysToTypeKeys.get(this.structureKey))));
        Objects.requireNonNull(this.mc.f_91062_);
        guiGraphics.m_280430_(font2, (Component)mutableComponent2, par3 + 1, par2 + 9 + 14, 0x808080);
        Font font3 = this.mc.f_91062_;
        MutableComponent mutableComponent3 = Component.m_237115_((String)"string.explorerscompass.dimension").m_7220_((Component)Component.m_237113_((String)(": " + StructureUtils.dimensionKeysToString(ExplorersCompass.dimensionKeysForAllowedStructureKeys.get((Object)this.structureKey)))));
        Objects.requireNonNull(this.mc.f_91062_);
        guiGraphics.m_280430_(font3, (Component)mutableComponent3, par3 + 1, par2 + 9 + 25, 0x808080);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.structuresList.selectStructure(this);
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.searchForStructure();
                return true;
            }
            this.lastClickTime = Util.m_137550_();
            return false;
        }
        return false;
    }

    public Component m_142172_() {
        return Component.m_237113_((String)StructureUtils.getPrettyStructureName(this.structureKey));
    }

    public void searchForStructure() {
        this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        this.parentScreen.searchForStructure(this.structureKey);
    }

    public void searchForGroup() {
        this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        this.parentScreen.searchForGroup(ExplorersCompass.structureKeysToTypeKeys.get(this.structureKey));
    }
}

