/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.serializer;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.condition.IIngredientCondition;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.IIngredientConditionSerializer;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientConditioned;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientConditioned;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

@ParametersAreNonnullByDefault
public enum IngredientConditionedSerializer implements IIngredientSerializer<IngredientConditioned<?, ?>>
{
    INSTANCE;


    public JsonObject toJson(IngredientConditioned<?, ?> ingredientVanillaPlus) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", CraftingHelper.getID((IIngredientSerializer)INSTANCE).toString());
        jsonObject.add("base", ((IIngredientConditioned)ingredientVanillaPlus.getCrTIngredient()).getBaseIngredient().asVanillaIngredient().m_43942_());
        IIngredientCondition<?> condition = ingredientVanillaPlus.getCondition();
        JsonObject value = condition.toJson();
        if (!value.has("type")) {
            value.addProperty("type", condition.getType().toString());
        }
        jsonObject.add("condition", (JsonElement)value);
        return jsonObject;
    }

    public IngredientConditioned<?, ?> parse(FriendlyByteBuf buffer) {
        IIngredient base = IIngredient.fromIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer));
        ResourceLocation type = buffer.m_130281_();
        IIngredientConditionSerializer value = (IIngredientConditionSerializer)CraftTweakerRegistries.REGISTRY_CONDITIONER_SERIALIZER.m_7745_(type);
        if (value == null) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        return new IngredientConditioned(new IIngredientConditioned<IIngredient>(base, (IIngredientCondition<IIngredient>)value.fromNetwork(buffer)));
    }

    public IngredientConditioned<?, ?> parse(JsonObject json) {
        JsonObject base = json.getAsJsonObject("base");
        IIngredient baseIngredient = IIngredient.fromIngredient(CraftingHelper.getIngredient((JsonElement)base, (boolean)false));
        JsonObject condition = json.getAsJsonObject("condition");
        ResourceLocation type = new ResourceLocation(condition.get("type").getAsString());
        IIngredientConditionSerializer value = (IIngredientConditionSerializer)CraftTweakerRegistries.REGISTRY_CONDITIONER_SERIALIZER.m_7745_(type);
        if (value == null) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        return new IngredientConditioned(new IIngredientConditioned<IIngredient>(baseIngredient, (IIngredientCondition<IIngredient>)value.fromJson(condition)));
    }

    public void write(FriendlyByteBuf buffer, IngredientConditioned<?, ?> ingredient) {
        Ingredient baseIngredient = ((IIngredientConditioned)ingredient.getCrTIngredient()).getBaseIngredient().asVanillaIngredient();
        baseIngredient.m_43923_(buffer);
        IIngredientCondition<?> condition = ingredient.getCondition();
        IIngredientConditionSerializer serializer = condition.getSerializer();
        buffer.m_130085_(serializer.getType());
        condition.write(buffer);
    }
}

