/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.server.ServerLifecycleHooks;
import team.lodestar.lodestone.capability.LodestoneWorldDataCapability;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class WorldEventInstanceArgument
implements ArgumentType<WorldEventInstance> {
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_WORLD_EVENT_INSTANCE = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"argument.lodestone.id.invalid", (Object[])new Object[]{object.toString()}));
    private static final Pattern ALLOWED_CHARACTERS = Pattern.compile("^([-A-Fa-f0-9]+)");

    protected WorldEventInstanceArgument() {
    }

    public static WorldEventInstanceArgument worldEventInstance() {
        return new WorldEventInstanceArgument();
    }

    public static WorldEventInstance getEventInstance(CommandContext<?> context, String name) {
        return (WorldEventInstance)context.getArgument(name, WorldEventInstance.class);
    }

    public WorldEventInstance parse(StringReader reader) throws CommandSyntaxException {
        String s = reader.readString();
        Matcher matcher = ALLOWED_CHARACTERS.matcher(s);
        AtomicReference eventInstance = new AtomicReference();
        if (matcher.find()) {
            String s1 = matcher.group(1);
            try {
                UUID uuid = UUID.fromString(s1);
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server == null) {
                    return null;
                }
                Set levels = ((Registry)server.m_206579_().m_6632_(Registries.f_256858_).get()).m_214010_();
                levels.forEach(levelResourceKey -> {
                    if (levelResourceKey == null) {
                        return;
                    }
                    ServerLevel level = server.m_129880_(levelResourceKey);
                    if (level == null) {
                        return;
                    }
                    LodestoneWorldDataCapability.getCapabilityOptional((Level)level).ifPresent(capability -> capability.activeWorldEvents.forEach(worldEventInstance -> {
                        if (worldEventInstance.uuid.equals(uuid)) {
                            eventInstance.set(worldEventInstance);
                        }
                    }));
                });
                if (eventInstance.get() == null) {
                    throw ERROR_UNKNOWN_WORLD_EVENT_INSTANCE.create((Object)uuid);
                }
                return (WorldEventInstance)eventInstance.get();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw UuidArgument.f_113845_.create();
            }
        }
        return (WorldEventInstance)eventInstance.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object s = context.getSource();
        if (s instanceof SharedSuggestionProvider) {
            SharedSuggestionProvider sharedsuggestionprovider = (SharedSuggestionProvider)s;
            sharedsuggestionprovider.m_6553_().forEach(levelResourceKey -> {
                if (levelResourceKey == null) {
                    return;
                }
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                if (level == null) {
                    return;
                }
                LodestoneWorldDataCapability.getCapabilityOptional((Level)level).ifPresent(capability -> capability.activeWorldEvents.forEach(worldEventInstance -> builder.suggest(worldEventInstance.uuid.toString())));
            });
        }
        return builder.buildFuture();
    }
}

