/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util;

import java.util.List;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorUtils {
    public static final List<DyeColor> ORDERED_DYE_COLORS = List.of(DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN, DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK);

    public static MapColor mapColorFromDye(@Nullable DyeColor dyeColor, @NotNull MapColor defaultColor) {
        if (dyeColor == null) {
            return defaultColor;
        }
        return ColorUtils.mapColorFromDye(dyeColor);
    }

    public static MapColor mapColorFromDye(@NotNull DyeColor dyeColor) {
        return switch (dyeColor) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> MapColor.f_283919_;
            case DyeColor.ORANGE -> MapColor.f_283750_;
            case DyeColor.MAGENTA -> MapColor.f_283931_;
            case DyeColor.LIGHT_BLUE -> MapColor.f_283869_;
            case DyeColor.YELLOW -> MapColor.f_283832_;
            case DyeColor.LIME -> MapColor.f_283916_;
            case DyeColor.PINK -> MapColor.f_283765_;
            case DyeColor.GRAY -> MapColor.f_283818_;
            case DyeColor.LIGHT_GRAY -> MapColor.f_283779_;
            case DyeColor.CYAN -> MapColor.f_283772_;
            case DyeColor.PURPLE -> MapColor.f_283889_;
            case DyeColor.BLUE -> MapColor.f_283743_;
            case DyeColor.BROWN -> MapColor.f_283748_;
            case DyeColor.GREEN -> MapColor.f_283784_;
            case DyeColor.RED -> MapColor.f_283913_;
            case DyeColor.BLACK -> MapColor.f_283927_;
        };
    }

    public static String coloredName(String string) {
        return switch (string) {
            case "white" -> "White";
            case "orange" -> "Orange";
            case "magenta" -> "Magenta";
            case "light_blue" -> "Light Blue";
            case "yellow" -> "Yellow";
            case "lime" -> "Lime";
            case "pink" -> "Pink";
            case "gray" -> "Gray";
            case "light_gray" -> "Light Gray";
            case "cyan" -> "Cyan";
            case "purple" -> "Purple";
            case "blue" -> "Blue";
            case "brown" -> "Brown";
            case "green" -> "Green";
            case "red" -> "Red";
            case "black" -> "Black";
            default -> "Unknown Color";
        };
    }

    public static Item getDyeColorDyeItem(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> Items.f_42535_;
            case DyeColor.ORANGE -> Items.f_42536_;
            case DyeColor.MAGENTA -> Items.f_42537_;
            case DyeColor.LIGHT_BLUE -> Items.f_42538_;
            case DyeColor.YELLOW -> Items.f_42539_;
            case DyeColor.LIME -> Items.f_42540_;
            case DyeColor.PINK -> Items.f_42489_;
            case DyeColor.GRAY -> Items.f_42490_;
            case DyeColor.LIGHT_GRAY -> Items.f_42491_;
            case DyeColor.CYAN -> Items.f_42492_;
            case DyeColor.PURPLE -> Items.f_42493_;
            case DyeColor.BLUE -> Items.f_42494_;
            case DyeColor.BROWN -> Items.f_42495_;
            case DyeColor.GREEN -> Items.f_42496_;
            case DyeColor.RED -> Items.f_42497_;
            case DyeColor.BLACK -> Items.f_42498_;
        };
    }
}

