/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.supermartijn642.fusion.api.texture.SpriteCreationContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public class SpriteCreationContextImpl
implements SpriteCreationContext,
AutoCloseable {
    private final TextureAtlasSprite original;
    private final int textureWidth;
    private final int textureHeight;
    private final ResourceLocation identifier;
    private final NativeImage[] images;
    private final int atlasWidth;
    private final int atlasHeight;
    private final TextureAtlas atlas;
    private final int spriteX;
    private final int spriteY;
    private final int spriteWidth;
    private final int spriteHeight;
    private final int mipmapLevels;
    private boolean imagesRequested = false;

    public SpriteCreationContextImpl(SpriteLoader.Preparations preparations, ResourceLocation atlas, TextureAtlasSprite original) {
        this.original = original;
        this.textureWidth = original.m_245424_().f_243904_.m_84982_();
        this.textureHeight = original.m_245424_().f_243904_.m_85084_();
        this.identifier = original.m_245424_().m_246162_();
        this.images = original.m_245424_().f_243731_;
        this.atlasWidth = preparations.f_243669_();
        this.atlasHeight = preparations.f_244632_();
        this.atlas = (TextureAtlas)Minecraft.m_91087_().m_91097_().m_174786_(atlas, null);
        this.spriteX = original.m_174743_();
        this.spriteY = original.m_174744_();
        this.spriteWidth = original.m_245424_().m_246492_();
        this.spriteHeight = original.m_245424_().m_245330_();
        this.mipmapLevels = preparations.f_244353_();
    }

    private void closeUnusedResources() {
        if (!this.imagesRequested) {
            this.original.m_245424_().close();
        }
    }

    @Override
    public TextureAtlasSprite createOriginalSprite() {
        this.imagesRequested = true;
        return this.original;
    }

    @Override
    public int getTextureWidth() {
        return this.textureWidth;
    }

    @Override
    public int getTextureHeight() {
        return this.textureHeight;
    }

    @Override
    public ResourceLocation getTextureIdentifier() {
        return this.identifier;
    }

    @Override
    public NativeImage[] getTextureBuffers() {
        this.imagesRequested = true;
        return this.images;
    }

    @Override
    public int getAtlasWidth() {
        return this.atlasWidth;
    }

    @Override
    public int getAtlasHeight() {
        return this.atlasHeight;
    }

    @Override
    public TextureAtlas getAtlas() {
        return this.atlas;
    }

    @Override
    public int getSpritePositionX() {
        return this.spriteX;
    }

    @Override
    public int getSpritePositionY() {
        return this.spriteY;
    }

    @Override
    public int getSpriteWidth() {
        return this.spriteWidth;
    }

    @Override
    public int getSpriteHeight() {
        return this.spriteHeight;
    }

    @Override
    public int getMipmapLevels() {
        return this.mipmapLevels;
    }

    @Override
    public void close() {
        this.closeUnusedResources();
    }
}

