/*
 * Decompiled with CFR 0.152.
 */
package com.example.SoundOfRain;

import com.example.SoundOfRain.SoundOfRainConfig;
import com.example.SoundOfRain.SoundRegistry;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class ThunderSoundHandler {
    private static final Random RANDOM = new Random();
    private final ConcurrentHashMap<Long, ThunderTask> scheduledThunder = new ConcurrentHashMap();
    private final AtomicLong taskIdCounter = new AtomicLong(0L);

    public void handleLightningStrike(BlockPos strikePos) {
        BlockPos playerPos;
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        boolean enabled = (Boolean)SoundOfRainConfig.CLIENT.thunderSounds.get();
        BlockPos blockPos = playerPos = mc.f_91074_ != null ? mc.f_91074_.m_20183_() : null;
        if (playerPos == null) {
            return;
        }
        double distanceChunks = this.calculateDistanceInChunks(playerPos, strikePos);
        ThunderData thunderData = this.determineThunderTypeAndDelay(distanceChunks);
        if (thunderData.delayTicks == 0) {
            this.playThunderSound(thunderData.sound, strikePos, enabled ? 1.0f : 0.0f, 1.0f);
        } else {
            this.scheduleThunder(thunderData.sound, strikePos, thunderData.delayTicks, enabled ? 1.0f : 0.0f);
        }
    }

    private void playThunderSound(SoundEvent thunderSound, BlockPos strikePos, float customVolume, float pitch) {
        if (!((Boolean)SoundOfRainConfig.CLIENT.thunderSounds.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91073_ == null || mc.f_91074_ == null || thunderSound == null) {
            return;
        }
        mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)thunderSound, (float)pitch));
    }

    public void tick(long currentTick) {
        this.scheduledThunder.entrySet().removeIf(entry -> {
            ThunderTask task = (ThunderTask)entry.getValue();
            if (currentTick >= task.playAtTick) {
                boolean enabled = (Boolean)SoundOfRainConfig.CLIENT.thunderSounds.get();
                this.playThunderSound(task.sound, task.pos, enabled ? 1.0f : 0.0f, 1.0f);
                return true;
            }
            return false;
        });
    }

    private double calculateDistanceInChunks(BlockPos playerPos, BlockPos strikePos) {
        double distanceBlocks = Math.sqrt(playerPos.m_123331_((Vec3i)strikePos));
        return distanceBlocks / 16.0;
    }

    private ThunderData determineThunderTypeAndDelay(double distanceChunks) {
        SoundEvent far;
        SoundEvent close = SoundRegistry.THUNDER_CLOSE.isPresent() ? (SoundEvent)SoundRegistry.THUNDER_CLOSE.get() : SoundEvents.f_12090_;
        SoundEvent medium = SoundRegistry.THUNDER_MEDIUM.isPresent() ? (SoundEvent)SoundRegistry.THUNDER_MEDIUM.get() : SoundEvents.f_12090_;
        SoundEvent soundEvent = far = SoundRegistry.THUNDER_FAR.isPresent() ? (SoundEvent)SoundRegistry.THUNDER_FAR.get() : SoundEvents.f_12090_;
        if (distanceChunks <= 3.0) {
            return new ThunderData(close, 0);
        }
        if (distanceChunks <= 7.0) {
            int delayTicks = 10 + RANDOM.nextInt(21);
            return new ThunderData(medium, delayTicks);
        }
        int delayTicks = 25 + RANDOM.nextInt(26);
        return new ThunderData(far, delayTicks);
    }

    private void scheduleThunder(SoundEvent thunderSound, BlockPos strikePos, int delayTicks, float customVolume) {
        Long currentTick;
        if (!((Boolean)SoundOfRainConfig.CLIENT.thunderSounds.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91073_ == null) {
            return;
        }
        Long l = currentTick = mc.f_91073_ != null ? Long.valueOf(mc.f_91073_.m_46467_()) : null;
        if (currentTick == null) {
            return;
        }
        long playAtTick = currentTick + (long)delayTicks;
        long taskId = this.taskIdCounter.incrementAndGet();
        this.scheduledThunder.put(taskId, new ThunderTask(thunderSound, strikePos, playAtTick));
    }

    private static class ThunderData {
        final SoundEvent sound;
        final int delayTicks;

        ThunderData(SoundEvent sound, int delayTicks) {
            this.sound = sound;
            this.delayTicks = delayTicks;
        }
    }

    private static class ThunderTask {
        final SoundEvent sound;
        final BlockPos pos;
        final long playAtTick;

        ThunderTask(SoundEvent sound, BlockPos pos, long playAtTick) {
            this.sound = sound;
            this.pos = pos;
            this.playAtTick = playAtTick;
        }
    }
}

