/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable;

import artifacts.client.ToggleKeyHandler;
import artifacts.item.ArtifactItem;
import artifacts.item.wearable.ArtifactAttributeModifier;
import artifacts.platform.PlatformServices;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class WearableArtifactItem
extends ArtifactItem {
    private final List<ArtifactAttributeModifier> attributeModifiers = new ArrayList<ArtifactAttributeModifier>();

    public WearableArtifactItem(Item.Properties properties) {
        super(properties);
    }

    public WearableArtifactItem() {
        this(new Item.Properties());
    }

    public void addAttributeModifier(ArtifactAttributeModifier attributeModifier) {
        this.attributeModifiers.add(attributeModifier);
    }

    public List<ArtifactAttributeModifier> getAttributeModifiers() {
        return this.attributeModifiers;
    }

    public boolean isEquippedBy(@Nullable LivingEntity entity) {
        return PlatformServices.platformHelper.isEquippedBy(entity, this);
    }

    public Stream<ItemStack> findAllEquippedBy(LivingEntity entity) {
        return PlatformServices.platformHelper.findAllEquippedBy(entity, this);
    }

    public void onEquip(LivingEntity entity, ItemStack stack) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        for (ArtifactAttributeModifier modifier : this.attributeModifiers) {
            AttributeInstance attributeInstance = entity.m_21051_(modifier.getAttribute());
            if (attributeInstance == null) continue;
            attributeInstance.m_22120_(modifier.getModifierId());
            AttributeModifier attributeModifier = modifier.createModifier();
            attributeInstance.m_22125_(attributeModifier);
            modifier.onAttributeUpdated(entity);
        }
    }

    public void onUnequip(LivingEntity entity, ItemStack stack) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        for (ArtifactAttributeModifier modifier : this.attributeModifiers) {
            AttributeInstance attributeInstance = entity.m_21051_(modifier.getAttribute());
            if (attributeInstance == null) continue;
            attributeInstance.m_22120_(modifier.getModifierId());
            modifier.onAttributeUpdated(entity);
        }
    }

    public void wornTick(LivingEntity entity, ItemStack stack) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        for (ArtifactAttributeModifier modifier : this.attributeModifiers) {
            AttributeModifier existingModifier;
            AttributeInstance attributeInstance = entity.m_21051_(modifier.getAttribute());
            if (attributeInstance == null || (existingModifier = attributeInstance.m_22111_(modifier.getModifierId())) != null && existingModifier.m_22218_() == modifier.getAmount()) continue;
            attributeInstance.m_22120_(modifier.getModifierId());
            attributeInstance.m_22125_(modifier.createModifier());
            modifier.onAttributeUpdated(entity);
        }
    }

    @Override
    public final boolean isCosmetic() {
        for (ArtifactAttributeModifier modifier : this.attributeModifiers) {
            if (modifier.getAmount() == 0.0) continue;
            return false;
        }
        return this.getFortuneLevel() == 0 && this.getLootingLevel() == 0 && !this.canWalkOnPowderedSnow() && !this.hasNonCosmeticEffects();
    }

    protected boolean hasNonCosmeticEffects() {
        return false;
    }

    public SoundEvent getEquipSound() {
        return SoundEvents.f_11675_;
    }

    public int getFortuneLevel() {
        return 0;
    }

    public int getLootingLevel() {
        return 0;
    }

    public boolean makesPiglinsNeutral() {
        return false;
    }

    public boolean canWalkOnPowderedSnow() {
        return false;
    }

    public void toggleItem(ServerPlayer player) {
        this.findAllEquippedBy((LivingEntity)player).forEach(stack -> WearableArtifactItem.setActivated(stack, !WearableArtifactItem.isActivated(stack)));
    }

    public static boolean isActivated(ItemStack stack) {
        return !stack.m_41782_() || !stack.m_41784_().m_128441_("isActivated") || stack.m_41784_().m_128471_("isActivated");
    }

    public static void setActivated(ItemStack stack, boolean active) {
        stack.m_41784_().m_128379_("isActivated", active);
    }

    @Override
    protected void addEffectsTooltip(ItemStack stack, List<MutableComponent> tooltip) {
        super.addEffectsTooltip(stack, tooltip);
        KeyMapping key = ToggleKeyHandler.getToggleKey(this);
        if (!(key == null || key.m_90862_() && WearableArtifactItem.isActivated(stack))) {
            tooltip.add(Component.m_237110_((String)"%s.tooltip.toggle_keymapping".formatted("artifacts"), (Object[])new Object[]{key.m_90863_()}));
        }
    }
}

