/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser.processor;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.BinomialLootNumberProviderAccessor;
import fzzyhmstrs.emi_loot.mixins.BoundedIntUnaryOperatorAccessor;
import fzzyhmstrs.emi_loot.mixins.ConstantLootNumberProviderAccessor;
import fzzyhmstrs.emi_loot.mixins.ScoreLootNumberProviderAccessor;
import fzzyhmstrs.emi_loot.mixins.UniformLootNumberProviderAccessor;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.Objects;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class NumberProcessors {
    public static MutableComponent processBoolean(Boolean input, String keyTrue, String keyFalse, Object ... args) {
        if (input != null) {
            if (input.booleanValue()) {
                return LText.translatable(keyTrue, args);
            }
            return LText.translatable(keyFalse, args);
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Boolean null for keys: " + keyTrue + " / " + keyFalse + " in table: " + LootTableParser.currentTable);
        }
        return LText.empty();
    }

    public static MutableComponent processNumberRange(MinMaxBounds<?> range, String exact, String between, String atLeast, String atMost, String fallback, Object ... args) {
        if (!range.equals((Object)MinMaxBounds.Ints.f_55364_) && !range.equals((Object)MinMaxBounds.Doubles.f_154779_)) {
            Number max;
            Number min = range.m_55305_();
            if (Objects.equals(min, max = range.m_55326_()) && min != null) {
                return LText.translatable(exact, min, args);
            }
            if (min != null && max != null) {
                return LText.translatable(between, min, max, args);
            }
            if (min != null) {
                return LText.translatable(atLeast, min, args);
            }
            if (max != null) {
                return LText.translatable(atMost, max, args);
            }
            if (fallback.equals("")) {
                return LText.empty();
            }
            return LText.translatable(fallback);
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Non-specific number range for keys: " + exact + " / " + between + " in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }

    public static MutableComponent processBoundedIntUnaryOperator(IntRange operator) {
        NumberProvider min = ((BoundedIntUnaryOperatorAccessor)operator).getMin();
        NumberProvider max = ((BoundedIntUnaryOperatorAccessor)operator).getMax();
        if (min != null && max != null) {
            float maxVal;
            float minVal;
            if (min.m_142587_() == NumberProviders.f_165731_ && max.m_142587_() == NumberProviders.f_165731_ && (minVal = ((ConstantLootNumberProviderAccessor)min).getValue()) == (maxVal = ((ConstantLootNumberProviderAccessor)max).getValue())) {
                return NumberProcessors.processLootNumberProvider(min);
            }
            return LText.translatable("emi_loot.operator.between", NumberProcessors.processLootNumberProvider(min), NumberProcessors.processLootNumberProvider(max));
        }
        if (min != null) {
            return LText.translatable("emi_loot.operator.min", NumberProcessors.processLootNumberProvider(min));
        }
        if (max != null) {
            return LText.translatable("emi_loot.operator.max", NumberProcessors.processLootNumberProvider(max));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Null or undefined bounded int unary operator in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.operator.unknown");
    }

    public static MutableComponent processLootNumberProvider(NumberProvider provider) {
        LootNumberProviderType type = provider.m_142587_();
        if (type == NumberProviders.f_165731_) {
            return LText.translatable("emi_loot.number_provider.constant", Float.valueOf(((ConstantLootNumberProviderAccessor)provider).getValue()));
        }
        if (type == NumberProviders.f_165733_) {
            NumberProvider n = ((BinomialLootNumberProviderAccessor)provider).getN();
            NumberProvider p = ((BinomialLootNumberProviderAccessor)provider).getP();
            float nVal = NumberProcessors.getRollAvg(n);
            float pVal = NumberProcessors.getRollAvg(p);
            MutableComponent nValText = NumberProcessors.processLootNumberProvider(n);
            MutableComponent pValText = NumberProcessors.processLootNumberProvider(p);
            float avg = nVal * pVal;
            return LText.translatable("emi_loot.number_provider.binomial", nValText, pValText, Float.valueOf(avg));
        }
        if (type == NumberProviders.f_165732_) {
            NumberProvider min = ((UniformLootNumberProviderAccessor)provider).getMin();
            NumberProvider max = ((UniformLootNumberProviderAccessor)provider).getMax();
            float minVal = NumberProcessors.getRollAvg(min);
            float maxVal = NumberProcessors.getRollAvg(max);
            MutableComponent minValText = NumberProcessors.processLootNumberProvider(min);
            MutableComponent maxValText = NumberProcessors.processLootNumberProvider(max);
            float avg = (minVal + maxVal) / 2.0f;
            return LText.translatable("emi_loot.number_provider.uniform", minValText, maxValText, Float.valueOf(avg));
        }
        if (type == NumberProviders.f_165734_) {
            String lootScore = ((ScoreLootNumberProviderAccessor)provider).getScore();
            float lootScale = ((ScoreLootNumberProviderAccessor)provider).getScale();
            return LText.translatable("emi_loot.number_provider.score", lootScore, Float.valueOf(lootScale));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Non-specific or undefined number provider in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.number_provider.unknown");
    }

    public static float getRollAvg(NumberProvider provider) {
        LootNumberProviderType type = provider.m_142587_();
        if (type == NumberProviders.f_165731_) {
            return ((ConstantLootNumberProviderAccessor)provider).getValue();
        }
        if (type == NumberProviders.f_165733_) {
            NumberProvider n = ((BinomialLootNumberProviderAccessor)provider).getN();
            NumberProvider p = ((BinomialLootNumberProviderAccessor)provider).getP();
            float nVal = NumberProcessors.getRollAvg(n);
            float pVal = NumberProcessors.getRollAvg(p);
            return nVal * pVal;
        }
        if (type == NumberProviders.f_165732_) {
            NumberProvider min = ((UniformLootNumberProviderAccessor)provider).getMin();
            NumberProvider max = ((UniformLootNumberProviderAccessor)provider).getMax();
            float minVal = NumberProcessors.getRollAvg(min);
            float maxVal = NumberProcessors.getRollAvg(max);
            return (minVal + maxVal) / 2.0f;
        }
        if (type == NumberProviders.f_165734_) {
            return 0.0f;
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Loot number provider with unknown type: " + provider.m_142587_().toString());
        }
        return 0.0f;
    }
}

