/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.network.defaults;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.defaults.AbstractPacketType;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public interface DatalessPacketType<T extends Packet<T>>
extends PacketType<T> {
    public T create();

    @Override
    default public void encode(T message, FriendlyByteBuf buffer) {
    }

    @Override
    default public T decode(FriendlyByteBuf buffer) {
        return this.create();
    }

    public static abstract class Server<T extends Packet<T>>
    extends AbstractPacketType.Server<T>
    implements DatalessPacketType<T> {
        private final Supplier<T> factory;

        public Server(Class<T> clazz, ResourceLocation id, Supplier<T> factory) {
            super(clazz, id);
            this.factory = factory;
        }

        @Override
        public T create() {
            return (T)((Packet)this.factory.get());
        }
    }

    public static abstract class Client<T extends Packet<T>>
    extends AbstractPacketType.Client<T>
    implements DatalessPacketType<T> {
        private final Supplier<T> factory;

        public Client(Class<T> clazz, ResourceLocation id, Supplier<T> factory) {
            super(clazz, id);
            this.factory = factory;
        }

        @Override
        public T create() {
            return (T)((Packet)this.factory.get());
        }
    }
}

