/*
 * Decompiled with CFR 0.152.
 */
package com.jkvin114.displaydelight.block;

import com.jkvin114.displaydelight.block.AbstractItemBlock;
import com.jkvin114.displaydelight.init.BlockAssociations;
import com.jkvin114.displaydelight.init.DisplayBlocks;
import com.jkvin114.displaydelight.init.DisplayProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractStackablePlatedFoodBlock
extends AbstractItemBlock {
    public static final IntegerProperty STACKS = DisplayProperties.STACKS;

    public AbstractStackablePlatedFoodBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)STACKS, (Comparable)Integer.valueOf(6)));
    }

    public BlockState getStateFrom(BlockState plate, Direction direction, int count) {
        if (plate.m_60713_((Block)DisplayBlocks.PLATE.get())) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction.m_122424_())).m_61124_((Property)STACKS, (Comparable)Integer.valueOf(Math.min(count, this.getMaxStackable())));
        }
        return this.m_49966_();
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stk = this.getStackFor();
        if (stk.m_41720_().equals(Items.f_41852_)) {
            stk = new ItemStack((ItemLike)state.m_60734_().m_5456_());
        }
        return stk;
    }

    @Override
    public ItemStack getStackFor() {
        return new ItemStack((ItemLike)BlockAssociations.getPlatedItemFor((Block)this));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{STACKS});
    }

    public int getStacks(BlockState state) {
        return (Integer)state.m_61143_((Property)STACKS);
    }

    public BlockState getDecrementedState(BlockState state) {
        int stk = this.getStacks(state) - 1;
        if (this.getStacks(state) >= this.getMaxStackable()) {
            stk = this.getMaxStackable() - 1;
        }
        return (BlockState)state.m_61124_((Property)STACKS, (Comparable)Integer.valueOf(Math.max(1, stk)));
    }

    public BlockState getIncrementedState(BlockState state, int count) {
        return (BlockState)state.m_61124_((Property)STACKS, (Comparable)Integer.valueOf(Math.min(this.getStacks(state) + count, this.getMaxStackable())));
    }

    public abstract int getMaxStackable();

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return AbstractStackablePlatedFoodBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
    }
}

