/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.DropDownBox;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.ListPicker;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.NamedElement;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.animation.interpolator.InterpolatorType;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.anim.AnimationDisplayData;
import com.tom.cpm.shared.editor.anim.AnimationProperties;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Predicate;

public class AnimationSettingsPopup
extends PopupPanel {
    private final Editor editor;
    private String title;

    public AnimationSettingsPopup(IGui gui, Editor editor, boolean edit) {
        super(gui);
        this.editor = editor;
        this.setBounds(new Box(0, 0, 200, 195));
        FlowLayout layout = new FlowLayout(this, 4, 1);
        AnimType sel = null;
        ArrayList<AnimType> ats = new ArrayList<AnimType>();
        for (VanillaPose vanillaPose : VanillaPose.VALUES) {
            if (vanillaPose == VanillaPose.CUSTOM) continue;
            AnimType type = new AnimType(vanillaPose);
            ats.add(type);
            if (!edit || editor.selectedAnim == null || vanillaPose != editor.selectedAnim.pose) continue;
            sel = type;
        }
        for (Enum enum_ : AnimationType.VALUES) {
            if (!((AnimationType)enum_).isCustom()) continue;
            AnimType at = new AnimType((AnimationType)enum_);
            ats.add(at);
            if (!edit || editor.selectedAnim == null || sel != null || editor.selectedAnim.type != enum_) continue;
            sel = at;
        }
        ListPicker typeDd = new ListPicker(gui.getFrame(), ats);
        typeDd.setListLoader(l -> {
            l.setComparator(Comparator.comparing(AnimType::getType).thenComparing(Comparator.comparing(AnimType::toString)));
            l.setRenderer(AnimType::draw);
            l.setGetTooltip(AnimType::getTooltip);
        });
        typeDd.setBounds(new Box(5, 0, 190, 20));
        this.addElement(typeDd);
        if (sel != null) {
            typeDd.setSelected(sel);
        }
        Checkbox boxAdd = new Checkbox(gui, gui.i18nFormat("label.cpm.anim_additive", new Object[0]));
        if (edit && editor.selectedAnim != null) {
            boxAdd.setSelected(editor.selectedAnim.add);
        } else {
            boxAdd.setSelected(true);
        }
        boxAdd.setBounds(new Box(5, 0, 60, 20));
        this.addElement(boxAdd);
        boxAdd.setAction(() -> boxAdd.setSelected(!boxAdd.isSelected()));
        Checkbox boxLoop = new Checkbox(gui, gui.i18nFormat("label.cpm.anim_loop", new Object[0]));
        if (edit && editor.selectedAnim != null) {
            boxLoop.setSelected(editor.selectedAnim.loop);
        }
        boxLoop.setBounds(new Box(5, 0, 60, 20));
        this.addElement(boxLoop);
        this.addElement(new Label(gui, gui.i18nFormat("label.cpm.name", new Object[0])).setBounds(new Box(5, 0, 190, 10)));
        Panel panel = new Panel(gui);
        panel.setBounds(new Box(5, 0, 190, 20));
        this.addElement(panel);
        TextField nameField = new TextField(gui);
        if (edit && editor.selectedAnim != null) {
            nameField.setText(editor.selectedAnim.getDisplayName());
        }
        nameField.setBounds(new Box(0, 0, 190, 20));
        panel.addElement(nameField);
        ArrayList selAnims = new ArrayList();
        editor.animations.stream().map(a -> a.pose).filter(p -> p != null && p != VanillaPose.CUSTOM && p != VanillaPose.GLOBAL).distinct().map(x$0 -> new AnimSel((IPose)x$0)).forEach(selAnims::add);
        editor.animations.stream().filter(a -> a.pose == null && !a.type.isStaged() && (a.type != AnimationType.GESTURE || a.loop) && a.type != AnimationType.VALUE_LAYER).map(a -> new AnimSel(a.getId(), a.getDisplayGroup(), a.type)).distinct().forEach(selAnims::add);
        ListPicker dropDownAnimSel = new ListPicker(gui.getFrame(), selAnims);
        dropDownAnimSel.setBounds(new Box(0, 0, 190, 20));
        dropDownAnimSel.setVisible(false);
        panel.addElement(dropDownAnimSel);
        dropDownAnimSel.setListLoader(l -> l.setRenderer(AnimSel::draw));
        if (edit && editor.selectedAnim != null && editor.selectedAnim.type.isStaged()) {
            nameField.setVisible(false);
            dropDownAnimSel.setVisible(true);
            String[] nm = editor.selectedAnim.displayName.split(":", 2);
            if (nm.length == 2) {
                AnimSel s;
                Predicate<AnimSel> search = null;
                block5 : switch (nm[0]) {
                    case "p": {
                        for (VanillaPose p3 : VanillaPose.VALUES) {
                            if (!nm[1].equals(p3.name().toLowerCase(Locale.ROOT))) continue;
                            search = a -> a.pose == p3;
                            break block5;
                        }
                        break;
                    }
                    case "c": {
                        search = a -> a.pose instanceof CustomPose && ((CustomPose)a.pose).getName().equals(nm[1]);
                        break;
                    }
                    case "g": {
                        search = a -> a.gesture != null && a.gesture.equals(nm[1]);
                        break;
                    }
                }
                if (search != null && (s = (AnimSel)selAnims.stream().filter(search).findFirst().orElse(null)) != null) {
                    dropDownAnimSel.setSelected(s);
                }
            }
        }
        this.addElement(new Label(gui, gui.i18nFormat("label.cpm.animIntType", new Object[0])).setBounds(new Box(5, 0, 190, 10)));
        NamedElement.NameMapper<InterpolatorType> intMap = new NamedElement.NameMapper<InterpolatorType>(InterpolatorType.VALUES, e -> gui.i18nFormat("label.cpm.animIntType." + e.name().toLowerCase(Locale.ROOT), new Object[0]));
        DropDownBox<NamedElement<InterpolatorType>> intBox = new DropDownBox<NamedElement<InterpolatorType>>(gui.getFrame(), intMap.asList());
        intMap.setSetter(intBox::setSelected);
        if (edit && editor.selectedAnim != null) {
            intMap.setValue(editor.selectedAnim.intType);
        } else {
            intMap.setValue(InterpolatorType.POLY_LOOP);
        }
        intBox.setBounds(new Box(5, 0, 190, 20));
        this.addElement(intBox);
        Checkbox boxCommand = new Checkbox(gui, gui.i18nFormat("label.cpm.anim_command", new Object[0]));
        Checkbox boxLayerCtrl = new Checkbox(gui, gui.i18nFormat("label.cpm.anim_layerCtrl", new Object[0]));
        Checkbox boxMustFinish = new Checkbox(gui, gui.i18nFormat("label.cpm.anim_mustFinish", new Object[0]));
        Checkbox boxHidden = new Checkbox(gui, gui.i18nFormat("label.cpm.anim_hidden", new Object[0]));
        Runnable r = () -> {
            boolean st;
            AnimType at = (AnimType)typeDd.getSelected();
            boxLoop.setEnabled(at.canLoop());
            boxCommand.setEnabled(at.option.isCustom() && !at.option.isStaged());
            boxLayerCtrl.setEnabled(at.option == AnimationType.CUSTOM_POSE || at.option == AnimationType.GESTURE);
            if (!edit) {
                intMap.setValue(((InterpolatorType)((Object)((Object)((Object)((NamedElement)intBox.getSelected()).getElem())))).getAlt(at.useLooping()));
            }
            nameField.setVisible(!(st = at.option.isStaged()));
            dropDownAnimSel.setVisible(st);
            boxMustFinish.setEnabled(!st);
            boxHidden.setEnabled(at.option.isCustom() && !st);
        };
        typeDd.setAction(r);
        r.run();
        boxLoop.setAction(() -> {
            boolean s;
            boolean bl = s = !boxLoop.isSelected();
            if (!edit) {
                intMap.setValue(((InterpolatorType)((Object)((Object)((Object)((NamedElement)intBox.getSelected()).getElem())))).getAlt(s));
            }
            boxLoop.setSelected(s);
        });
        if (edit && editor.selectedAnim != null) {
            boxCommand.setSelected(editor.selectedAnim.command);
        }
        boxCommand.setBounds(new Box(5, 0, 190, 20));
        boxCommand.setTooltip(new Tooltip(gui.getFrame(), gui.i18nFormat("tooltip.cpm.anim_command", new Object[0])));
        boxCommand.setAction(() -> boxCommand.setSelected(!boxCommand.isSelected()));
        this.addElement(boxCommand);
        if (edit && editor.selectedAnim != null) {
            boxLayerCtrl.setSelected(editor.selectedAnim.layerControlled);
        } else {
            boxLayerCtrl.setSelected(true);
        }
        boxLayerCtrl.setTooltip(new Tooltip(gui.getFrame(), gui.i18nFormat("tooltip.cpm.anim_layerCtrl", new Object[0])));
        boxLayerCtrl.setBounds(new Box(5, 0, 190, 20));
        boxLayerCtrl.setAction(() -> boxLayerCtrl.setSelected(!boxLayerCtrl.isSelected()));
        this.addElement(boxLayerCtrl);
        if (edit && editor.selectedAnim != null) {
            boxMustFinish.setSelected(editor.selectedAnim.mustFinish);
        }
        boxMustFinish.setTooltip(new Tooltip(gui.getFrame(), gui.i18nFormat("tooltip.cpm.anim_mustFinish", new Object[0])));
        boxMustFinish.setBounds(new Box(5, 0, 190, 20));
        boxMustFinish.setAction(() -> boxMustFinish.setSelected(!boxMustFinish.isSelected()));
        this.addElement(boxMustFinish);
        if (edit && editor.selectedAnim != null) {
            boxHidden.setSelected(editor.selectedAnim.hidden);
        }
        boxHidden.setTooltip(new Tooltip(gui.getFrame(), gui.i18nFormat("tooltip.cpm.anim_hidden", new Object[0])));
        boxHidden.setBounds(new Box(5, 0, 190, 20));
        boxHidden.setAction(() -> boxHidden.setSelected(!boxHidden.isSelected()));
        this.addElement(boxHidden);
        Button okBtn = new Button(gui, gui.i18nFormat("button.cpm.ok", new Object[0]), () -> {
            IPose pose;
            String name = nameField.getText();
            AnimType at = (AnimType)typeDd.getSelected();
            IPose iPose = pose = at.option == AnimationType.CUSTOM_POSE ? new CustomPose(name, 0) : at.pose;
            if (at.option.isStaged()) {
                AnimSel s = (AnimSel)dropDownAnimSel.getSelected();
                if (s == null) {
                    return;
                }
                name = s.getName();
            }
            AnimationProperties pr = new AnimationProperties(pose, name, at.option, boxAdd.isSelected(), at.canLoop() && boxLoop.isSelected(), (InterpolatorType)((Object)((Object)((Object)((NamedElement)intBox.getSelected()).getElem()))), boxCommand.isSelected(), boxLayerCtrl.isSelected(), boxMustFinish.isSelected(), boxHidden.isSelected());
            if (edit) {
                editor.editAnim(pr);
            } else {
                editor.addNewAnim(pr);
            }
            this.close();
        });
        okBtn.setBounds(new Box(80, 0, 40, 20));
        this.addElement(okBtn);
        layout.reflow();
        this.title = gui.i18nFormat("label.cpm.animationSettings." + (edit ? "edit" : "new"), new Object[0]);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    private class AnimType {
        private VanillaPose pose;
        private AnimationDisplayData display;
        private final AnimationType option;

        public AnimType(VanillaPose pose) {
            this.option = AnimationType.POSE;
            this.pose = pose;
            this.display = AnimationDisplayData.getFor(pose);
        }

        public AnimType(AnimationType option) {
            this.option = option;
        }

        public String toString() {
            if (this.pose != null) {
                return AnimationSettingsPopup.this.gui.i18nFormat("label.cpm.anim_pose", this.pose.getName(AnimationSettingsPopup.this.gui, null));
            }
            return AnimationSettingsPopup.this.gui.i18nFormat("label.cpm.new_anim_" + this.option.name().toLowerCase(Locale.ROOT), new Object[0]);
        }

        private AnimationDisplayData.Type getType() {
            return this.display == null ? AnimationDisplayData.Type.CUSTOM : this.display.type;
        }

        private Tooltip getTooltip() {
            String tooltip = AnimationSettingsPopup.this.gui.i18nFormat("tooltip.cpm.animType.group." + this.getType().name().toLowerCase(Locale.ROOT), new Object[0]);
            String tip = "tooltip.cpm.animType.pose." + (String)(this.pose != null ? this.pose.name().toLowerCase(Locale.ROOT) : "opt_" + this.option.name().toLowerCase(Locale.ROOT));
            String desc = AnimationSettingsPopup.this.gui.i18nFormat(tip, new Object[0]);
            String name = this.toString();
            String fullTip = name + "\\" + tooltip;
            if (!tip.equals(desc)) {
                fullTip = fullTip + "\\" + desc;
            }
            return new Tooltip(AnimationSettingsPopup.this.gui.getFrame(), fullTip);
        }

        private void draw(int x, int y, int w, int h, boolean hovered, boolean selected) {
            int bg = ((AnimationSettingsPopup)AnimationSettingsPopup.this).gui.getColors().select_background;
            if (hovered) {
                bg = ((AnimationSettingsPopup)AnimationSettingsPopup.this).gui.getColors().popup_background;
            }
            if (selected || hovered) {
                AnimationSettingsPopup.this.gui.drawBox(x, y, w, h, bg);
            }
            AnimationSettingsPopup.this.gui.drawText(x + 3, y + h / 2 - 4, this.toString(), this.getType().color);
        }

        private boolean useLooping() {
            return this.option.isStaged() ? false : (this.pose == null ? true : !this.pose.hasStateGetter());
        }

        private boolean canLoop() {
            return this.option.canLoop();
        }
    }

    private class AnimSel {
        private IPose pose;
        private String gesture;
        private String name;
        private AnimationType type;

        public AnimSel(IPose pose) {
            this.pose = pose;
        }

        public AnimSel(String gesture, String name, AnimationType type) {
            this.gesture = gesture;
            this.name = name;
            this.type = type;
        }

        public String toString() {
            if (this.pose != null) {
                return AnimationSettingsPopup.this.editor.ui.i18nFormat("label.cpm.anim_pose", this.pose.getName(AnimationSettingsPopup.this.gui, null));
            }
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.gesture == null ? 0 : this.gesture.hashCode());
            result = 31 * result + (this.pose == null ? 0 : this.pose.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnimSel other = (AnimSel)obj;
            if (this.gesture == null ? other.gesture != null : !this.gesture.equals(other.gesture)) {
                return false;
            }
            return !(this.pose == null ? other.pose != null : !this.pose.equals(other.pose));
        }

        public String getName() {
            if (this.pose instanceof VanillaPose) {
                return "p:" + ((VanillaPose)this.pose).name().toLowerCase(Locale.ROOT);
            }
            if (this.pose instanceof CustomPose) {
                return "c:" + ((CustomPose)this.pose).getName();
            }
            return "g:" + this.gesture;
        }

        private void draw(int x, int y, int w, int h, boolean hovered, boolean selected) {
            int bg = ((AnimationSettingsPopup)AnimationSettingsPopup.this).gui.getColors().select_background;
            if (hovered) {
                bg = ((AnimationSettingsPopup)AnimationSettingsPopup.this).gui.getColors().popup_background;
            }
            if (selected || hovered) {
                AnimationSettingsPopup.this.gui.drawBox(x, y, w, h, bg);
            }
            int anType = AnimationDisplayData.Type.GLOBAL.color;
            if (this.pose instanceof VanillaPose) {
                anType = AnimationDisplayData.getFor((VanillaPose)((VanillaPose)this.pose)).type.color;
            } else if (this.pose != null) {
                anType = AnimationDisplayData.Type.CUSTOM.color;
            } else if (this.type != null) {
                switch (this.type) {
                    case GESTURE: {
                        anType = 0x8888FF;
                        break;
                    }
                    case LAYER: {
                        anType = 0xFF88FF;
                        break;
                    }
                    case VALUE_LAYER: {
                        anType = 0x88FFFF;
                        break;
                    }
                    default: {
                        anType = AnimationDisplayData.Type.CUSTOM.color;
                    }
                }
            }
            AnimationSettingsPopup.this.gui.drawText(x + 3, y + h / 2 - 4, this.toString(), anType);
        }
    }
}

