/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public final class InventoryUtil {
    private InventoryUtil() {
    }

    public static int getHandSlot(Player player, InteractionHand hand) {
        return switch (hand) {
            default -> throw new IncompatibleClassChangeError();
            case InteractionHand.MAIN_HAND -> player.m_150109_().f_35977_;
            case InteractionHand.OFF_HAND -> 40;
        };
    }

    public static int getInventorySlotFromCompartment(Player player, int slot, ItemStack stack) {
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Cannot search for empty stack");
        }
        if (slot >= 0 && slot < 36 && player.m_150109_().m_8020_(slot) == stack) {
            return slot;
        }
        if (player.m_150109_().m_8020_(40) == stack) {
            return 40;
        }
        return -1;
    }

    public static @Nullable Container getEntityContainer(ServerLevel level, BlockPos pos, Direction side) {
        Container container;
        EntityHitResult entityHit;
        Entity entity;
        Direction dir;
        Vec3 vecDir;
        Vec3 vecStart = new Vec3((double)pos.m_123341_() + 0.5 + 0.6 * (double)side.m_122429_(), (double)pos.m_123342_() + 0.5 + 0.6 * (double)side.m_122430_(), (double)pos.m_123343_() + 0.5 + 0.6 * (double)side.m_122431_());
        HitResult hit = WorldUtil.clip((Level)level, vecStart, vecDir = new Vec3((double)(dir = side.m_122424_()).m_122429_(), (double)dir.m_122430_(), (double)dir.m_122431_()), 1.1, null);
        return hit instanceof EntityHitResult && (entity = (entityHit = (EntityHitResult)hit).m_82443_()) instanceof Container ? (container = (Container)entity) : null;
    }

    public static ItemStack storeItemsIntoSlot(Container container, ItemStack stack, int slot) {
        return InventoryUtil.storeItems(container, stack, slot, 1);
    }

    public static ItemStack storeItemsFromOffset(Container container, ItemStack stack, int offset) {
        return InventoryUtil.storeItems(container, stack, offset, container.m_6643_());
    }

    private static ItemStack storeItems(Container container, ItemStack stack, int offset, int slotCount) {
        int originalCount = stack.m_41613_();
        ItemStack remainder = InventoryUtil.storeItemsImpl(container, stack, offset, slotCount);
        if (remainder.m_41613_() != originalCount) {
            container.m_6596_();
        }
        return remainder;
    }

    private static ItemStack storeItemsImpl(Container container, ItemStack stack, int offset, int slotCount) {
        int limit = container.m_6643_();
        int maxSize = Math.min(stack.m_41741_(), container.m_6893_());
        if (maxSize <= 0) {
            return stack;
        }
        for (int i = 0; i < slotCount; ++i) {
            ItemStack currentStack;
            int slot = i + offset;
            if (slot >= limit) {
                slot -= limit;
            }
            if ((currentStack = container.m_8020_(slot)).m_41619_()) {
                if (!container.m_7013_(slot, stack)) continue;
                if (stack.m_41613_() <= maxSize) {
                    container.m_6836_(slot, stack);
                    return ItemStack.f_41583_;
                }
                container.m_6836_(slot, stack.m_41620_(maxSize));
                continue;
            }
            if (currentStack.m_41613_() >= Math.min(currentStack.m_41741_(), maxSize) || !InventoryUtil.canMergeItems(currentStack, stack)) continue;
            int toMove = Math.min(stack.m_41613_(), maxSize - currentStack.m_41613_());
            currentStack.m_41769_(toMove);
            stack.m_41774_(toMove);
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    private static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41720_() != stack2.m_41720_()) {
            return false;
        }
        if (stack1.m_41773_() != stack2.m_41773_()) {
            return false;
        }
        if (stack1.m_41613_() > stack1.m_41741_()) {
            return false;
        }
        return ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2);
    }
}

