/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Objects;
import net.mehvahdjukaar.amendments.common.recipe.CauldronCraftingContainer;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemCraftResult;
import net.mehvahdjukaar.amendments.common.recipe.SoftFluidIngredient;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CauldronRecipe
implements Recipe<CauldronCraftingContainer> {
    private final ResourceLocation id;
    private final String group;
    private final NonNullList<Ingredient> inputItems;
    private final SoftFluidIngredient inputFluid;
    private final SoftFluidIngredient outputFluid;
    private final ItemStack outputItem;
    private final boolean requireBoiling = false;
    private final int fluidAmountDifference;

    protected CauldronRecipe(ResourceLocation id, String group, SoftFluidIngredient inputFluid, NonNullList<Ingredient> inputItems, SoftFluidIngredient outputFluid, ItemStack outputItem, int fluidAmountDifference, boolean requireBoiling) {
        this.id = id;
        this.group = group;
        this.inputItems = inputItems;
        this.inputFluid = inputFluid;
        this.outputItem = outputItem;
        this.outputFluid = outputFluid;
        this.fluidAmountDifference = fluidAmountDifference;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRegistry.CAULDRON_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return ModRegistry.CAULDRON_RECIPE_TYPE.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.outputItem;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public boolean matches(CauldronCraftingContainer inv, Level level) {
        Objects.requireNonNull(this);
        StackedContents stackedContents = new StackedContents();
        int i = 0;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemStack = inv.m_8020_(j);
            if (itemStack.m_41619_()) continue;
            ++i;
            stackedContents.m_36468_(itemStack, 1);
        }
        SoftFluidStack tankFluid = inv.getFluid();
        int newCount = tankFluid.getCount() + this.fluidAmountDifference;
        if (!this.inputFluid.matches(tankFluid) || newCount < 0 || newCount > inv.getMaxAllowedFluidCount()) {
            return false;
        }
        return i == this.inputItems.size() && stackedContents.m_36475_((Recipe)this, null);
    }

    @Deprecated
    public ItemStack assemble(CauldronCraftingContainer container, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess);
    }

    public FluidAndItemCraftResult assembleFluid(CauldronCraftingContainer container, RegistryAccess registryAccess) {
        SoftFluidStack tankFluid = container.getFluid();
        ItemStack craftedItem = this.outputItem.m_41777_();
        SoftFluidStack newTankFluid = this.outputFluid.isEmpty() ? tankFluid : this.outputFluid.createStack();
        newTankFluid.setCount(tankFluid.getCount() + this.fluidAmountDifference);
        return FluidAndItemCraftResult.of(craftedItem, newTankFluid);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public static class Serializer
    implements RecipeSerializer<CauldronRecipe> {
        public CauldronRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> inputItems = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"input_items"));
            if (inputItems.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)Utils.hackyGetRegistryAccess());
            SoftFluidStack inputFluid = (SoftFluidStack)((Pair)SoftFluidStack.CODEC.decode((DynamicOps)ops, (Object)GsonHelper.m_13930_((JsonObject)json, (String)"input_fluid")).getOrThrow(false, s -> {})).getFirst();
            if (inputFluid.getCount() != 1) {
                throw new JsonParseException("Input fluid amount must be 1 for cauldron recipes, got: " + inputFluid.getCount());
            }
            JsonObject fiJson = GsonHelper.m_13841_((JsonObject)json, (String)"output_fluid", null);
            SoftFluidStack outputFluid = fiJson == null ? SoftFluidStack.empty() : (SoftFluidStack)((Pair)SoftFluidStack.CODEC.decode((DynamicOps)ops, (Object)fiJson).getOrThrow(false, s -> {})).getFirst();
            JsonObject oiJson = GsonHelper.m_13841_((JsonObject)json, (String)"output_item", null);
            ItemStack outputItem = oiJson == null ? ItemStack.f_41583_ : (ItemStack)((Pair)ItemStack.f_41582_.decode((DynamicOps)ops, (Object)oiJson).getOrThrow(false, s -> {})).getFirst();
            int fluidDifference = GsonHelper.m_13824_((JsonObject)json, (String)"fluid_amount_difference", (int)0);
            boolean requireBoiling = GsonHelper.m_13855_((JsonObject)json, (String)"require_boiling", (boolean)false);
            return new CauldronRecipe(recipeId, group, SoftFluidIngredient.containing(inputFluid), inputItems, SoftFluidIngredient.containing(outputFluid), outputItem, fluidDifference, requireBoiling);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray ingredientArray) {
            NonNullList nonNullList = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_288218_((JsonElement)ingredientArray.get(i), (boolean)false);
                if (ingredient.m_43947_()) continue;
                nonNullList.add((Object)ingredient);
            }
            return nonNullList;
        }

        public CauldronRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String string = buffer.m_130277_();
            int i = buffer.m_130242_();
            NonNullList inputItems = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            inputItems.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            SoftFluidIngredient inputFluid = SoftFluidIngredient.loadFromBuffer(buffer);
            SoftFluidIngredient outputIFluid = SoftFluidIngredient.loadFromBuffer(buffer);
            ItemStack outputItem = buffer.m_130267_();
            int differenceAmount = buffer.m_130242_();
            boolean requireBoiling = buffer.readBoolean();
            return new CauldronRecipe(recipeId, string, inputFluid, (NonNullList<Ingredient>)inputItems, outputIFluid, outputItem, differenceAmount, requireBoiling);
        }

        public void toNetwork(FriendlyByteBuf buffer, CauldronRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(recipe.inputItems.size());
            for (Ingredient ingredient : recipe.inputItems) {
                ingredient.m_43923_(buffer);
            }
            recipe.outputFluid.saveToBuffer(buffer);
            recipe.inputFluid.saveToBuffer(buffer);
            buffer.m_130055_(recipe.outputItem);
            buffer.m_130130_(recipe.fluidAmountDifference);
            buffer.writeBoolean(recipe.requireBoiling);
        }
    }
}

