/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.operation.block;

import dev.huskuraft.effortless.api.core.BlockEntity;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockItem;
import dev.huskuraft.effortless.api.core.BlockState;
import dev.huskuraft.effortless.api.core.DiggerItem;
import dev.huskuraft.effortless.api.core.InteractionHand;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.core.StatTypes;
import dev.huskuraft.effortless.api.platform.PlatformReference;
import dev.huskuraft.effortless.api.tag.RecordTag;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.Storage;
import dev.huskuraft.effortless.building.operation.Operation;
import dev.huskuraft.effortless.building.operation.block.BlockOperation;
import dev.huskuraft.effortless.building.operation.block.BlockOperationResultType;
import dev.huskuraft.effortless.building.operation.block.BlockStateUpdateOperationResult;
import dev.huskuraft.effortless.building.operation.block.Extras;
import dev.huskuraft.effortless.building.operation.empty.EmptyOperation;
import dev.huskuraft.effortless.building.pattern.MirrorContext;
import dev.huskuraft.effortless.building.pattern.MoveContext;
import dev.huskuraft.effortless.building.pattern.RefactorContext;
import dev.huskuraft.effortless.building.pattern.RotateContext;
import dev.huskuraft.effortless.building.session.Session;

public class BlockStateUpdateOperation
extends BlockOperation {
    public BlockStateUpdateOperation(Session session, Context context, Storage storage, BlockInteraction interaction, BlockState blockState, RecordTag blockTag, Extras extras) {
        super(session, context, storage, interaction, blockState, blockTag, extras);
    }

    protected boolean destroyBlockInternal() {
        BlockState blockState = this.getBlockStateInWorld();
        BlockEntity blockEntity = this.getWorld().getBlockEntity(this.getBlockPosition());
        ItemStack itemInHand = this.getPlayer().getItemStack(InteractionHand.MAIN);
        ItemStack itemInHandCopy = itemInHand.copy();
        blockState.getBlock().destroyStart(this.getWorld(), this.getPlayer(), this.getBlockPosition(), blockState, blockEntity, itemInHandCopy);
        boolean removed = this.getWorld().removeBlock(this.getBlockPosition(), false);
        if (removed) {
            this.getWorld().getBlockState(this.getBlockPosition()).getBlock().destroy(this.getWorld(), this.getPlayer(), this.getBlockPosition(), blockState);
        }
        if (this.getPlayer().getGameMode().isCreative()) {
            return true;
        }
        boolean properTool = !blockState.requiresCorrectToolForDrops() || itemInHand.getItem().isCorrectToolForDropsNoThrows(blockState);
        itemInHand.mineBlock(this.getWorld(), this.getPlayer(), this.getBlockPosition(), blockState);
        if (removed && properTool) {
            blockState.getBlock().destroyEnd(this.getWorld(), this.getPlayer(), this.getBlockPosition(), blockState, blockEntity, itemInHandCopy);
        }
        return true;
    }

    protected BlockOperationResultType updateBlock() {
        PlatformReference miningTool;
        if (!this.context.extras().dimensionId().equals(this.getWorld().getDimensionId().location())) {
            return BlockOperationResultType.FAIL_WORLD_INCORRECT_DIM;
        }
        if (this.getPlayer().getGameMode().isSpectator()) {
            return BlockOperationResultType.FAIL_PLAYER_GAME_MODE;
        }
        if (this.getBlockStateInWorld() == null || this.getBlockState() == null) {
            return BlockOperationResultType.FAIL_BLOCK_STATE_NULL;
        }
        if (this.getBlockStateInWorld().isAir() && this.getBlockState().isAir()) {
            return BlockOperationResultType.FAIL_BLOCK_STATE_AIR;
        }
        if (!this.allowInteraction()) {
            if (!this.getBlockStateInWorld().isAir()) {
                return BlockOperationResultType.FAIL_BREAK_NO_PERMISSION;
            }
            if (!this.getBlockState().isAir()) {
                return BlockOperationResultType.FAIL_PLACE_NO_PERMISSION;
            }
        }
        if (!this.isInBorderBound()) {
            return BlockOperationResultType.FAIL_WORLD_BORDER;
        }
        if (!this.isInHeightBound()) {
            return BlockOperationResultType.FAIL_WORLD_HEIGHT;
        }
        if (!this.getBlockStateInWorld().isAir()) {
            if (!this.context.configs().constraintConfig().allowBreakBlocks().booleanValue()) {
                return BlockOperationResultType.FAIL_BREAK_NO_PERMISSION;
            }
            if (!(this.context.configs().constraintConfig().whitelistedItems().isEmpty() || this.context.configs().constraintConfig().whitelistedItems().contains(this.getBlockStateInWorld().getItem().getId()) || this.getBlockStateInWorld().isAir())) {
                return BlockOperationResultType.FAIL_BREAK_BLACKLISTED;
            }
            if (!this.context.configs().constraintConfig().blacklistedItems().isEmpty() && this.context.configs().constraintConfig().blacklistedItems().contains(this.getBlockStateInWorld().getItem().getId()) && !this.getBlockStateInWorld().isAir()) {
                return BlockOperationResultType.FAIL_BREAK_BLACKLISTED;
            }
        }
        if (!this.getBlockState().isAir()) {
            if (!this.context.configs().constraintConfig().allowPlaceBlocks().booleanValue()) {
                return BlockOperationResultType.FAIL_PLACE_NO_PERMISSION;
            }
            if (!this.context.configs().constraintConfig().whitelistedItems().isEmpty() && !this.context.configs().constraintConfig().whitelistedItems().contains(this.getBlockState().getItem().getId())) {
                return BlockOperationResultType.FAIL_PLACE_BLACKLISTED;
            }
            if (!this.context.configs().constraintConfig().blacklistedItems().isEmpty() && this.context.configs().constraintConfig().blacklistedItems().contains(this.getBlockState().getItem().getId())) {
                return BlockOperationResultType.FAIL_PLACE_BLACKLISTED;
            }
        }
        if (!this.getBlockState().isAir()) {
            switch (this.context.replaceStrategy()) {
                case DISABLED: {
                    if (this.getBlockStateInWorld().canBeReplaced(this.getPlayer(), this.getInteraction())) break;
                    return BlockOperationResultType.FAIL_BREAK_REPLACE_RULE;
                }
                case BLOCKS_AND_AIR: {
                    break;
                }
                case BLOCKS_ONLY: {
                    if (this.getBlockStateInWorld().getItem() instanceof BlockItem && !this.getBlockStateInWorld().isAir()) break;
                    return BlockOperationResultType.FAIL_BREAK_REPLACE_RULE;
                }
                case OFFHAND_ONLY: {
                    if (!(this.context.extras().inventorySnapshot().getOffhandItems().isEmpty() ? this.getBlockStateInWorld().isAir() : !this.context.extras().inventorySnapshot().getOffhandItems().stream().map(ItemStack::getItem).toList().contains(this.getBlockStateInWorld().getItem()))) break;
                    return BlockOperationResultType.FAIL_BREAK_REPLACE_RULE;
                }
            }
        }
        if (!this.getBlockStateInWorld().isAir()) {
            if (!this.getPlayer().getGameMode().isCreative() && this.getWorld().getBlockState(this.getBlockPosition()).hasTagFeatureCannotReplace()) {
                return BlockOperationResultType.FAIL_BREAK_REPLACE_FLAGS;
            }
            int durabilityReserved = this.getContext().getReservedToolDurability();
            boolean requireCorrectTool = !this.getPlayer().getGameMode().isCreative() && this.context.useProperTool() && !this.getBlockStateInWorld().isReplaceable();
            miningTool = null;
            if (requireCorrectTool) {
                miningTool = this.getStorage().contents().stream().filter(stack -> stack.getItem().isCorrectToolForDropsNoThrows(this.getBlockStateInWorld())).filter(tool -> !tool.isDamageableItem() || tool.getDurabilityLeft() > durabilityReserved).findFirst().orElse(null);
                if (miningTool == null) {
                    miningTool = this.getStorage().contents().stream().filter(tool -> tool.getItem() instanceof DiggerItem).filter(tool -> !tool.isDamageableItem() || tool.getDurabilityLeft() > durabilityReserved).findFirst().orElse(null);
                }
                if (miningTool == null) {
                    return BlockOperationResultType.FAIL_BREAK_TOOL_INSUFFICIENT;
                }
            }
            if ((this.context.isPreviewType() || this.context.isBuildClientType()) && requireCorrectTool) {
                miningTool.damage(1);
            }
            if (this.context.isBuildType()) {
                ItemStack itemStackBeforeBreak = this.getPlayer().getItemStack(InteractionHand.MAIN);
                if (requireCorrectTool) {
                    this.getPlayer().setItemStack(InteractionHand.MAIN, (ItemStack)miningTool);
                }
                boolean destroyed = this.destroyBlockInternal();
                if (requireCorrectTool) {
                    this.getPlayer().setItemStack(InteractionHand.MAIN, itemStackBeforeBreak);
                }
                if (!destroyed) {
                    return BlockOperationResultType.FAIL_UNKNOWN;
                }
            }
        }
        if (!this.getBlockState().isAir()) {
            ItemStack itemStack = this.storage.search(this.getBlockState().getItem()).orElse(null);
            if (itemStack == null || itemStack.isEmpty()) {
                return BlockOperationResultType.FAIL_PLACE_ITEM_INSUFFICIENT;
            }
            miningTool = itemStack.getItem();
            if (!(miningTool instanceof BlockItem)) {
                return BlockOperationResultType.FAIL_PLACE_ITEM_NOT_BLOCK;
            }
            BlockItem blockItem = (BlockItem)miningTool;
            int estimation = this.getItemCountEstimation();
            if (!this.getPlayer().getGameMode().isCreative() && this.storage.getCount(itemStack.getItem()) < estimation) {
                return BlockOperationResultType.FAIL_PLACE_ITEM_INSUFFICIENT;
            }
            if (this.context.isPreviewType() || this.context.isBuildClientType()) {
                this.storage.consume(itemStack.getItem(), estimation);
                return BlockOperationResultType.CONSUME;
            }
            if (this.context.isBuildType()) {
                ItemStack originalItemStack = this.getPlayer().getItemStack(this.getHand());
                this.getPlayer().setItemStack(this.getHand(), itemStack);
                boolean placed = false;
                if (this.context.useLegacyBlockPlace()) {
                    placed = blockItem.placeOnBlock(this.getPlayer(), this.getInteraction()).consumesAction();
                } else {
                    placed = blockItem.setBlockOnly(this.getWorld(), this.getPlayer(), this.getInteraction(), this.getBlockState());
                    if (placed) {
                        blockItem.updateBlockEntityTag(this.getWorld(), this.getBlockPosition(), this.getBlockState(), itemStack);
                        blockItem.getBlock().place(this.getWorld(), this.getPlayer(), this.getBlockPosition(), this.getBlockState(), itemStack);
                    }
                    if (placed && !this.getPlayer().getGameMode().isCreative()) {
                        this.storage.consume(blockItem, this.getItemCountEstimation());
                    }
                }
                this.getPlayer().setItemStack(this.getHand(), originalItemStack);
                if (!placed) {
                    return BlockOperationResultType.FAIL_UNKNOWN;
                }
                this.getPlayer().awardStat(StatTypes.ITEM_USED.get(itemStack.getItem()));
                if (this.context.fillContainers()) {
                    if (this.getEntityTag() != null && this.getBlockEntityInWorld() != null) {
                        if (this.getPlayer().getGameMode().isCreative()) {
                            this.getBlockEntityInWorld().setTag(this.getEntityTag());
                            return BlockOperationResultType.SUCCESS;
                        }
                        return BlockOperationResultType.SUCCESS_PARTIAL;
                    }
                    return BlockOperationResultType.SUCCESS_PARTIAL;
                }
                return BlockOperationResultType.SUCCESS;
            }
        }
        return BlockOperationResultType.CONSUME;
    }

    @Override
    public BlockStateUpdateOperationResult commit() {
        Extras entityExtrasBeforeOp = Extras.get(this.getPlayer());
        BlockState blockStateBeforeOp = this.getBlockStateInWorld();
        RecordTag entityTagBeforeOp = this.getEntityTagInWorld();
        Extras.set(this.getPlayer(), this.getExtras());
        BlockOperationResultType result = this.updateBlock();
        Extras.set(this.getPlayer(), entityExtrasBeforeOp);
        RecordTag entityTagAfterOp = this.getEntityTagInWorld();
        BlockState blockStateAfterOp = this.getBlockStateInWorld();
        if (this.getContext().isBuildClientType() && this.getBlockPosition().toVector3d().distance(this.getPlayer().getEyePosition()) <= 32.0) {
            if (result.success()) {
                this.getPlayer().getClient().getParticleEngine().destroy(this.getBlockPosition(), blockStateBeforeOp);
            }
            this.getPlayer().getClient().getParticleEngine().crack(this.getBlockPosition(), this.getInteraction().getDirection());
        }
        return new BlockStateUpdateOperationResult(this, result, blockStateBeforeOp, blockStateAfterOp, entityTagBeforeOp, entityTagAfterOp);
    }

    @Override
    public Operation move(MoveContext moveContext) {
        return new BlockStateUpdateOperation(this.session, this.context, this.storage, moveContext.move(this.interaction), this.blockState, this.entityTag, this.extras);
    }

    @Override
    public Operation mirror(MirrorContext mirrorContext) {
        if (!mirrorContext.isInBounds(this.getBlockPosition().getCenter())) {
            return new EmptyOperation(this.context);
        }
        return new BlockStateUpdateOperation(this.session, this.context, this.storage, mirrorContext.mirror(this.interaction), mirrorContext.mirror(this.blockState), this.entityTag, mirrorContext.mirror(this.extras));
    }

    @Override
    public Operation rotate(RotateContext rotateContext) {
        if (!rotateContext.isInBounds(this.getBlockPosition().getCenter())) {
            return new EmptyOperation(this.context);
        }
        return new BlockStateUpdateOperation(this.session, this.context, this.storage, rotateContext.rotate(this.interaction), rotateContext.rotate(this.blockState), this.entityTag, rotateContext.rotate(this.extras));
    }

    @Override
    public Operation refactor(RefactorContext refactorContext) {
        return new BlockStateUpdateOperation(this.session, this.context, this.storage, this.interaction, refactorContext.refactor(this.getPlayer(), this.getInteraction()), this.entityTag, this.extras);
    }

    @Override
    public BlockOperation.Type getType() {
        return BlockOperation.Type.UPDATE;
    }

    public int getItemCountEstimation() {
        return this.getBlockState().getRequiredItemCount();
    }
}

