/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.pattern.randomize;

import dev.huskuraft.effortless.api.core.Item;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.pattern.Transformer;
import dev.huskuraft.effortless.building.pattern.randomize.Chance;
import dev.huskuraft.effortless.building.pattern.randomize.Producer;
import java.util.Collection;
import java.util.UUID;

public interface Randomizer<T>
extends Transformer {
    public static Category extract(Object object) {
        if (object instanceof Item) {
            return Category.ITEM;
        }
        throw new IllegalArgumentException("Invalid object: " + String.valueOf(object));
    }

    public Order getOrder();

    public Target getTarget();

    public Category getCategory();

    public Collection<Chance<T>> getChances();

    public Producer<T> asProducer(long var1, boolean var3);

    @Override
    default public float volumeMultiplier() {
        return 1.0f;
    }

    @Override
    public Randomizer<T> withId(UUID var1);

    @Override
    public Randomizer<T> withName(Text var1);

    public static enum Category {
        ITEM("item", ItemStack.class);

        private final String name;
        private final Class<?> clazz;

        private Category(String name, Class<?> clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        public Text getDisplayName() {
            return Text.translate("effortless.transformer.randomizer.category.%s".formatted(this.name));
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Target {
        SINGLE("single"),
        GROUP("group");

        private final String name;

        private Target(String name) {
            this.name = name;
        }

        public Text getDisplayName() {
            return Text.translate("effortless.transformer.randomizer.target.%s".formatted(this.name));
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Order {
        SEQUENCE("sequence"),
        RANDOM("random");

        private final String name;

        private Order(String name) {
            this.name = name;
        }

        public Text getDisplayName() {
            return Text.translate("effortless.transformer.randomizer.order.%s".formatted(this.name));
        }

        public String getName() {
            return this.name;
        }
    }
}

