/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.renderer.outliner;

import dev.huskuraft.effortless.api.math.BoundingBox3d;
import dev.huskuraft.effortless.api.math.MathUtils;
import dev.huskuraft.effortless.api.renderer.Renderer;
import dev.huskuraft.effortless.renderer.outliner.BlockBoundingBoxOutline;

public class ChasingBlockBoundingBoxOutline
extends BlockBoundingBoxOutline {
    BoundingBox3d targetBB;
    BoundingBox3d prevBB;

    public ChasingBlockBoundingBoxOutline(BoundingBox3d bb) {
        super(bb);
        this.prevBB = bb.inflate(0.0);
        this.targetBB = bb.inflate(0.0);
    }

    private static BoundingBox3d interpolateBBs(BoundingBox3d current, BoundingBox3d target, float deltaTick) {
        return BoundingBox3d.of(MathUtils.lerp((double)deltaTick, current.minX(), target.minX()), MathUtils.lerp((double)deltaTick, current.minY(), target.minY()), MathUtils.lerp((double)deltaTick, current.minZ(), target.minZ()), MathUtils.lerp((double)deltaTick, current.maxX(), target.maxX()), MathUtils.lerp((double)deltaTick, current.maxY(), target.maxY()), MathUtils.lerp((double)deltaTick, current.maxZ(), target.maxZ()));
    }

    public void target(BoundingBox3d target) {
        this.targetBB = target;
    }

    @Override
    public void tick() {
        this.prevBB = this.bb;
        this.setBounds(ChasingBlockBoundingBoxOutline.interpolateBBs(this.bb, this.targetBB, 0.5f));
    }

    @Override
    public void render(Renderer renderer, float deltaTick) {
        this.renderBB(renderer, ChasingBlockBoundingBoxOutline.interpolateBBs(this.prevBB, this.bb, deltaTick));
    }
}

