/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.renderer.outliner;

import dev.huskuraft.effortless.api.math.MathUtils;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.renderer.Renderer;
import dev.huskuraft.effortless.renderer.outliner.Outline;

public class LineOutline
extends Outline {
    protected Vector3d start = Vector3d.ZERO;
    protected Vector3d end = Vector3d.ZERO;

    public LineOutline set(Vector3d start, Vector3d end) {
        this.start = start;
        this.end = end;
        return this;
    }

    @Override
    public void render(Renderer renderer, float deltaTick) {
        this.renderCuboidLine(renderer, this.start, this.end);
    }

    public static class EndChasingLineOutline
    extends LineOutline {
        private final boolean lockStart;
        float prevProgress = 0.0f;
        float progress = 0.0f;

        public EndChasingLineOutline(boolean lockStart) {
            this.lockStart = lockStart;
        }

        @Override
        public void tick() {
        }

        public EndChasingLineOutline setProgress(float progress) {
            this.prevProgress = this.progress;
            this.progress = progress;
            return this;
        }

        @Override
        public LineOutline set(Vector3d start, Vector3d end) {
            if (!end.equals(this.end)) {
                super.set(start, end);
            }
            return this;
        }

        @Override
        public void render(Renderer renderer, float deltaTick) {
            float distanceToTarget = MathUtils.lerp(deltaTick, this.prevProgress, this.progress);
            if (!this.lockStart) {
                distanceToTarget = 1.0f - distanceToTarget;
            }
            Vector3d start = this.lockStart ? this.end : this.start;
            Vector3d end = this.lockStart ? this.start : this.end;
            start = end.add(this.start.sub(end).mul(distanceToTarget));
            this.renderCuboidLine(renderer, start, end);
        }
    }
}

