/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.pattern;

import dev.huskuraft.effortless.api.gui.container.EditableEntryList;
import dev.huskuraft.effortless.api.gui.slot.SlotContainer;
import dev.huskuraft.effortless.api.gui.slot.SlotData;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.pattern.Pattern;
import dev.huskuraft.effortless.screen.pattern.RadialTextIcon;
import dev.huskuraft.effortless.screen.transformer.TransformerList;
import java.util.stream.Collectors;

public final class PatternList
extends EditableEntryList<Pattern> {
    public PatternList(Entrance entrance, int x, int y, int width, int height) {
        super(entrance, x, y, width, height);
    }

    protected Entry createHolder(Pattern item) {
        return new Entry((Entrance)this.getEntrance(), item);
    }

    public static class Entry
    extends EditableEntryList.Entry<Pattern> {
        private RadialTextIcon radialTextIcon;
        private TextWidget nameTextWidget;
        private SlotContainer slotContainer;

        protected Entry(Entrance entrance, Pattern pattern) {
            super(entrance, pattern);
        }

        @Override
        public void onCreate() {
            this.radialTextIcon = this.addWidget(new RadialTextIcon(this.getEntrance(), this.getX(), this.getY(), 30, 30, 0, Text.empty()));
            this.nameTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getX() + 30 + 2, this.getY() + 2, this.getDisplayName((Pattern)this.getItem())));
            this.slotContainer = this.addWidget(new SlotContainer(this.getEntrance(), this.getX() + 30 + 2, this.getY() + 12, 0, 0));
        }

        @Override
        public void onPositionChange(int from, int to) {
            this.radialTextIcon.setIndex(to);
            this.radialTextIcon.setMessage(Text.text(String.valueOf(to + 1)));
        }

        @Override
        public void onReload() {
            this.nameTextWidget.setMessage(this.getDisplayName((Pattern)this.getItem()));
            this.slotContainer.setEntries(((Pattern)this.getItem()).transformers().stream().map(transformer -> new SlotData.TextSymbol(TransformerList.Entry.getSymbol(transformer), Text.empty())).collect(Collectors.toList()));
        }

        @Override
        public Text getNarration() {
            return Text.translate("narrator.select", Text.empty());
        }

        @Override
        public int getHeight() {
            return 34;
        }

        private Text getDisplayName(Pattern pattern) {
            return Text.translate("effortless.pattern.no_name").withStyle(ChatFormatting.GRAY);
        }
    }
}

