/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.network.serverbound;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.integration.jei.transfer.FermentingTransfer;
import umpaz.brewinandchewin.integration.jei.transfer.FermentingTransferServer;

public record JEITransferKegRecipeServerboundPacket(ResourceLocation recipeId, List<Pair<Integer, Integer>> resultSlots, List<Pair<Integer, Integer>> fluidSlots, List<Pair<Integer, Integer>> emptyingSlots, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.recipeId);
        JEITransferKegRecipeServerboundPacket.encodeIntPairs(buf, this.resultSlots);
        JEITransferKegRecipeServerboundPacket.encodeIntPairs(buf, this.fluidSlots);
        JEITransferKegRecipeServerboundPacket.encodeIntPairs(buf, this.emptyingSlots);
        JEITransferKegRecipeServerboundPacket.encodeSlots(buf, this.craftingSlots);
        JEITransferKegRecipeServerboundPacket.encodeSlots(buf, this.inventorySlots);
        buf.writeBoolean(this.maxTransfer);
    }

    private static void encodeIntPairs(FriendlyByteBuf buf, List<Pair<Integer, Integer>> slots) {
        buf.writeInt(slots.size());
        for (Pair<Integer, Integer> slot : slots) {
            buf.m_130130_(((Integer)slot.getFirst()).intValue());
            buf.writeInt(((Integer)slot.getSecond()).intValue());
        }
    }

    private static void encodeSlots(FriendlyByteBuf buf, List<Integer> slots) {
        buf.writeInt(slots.size());
        for (int slot : slots) {
            buf.m_130130_(slot);
        }
    }

    public static JEITransferKegRecipeServerboundPacket decode(FriendlyByteBuf buf) {
        return new JEITransferKegRecipeServerboundPacket(buf.m_130281_(), JEITransferKegRecipeServerboundPacket.decodeIntPairs(buf), JEITransferKegRecipeServerboundPacket.decodeIntPairs(buf), JEITransferKegRecipeServerboundPacket.decodeIntPairs(buf), JEITransferKegRecipeServerboundPacket.decodeSlots(buf), JEITransferKegRecipeServerboundPacket.decodeSlots(buf), buf.readBoolean());
    }

    private static List<Pair<Integer, Integer>> decodeIntPairs(FriendlyByteBuf buf) {
        int listSize = buf.readInt();
        ArrayList<Pair<Integer, Integer>> slots = new ArrayList<Pair<Integer, Integer>>(listSize);
        for (int i = 0; i < listSize; ++i) {
            int inventorySlotIndex = buf.m_130242_();
            int craftingSlotIndex = buf.readInt();
            slots.add((Pair<Integer, Integer>)Pair.of((Object)inventorySlotIndex, (Object)craftingSlotIndex));
        }
        return slots;
    }

    private static List<Integer> decodeSlots(FriendlyByteBuf buf) {
        int listSize = buf.readInt();
        ArrayList<Integer> slots = new ArrayList<Integer>(listSize);
        for (int i = 0; i < listSize; ++i) {
            int slotIndex = buf.m_130242_();
            slots.add(slotIndex);
        }
        return slots;
    }

    public static class Handler {
        public static void handle(JEITransferKegRecipeServerboundPacket packet, Supplier<NetworkEvent.Context> context) {
            if (context.get().getDirection() != NetworkDirection.PLAY_TO_SERVER) {
                return;
            }
            context.get().enqueueWork(() -> {
                Object patt3954$temp;
                ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
                if (sender == null) {
                    return;
                }
                Optional recipe = sender.m_20194_().m_129894_().m_44043_(packet.recipeId);
                if (recipe.isEmpty() || !((patt3954$temp = recipe.get()) instanceof KegFermentingRecipe)) {
                    return;
                }
                KegFermentingRecipe kegFermentingRecipe = (KegFermentingRecipe)patt3954$temp;
                FermentingTransferServer.setItems((Player)sender, kegFermentingRecipe, FermentingTransfer.TransferOperations.readFromIntegers(packet.resultSlots, packet.fluidSlots, packet.emptyingSlots, sender.f_36096_), packet.craftingSlots.stream().map(arg_0 -> ((AbstractContainerMenu)sender.f_36096_).m_38853_(arg_0)).toList(), packet.inventorySlots.stream().map(arg_0 -> ((AbstractContainerMenu)sender.f_36096_).m_38853_(arg_0)).toList(), packet.maxTransfer);
            });
            context.get().setPacketHandled(true);
        }
    }
}

