/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.totem;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlock;
import com.sammy.malum.common.item.curiosities.tools.TotemicStaffItem;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.visual_effects.TotemParticleEffects;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolActions;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class TotemPoleBlockEntity
extends LodestoneBlockEntity {
    public MalumSpiritType type;
    public TotemPoleState totemPoleState = TotemPoleState.INACTIVE;
    public TotemBaseBlockEntity totemBase;
    public int totemBaseYLevel;
    public int chargeProgress;
    public final boolean isSoulwood;
    public final Block logBlock;
    public final Direction direction;

    public TotemPoleBlockEntity(BlockEntityType<? extends TotemPoleBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.isSoulwood = ((TotemPoleBlock)state.m_60734_()).isSoulwood;
        this.logBlock = ((TotemPoleBlock)state.m_60734_()).logBlock.get();
        this.direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public TotemPoleBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends TotemPoleBlockEntity>)((BlockEntityType)BlockEntityRegistry.TOTEM_POLE.get()), pos, state);
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        boolean success = false;
        if (held.m_41720_() instanceof TotemicStaffItem && !this.totemPoleState.equals((Object)TotemPoleState.ACTIVE) && !this.totemPoleState.equals((Object)TotemPoleState.CHARGING)) {
            if (this.f_58857_.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            this.totemPoleState = this.totemPoleState.equals((Object)TotemPoleState.INACTIVE) ? TotemPoleState.VISUAL_ONLY : TotemPoleState.INACTIVE;
            success = true;
        } else if (held.canPerformAction(ToolActions.AXE_STRIP)) {
            if (this.f_58857_.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (this.type != null) {
                this.f_58857_.m_46597_(this.f_58858_, this.logBlock.m_49966_());
                success = true;
                this.onBreak(player);
            }
        }
        if (success) {
            ParticleEffectTypeRegistry.TOTEM_POLE_ACTIVATED.createPositionedEffect(this.f_58857_, new PositionEffectData(this.f_58858_));
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.TOTEM_ENGRAVE.get(), SoundSource.BLOCKS, 1.0f, Mth.m_216267_((RandomSource)this.f_58857_.f_46441_, (float)0.9f, (float)1.1f));
            if (this.isSoulwood) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.MAJOR_BLIGHT_MOTIF.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.f_58858_);
            return InteractionResult.SUCCESS;
        }
        return super.onUse(player, hand);
    }

    protected void m_183515_(CompoundTag compound) {
        if (this.type != null) {
            compound.m_128359_("type", this.type.identifier);
        }
        if (!this.totemPoleState.equals((Object)TotemPoleState.INACTIVE)) {
            compound.m_128405_("totemPoleState", this.totemPoleState.ordinal());
        }
        if (this.chargeProgress != 0) {
            compound.m_128405_("chargeProgress", this.chargeProgress);
        }
        if (this.totemBaseYLevel != 0) {
            compound.m_128405_("totemBaseYLevel", this.totemBaseYLevel);
        }
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("type")) {
            this.type = SpiritHarvestHandler.getSpiritType(compound.m_128461_("type"));
        }
        this.totemPoleState = compound.m_128441_("totemPoleState") ? TotemPoleState.values()[compound.m_128451_("totemPoleState")] : TotemPoleState.INACTIVE;
        this.chargeProgress = compound.m_128451_("chargeProgress");
        this.totemBaseYLevel = compound.m_128451_("totemBaseYLevel");
        super.m_142466_(compound);
    }

    public void init() {
        super.init();
        BlockEntity blockEntity = this.f_58857_.m_7702_(new BlockPos(this.m_58899_().m_123341_(), this.totemBaseYLevel, this.m_58899_().m_123343_()));
        if (blockEntity instanceof TotemBaseBlockEntity) {
            TotemBaseBlockEntity totemBaseBlockEntity;
            this.totemBase = totemBaseBlockEntity = (TotemBaseBlockEntity)blockEntity;
        }
    }

    public void tick() {
        super.tick();
        if (this.totemPoleState.equals((Object)TotemPoleState.INACTIVE)) {
            this.chargeProgress = this.chargeProgress > 0 ? this.chargeProgress - 1 : 0;
        } else {
            int cap = this.totemPoleState.equals((Object)TotemPoleState.CHARGING) ? 10 : 20;
            int n = this.chargeProgress = this.chargeProgress < cap ? this.chargeProgress + 1 : cap;
        }
        if (this.f_58857_.f_46443_ && this.type != null && this.totemPoleState.equals((Object)TotemPoleState.ACTIVE)) {
            TotemParticleEffects.activeTotemPoleParticles(this);
        }
    }

    public void setSpirit(MalumSpiritType type) {
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.TOTEM_ENGRAVE.get(), SoundSource.BLOCKS, 1.0f, Mth.m_216267_((RandomSource)this.f_58857_.f_46441_, (float)0.9f, (float)1.1f));
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, Mth.m_216267_((RandomSource)this.f_58857_.f_46441_, (float)0.9f, (float)1.1f));
        ParticleEffectTypeRegistry.TOTEM_POLE_ACTIVATED.createPositionedEffect(this.f_58857_, new PositionEffectData(this.f_58858_));
        this.type = type;
        this.chargeProgress = 10;
        BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public void riteStarting(TotemBaseBlockEntity totemBase, int height) {
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.TOTEM_CHARGE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.2f * (float)height);
        ParticleEffectTypeRegistry.TOTEM_POLE_ACTIVATED.createPositionedEffect(this.f_58857_, new PositionEffectData(this.f_58858_));
        this.totemBaseYLevel = this.f_58858_.m_123342_() - height;
        this.totemBase = totemBase;
        this.totemPoleState = TotemPoleState.CHARGING;
        BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public void setState(TotemPoleState state) {
        this.totemPoleState = state;
        BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public void onBreak(@Nullable Player player) {
        TotemBaseBlockEntity base;
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockPos basePos = new BlockPos(this.f_58858_.m_123341_(), this.totemBaseYLevel, this.f_58858_.m_123343_());
        BlockEntity blockEntity = this.f_58857_.m_7702_(basePos);
        if (blockEntity instanceof TotemBaseBlockEntity && (base = (TotemBaseBlockEntity)blockEntity).isActiveOrAssembling()) {
            base.onBreak(player);
        }
    }

    public static enum TotemPoleState {
        INACTIVE,
        VISUAL_ONLY,
        CHARGING,
        ACTIVE;

    }
}

