/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.enchantment.scythe;

import com.sammy.malum.common.item.ISpiritAffiliatedItem;
import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.core.helpers.ParticleHelper;
import com.sammy.malum.registry.common.DamageTypeRegistry;
import com.sammy.malum.registry.common.MobEffectRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.item.EnchantmentRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.ItemHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;

public class AscensionEnchantment
extends Enchantment {
    public AscensionEnchantment() {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentRegistry.SCYTHE_ONLY, new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND});
    }

    public int m_6586_() {
        return 3;
    }

    protected boolean m_5975_(Enchantment pOther) {
        return !pOther.equals(EnchantmentRegistry.REBOUND.get()) && super.m_5975_(pOther);
    }

    public static void triggerAscension(Level level, Player player, InteractionHand hand, ItemStack scythe) {
        int enchantmentLevel;
        boolean isEnhanced = !MalumScytheItem.canSweep((LivingEntity)player);
        player.m_183634_();
        if (level.m_5776_()) {
            Vec3 motion = player.m_20184_();
            player.m_20334_(motion.f_82479_, (double)(player.m_6118_() * 2.0f), motion.f_82481_);
            if (player.m_20142_()) {
                float f = player.m_146908_() * ((float)Math.PI / 180);
                float x = -Mth.m_14031_((float)f);
                float z = Mth.m_14089_((float)f);
                Vec3 newMotion = player.m_20184_();
                newMotion = isEnhanced ? newMotion.m_82492_((double)(x * 0.6f), 0.0, (double)(z * 0.6f)) : newMotion.m_82520_((double)(x * 0.75f), 0.0, (double)(z * 0.75f));
                player.m_20256_(newMotion);
            }
            player.f_19812_ = true;
            ForgeHooks.onLivingJump((LivingEntity)player);
        } else {
            Object object;
            float baseDamage = (float)player.m_21204_().m_22181_(Attributes.f_22281_);
            float magicDamage = (float)player.m_21204_().m_22181_((Attribute)LodestoneAttributeRegistry.MAGIC_DAMAGE.get());
            AABB aabb = player.m_20191_().m_82377_(4.0, 1.0, 4.0);
            SoundEvent sound = (SoundEvent)SoundRegistry.SCYTHE_SWEEP.get();
            ParticleHelper.SlashParticleEffectBuilder particleEffect = ParticleHelper.createSlashingEffect(ParticleEffectTypeRegistry.SCYTHE_ASCENSION_SPIN).mirrorRandomly(level.m_213780_());
            if (isEnhanced) {
                baseDamage *= 1.25f;
                magicDamage *= 1.25f;
                aabb = aabb.m_82383_(player.m_20154_().m_82490_(2.0)).m_82377_(-2.0, 1.0, -2.0);
                sound = (SoundEvent)SoundRegistry.SCYTHE_CUT.get();
                particleEffect = ParticleHelper.createSlashingEffect(ParticleEffectTypeRegistry.SCYTHE_ASCENSION_UPPERCUT).setVerticalSlashAngle().setMirrored(true);
            }
            if ((object = scythe.m_41720_()) instanceof ISpiritAffiliatedItem) {
                ISpiritAffiliatedItem spiritAffiliatedItem = (ISpiritAffiliatedItem)object;
                particleEffect.setSpiritType(spiritAffiliatedItem);
            }
            boolean dealtDamage = false;
            for (Entity target : level.m_6249_((Entity)player, aabb, t -> AscensionEnchantment.canHitEntity(player, t))) {
                DamageSource damageSource = DamageTypeHelper.create((Level)level, DamageTypeRegistry.SCYTHE_SWEEP, (Entity)player);
                target.f_19802_ = 0;
                boolean success = target.m_6469_(damageSource, baseDamage);
                if (!success || !(target instanceof LivingEntity)) continue;
                LivingEntity livingentity = (LivingEntity)target;
                ItemHelper.applyEnchantments((LivingEntity)player, (Entity)livingentity, (ItemStack)scythe);
                int i = scythe.getEnchantmentLevel(Enchantments.f_44981_);
                if (i > 0) {
                    livingentity.m_20254_(i * 4);
                }
                if (magicDamage > 0.0f && !livingentity.m_21224_()) {
                    livingentity.f_19802_ = 0;
                    livingentity.m_6469_(DamageTypeHelper.create((Level)level, DamageTypeRegistry.VOODOO, (Entity)player), magicDamage);
                }
                SoundHelper.playSound((Entity)player, (SoundEvent)sound, (float)2.0f, (float)RandomHelper.randomBetween((RandomSource)level.m_213780_(), (float)0.75f, (float)1.25f));
                dealtDamage = true;
            }
            if (dealtDamage) {
                player.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.ASCENSION.get(), 80, 0));
            }
            Vec3 slashPosition = player.m_20182_().m_82520_(0.0, (double)player.m_20206_() * 0.75, 0.0);
            Vec3 slashDirection = player.m_20154_().m_82542_(1.0, 0.0, 1.0);
            particleEffect.spawnSlashingParticle(level, slashPosition, slashDirection);
            for (int i = 0; i < 3; ++i) {
                SoundHelper.playSound((Entity)player, (SoundEvent)sound, (float)1.0f, (float)RandomHelper.randomBetween((RandomSource)level.m_213780_(), (float)1.25f, (float)1.75f));
            }
            SoundHelper.playSound((Entity)player, (SoundEvent)((SoundEvent)SoundRegistry.SCYTHE_ASCENSION.get()), (float)2.0f, (float)RandomHelper.randomBetween((RandomSource)level.m_213780_(), (float)1.25f, (float)1.5f));
        }
        if (!player.m_7500_() && (enchantmentLevel = scythe.getEnchantmentLevel((Enchantment)EnchantmentRegistry.ASCENSION.get())) < 6) {
            player.m_36335_().m_41524_(scythe.m_41720_(), 150 - 25 * (enchantmentLevel - 1));
        }
        player.m_21011_(hand, false);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)scythe.m_41720_()));
    }

    protected static boolean canHitEntity(Player attacker, Entity pTarget) {
        if (!pTarget.m_271807_()) {
            return false;
        }
        return pTarget != attacker && !attacker.m_20365_(pTarget);
    }
}

