/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.spiritrite.TotemicRiteEffect;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class TotemicRiteType {
    public final List<MalumSpiritType> spirits;
    public final String identifier;
    public final TotemicRiteEffect effect;
    public final TotemicRiteEffect corruptedEffect;

    public TotemicRiteType(String identifier, MalumSpiritType ... spirits) {
        this.identifier = identifier;
        this.spirits = new ArrayList<MalumSpiritType>(Arrays.asList(spirits));
        this.effect = this.getNaturalRiteEffect();
        this.corruptedEffect = this.getCorruptedEffect();
    }

    public List<Component> makeDetailedDescriptor(boolean corrupted) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        UnaryOperator spiritStyleModifier = this.getIdentifyingSpirit().getItemRarity().getStyleModifier();
        TotemicRiteEffect riteEffect = this.getRiteEffect(corrupted);
        TotemicRiteEffect.MalumRiteEffectCategory riteCategory = riteEffect.category;
        tooltip.add((Component)Component.m_237115_((String)this.translationIdentifier(corrupted)).m_130938_(spiritStyleModifier));
        tooltip.add(this.makeDescriptorComponent("malum.gui.rite.type", riteCategory.getTranslationKey()));
        tooltip.add(this.makeDescriptorComponent("malum.gui.rite.medium", "malum.gui.rite.medium." + (corrupted ? "soulwood" : "runewood")));
        if (!riteCategory.equals((Object)TotemicRiteEffect.MalumRiteEffectCategory.ONE_TIME_EFFECT)) {
            tooltip.add(this.makeDescriptorComponent("malum.gui.rite.coverage", riteEffect.getRiteCoverageDescriptor()));
        }
        tooltip.add(this.makeDescriptorComponent("malum.gui.rite.effect", "malum.gui.book.entry.page.text." + (corrupted ? "corrupt_" : "") + this.identifier + ".hover"));
        return tooltip;
    }

    public final Component makeDescriptorComponent(String translationKey1, String translationKey2) {
        return Component.m_237115_((String)translationKey1).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237115_((String)translationKey2).m_130940_(ChatFormatting.YELLOW));
    }

    public String translationIdentifier(boolean corrupt) {
        return "malum.gui.rite." + (corrupt ? "corrupted_" : "") + this.identifier;
    }

    public ResourceLocation getIcon() {
        return MalumMod.malumPath("textures/vfx/rite/" + this.identifier.replace("greater_", "").replace("_rite", "") + ".png");
    }

    public MalumSpiritType getIdentifyingSpirit() {
        return this.spirits.get(this.spirits.size() - 1);
    }

    protected abstract TotemicRiteEffect getNaturalRiteEffect();

    protected abstract TotemicRiteEffect getCorruptedEffect();

    public final TotemicRiteEffect getRiteEffect(boolean corrupted) {
        return corrupted ? this.corruptedEffect : this.effect;
    }

    public void executeRite(TotemBaseBlockEntity totemBase) {
        this.getRiteEffect(totemBase.isSoulwood).doRiteEffect(totemBase);
    }
}

