/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.registry.common.item;

import com.sammy.malum.common.enchantment.HauntedEnchantment;
import com.sammy.malum.common.enchantment.SpiritPlunderEnchantment;
import com.sammy.malum.common.enchantment.scythe.AnimatedEnchantment;
import com.sammy.malum.common.enchantment.scythe.AscensionEnchantment;
import com.sammy.malum.common.enchantment.scythe.ReboundEnchantment;
import com.sammy.malum.common.enchantment.staff.ReplenishingEnchantment;
import com.sammy.malum.compability.irons_spellbooks.IronsSpellsCompat;
import com.sammy.malum.registry.common.item.ItemTagRegistry;
import java.util.function.Predicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class EnchantmentRegistry {
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"malum");
    public static final EnchantmentCategory SCYTHE_ONLY = EnchantmentRegistry.create("scythe_only", i -> i.m_7968_().m_204117_(ItemTagRegistry.SCYTHE));
    public static final EnchantmentCategory STAFF_ONLY = EnchantmentRegistry.create("staff_only", i -> i.m_7968_().m_204117_(ItemTagRegistry.STAFF) || IronsSpellsCompat.isStaff(i.m_7968_()));
    public static final EnchantmentCategory SOUL_SHATTER_CAPABLE_WEAPON = EnchantmentRegistry.create("soul_hunter_weapon", i -> i.m_7968_().m_204117_(ItemTagRegistry.SOUL_HUNTER_WEAPON));
    public static final EnchantmentCategory MAGIC_CAPABLE_WEAPON = EnchantmentRegistry.create("magic_capable_weapon", i -> i.m_7968_().m_204117_(ItemTagRegistry.MAGIC_CAPABLE_WEAPON));
    public static final RegistryObject<Enchantment> ANIMATED = ENCHANTMENTS.register("animated", AnimatedEnchantment::new);
    public static final RegistryObject<Enchantment> REBOUND = ENCHANTMENTS.register("rebound", ReboundEnchantment::new);
    public static final RegistryObject<Enchantment> ASCENSION = ENCHANTMENTS.register("ascension", AscensionEnchantment::new);
    public static final RegistryObject<Enchantment> REPLENISHING = ENCHANTMENTS.register("replenishing", ReplenishingEnchantment::new);
    public static final RegistryObject<Enchantment> HAUNTED = ENCHANTMENTS.register("haunted", HauntedEnchantment::new);
    public static final RegistryObject<Enchantment> SPIRIT_PLUNDER = ENCHANTMENTS.register("spirit_plunder", SpiritPlunderEnchantment::new);

    public static EnchantmentCategory create(String name, Predicate<Item> predicate) {
        return EnchantmentCategory.create((String)("malum:" + name), predicate);
    }
}

