/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.staff;

import com.sammy.malum.common.item.curiosities.weapons.staff.ErosionScepterItem;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.data.NBTEffectData;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.SparkBehaviorComponent;

public class DrainingBoltImpactParticleEffect
extends ParticleEffectType {
    public DrainingBoltImpactParticleEffect(String id) {
        super(id);
    }

    public static NBTEffectData createData(Vec3 direction) {
        CompoundTag tag = new CompoundTag();
        CompoundTag directionTag = new CompoundTag();
        directionTag.m_128347_("x", direction.f_82479_);
        directionTag.m_128347_("y", direction.f_82480_);
        directionTag.m_128347_("z", direction.f_82481_);
        tag.m_128365_("direction", (Tag)directionTag);
        return new NBTEffectData(tag);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Supplier<ParticleEffectType.ParticleEffectActor> get() {
        return () -> (level, random, positionData, colorData, nbtData) -> {
            if (!nbtData.compoundTag.m_128441_("direction")) {
                return;
            }
            CompoundTag directionData = nbtData.compoundTag.m_128469_("direction");
            double dirX = directionData.m_128459_("x");
            double dirY = directionData.m_128459_("y");
            double dirZ = directionData.m_128459_("z");
            Vec3 projectileDirection = new Vec3(dirX, dirY, dirZ);
            float yRot = (float)(Mth.m_14136_((double)projectileDirection.f_82479_, (double)projectileDirection.f_82481_) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 up = left.m_82537_(projectileDirection);
            double posX = positionData.posX;
            double posY = positionData.posY;
            double posZ = positionData.posZ;
            Vec3 pos = new Vec3(posX, posY, posZ);
            for (int i = 0; i < 16; ++i) {
                float spread = RandomHelper.randomBetween((RandomSource)random, (float)0.1f, (float)0.5f);
                float speed = RandomHelper.randomBetween((RandomSource)random, (float)0.3f, (float)0.4f);
                float distance = RandomHelper.randomBetween((RandomSource)random, (float)3.0f, (float)6.0f);
                float angle = (float)i / 16.0f * (float)Math.PI * 2.0f;
                Vec3 direction = projectileDirection.m_82549_(left.m_82490_(Math.sin(angle) * (double)spread)).m_82549_(up.m_82490_(Math.cos(angle) * (double)spread)).m_82541_().m_82490_((double)speed);
                Vec3 spawnPosition = pos.m_82549_(direction.m_82490_((double)distance));
                direction = direction.m_82548_();
                float lifetimeMultiplier = 0.7f;
                ColorParticleData malignantColorData = ErosionScepterItem.MALIGNANT_COLOR_DATA.copy().build();
                if (random.m_188501_() < 0.8f) {
                    ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spawnPosition, malignantColorData);
                    lightSpecs.getBuilder().disableNoClip().multiplyLifetime(lifetimeMultiplier).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).enableForcedSpawn().modifyColorData(d -> d.multiplyCoefficient(1.25f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.75f)).setMotion(direction);
                    lightSpecs.getBloomBuilder().disableNoClip().multiplyLifetime(lifetimeMultiplier).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).modifyColorData(d -> d.multiplyCoefficient(1.25f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.75f)).setMotion(direction);
                    lightSpecs.spawnParticles();
                }
                if (!(random.m_188501_() < 0.8f)) continue;
                ParticleEffectSpawner sparks = SparkParticleEffects.spiritMotionSparks(level, spawnPosition, malignantColorData);
                sparks.getBuilder().disableNoClip().multiplyLifetime(lifetimeMultiplier).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).enableForcedSpawn().modifyColorData(d -> d.multiplyCoefficient(1.25f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.75f)).modifyOptionalData(b -> b.getBehaviorData(SparkBehaviorComponent.class, SparkBehaviorComponent::getLengthData), d -> d.multiplyValue(3.0f)).setMotion(direction.m_82490_(1.5));
                sparks.getBloomBuilder().disableNoClip().multiplyLifetime(lifetimeMultiplier).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).modifyColorData(d -> d.multiplyCoefficient(1.25f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.75f)).setMotion(direction.m_82490_(1.5));
                sparks.spawnParticles();
            }
        };
    }
}

