/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.rechiseledchipped.mixin.rechiseled;

import com.supermartijn642.core.gui.widget.BaseContainerWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.TextFieldWidget;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.screen.BaseChiselingContainer;
import com.supermartijn642.rechiseled.screen.BaseChiselingContainerScreen;
import com.supermartijn642.rechiseled.screen.ChiselAllWidget;
import com.supermartijn642.rechiseled.screen.ConnectingToggleWidget;
import com.supermartijn642.rechiseled.screen.EntryButtonWidget;
import com.supermartijn642.rechiseled.screen.EntryPreviewWidget;
import com.supermartijn642.rechiseled.screen.PreviewModeButtonWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import xyz.iwolfking.rechiseledchipped.gui.ScrollWidget;

@Mixin(value={BaseChiselingContainerScreen.class}, remap=false)
public abstract class MixinBaseChiselingContainerScreen<T extends BaseChiselingContainer>
extends BaseContainerWidget<T> {
    @Shadow
    public static int previewMode;
    @Shadow
    private ChiselAllWidget chiselAllWidget;
    private ScrollWidget scrollWidget;
    private TextFieldWidget searchBox;
    private int numColumns = 4;
    private int numRows = 5;
    private int numScrolls;
    private int currentScroll = 0;
    private ChiselingRecipe previousRecipe;
    private List<ChiselingEntry> filteredEntries = new ArrayList<ChiselingEntry>();

    public MixinBaseChiselingContainerScreen(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Overwrite
    protected void addWidgets() {
        this.searchBox = new TextFieldWidget(8, 2, 100, 12, "", 64, this::rechiseledchipped$onSearchChanged);
        this.addWidget((Widget)this.searchBox);
        this.scrollWidget = new ScrollWidget(96, 17, 14, 110, this::scrollChanged);
        this.addWidget((Widget)this.scrollWidget);
        this.previousRecipe = ((BaseChiselingContainer)this.container).currentRecipe;
        this.rechiseledchipped$updateFilteredEntries();
        this.rechiseledchipped$updateScrollData();
        int offsetX = 9;
        int offsetY = 17;
        int entryWidth = 20;
        int entryHeight = 22;
        for (int row = 0; row < this.numRows; ++row) {
            for (int column = 0; column < this.numColumns; ++column) {
                int index = row * this.numColumns + column;
                int x = offsetX + entryWidth * column;
                int y = offsetY + entryHeight * row;
                EntryButtonWidget entryWidget = new EntryButtonWidget(x, y, entryWidth, entryHeight, () -> this.rechiseledchipped$getFilteredEntry(this.numColumns * this.currentScroll + index), () -> ((BaseChiselingContainer)this.container).currentEntry, () -> this.rechiseledchipped$selectFilteredEntry(this.numColumns * this.currentScroll + index), () -> ((BaseChiselingContainer)this.container).connecting);
                this.addWidget((Widget)entryWidget);
            }
        }
        this.addWidget((Widget)new EntryPreviewWidget(117, 17, 68, 69, () -> {
            ChiselingEntry entry = ((BaseChiselingContainer)this.container).currentEntry;
            return entry == null ? null : (((BaseChiselingContainer)this.container).connecting && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem());
        }, () -> previewMode));
        Supplier<Boolean> enablePreviewButtons = () -> {
            ChiselingEntry entry = ((BaseChiselingContainer)this.container).currentEntry;
            if (entry == null) {
                return false;
            }
            Item currentItem = ((BaseChiselingContainer)this.container).connecting && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem();
            return currentItem instanceof BlockItem;
        };
        this.addWidget((Widget)new PreviewModeButtonWidget(193, 18, 19, 21, 2, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = 2;
        }));
        this.addWidget((Widget)new PreviewModeButtonWidget(193, 41, 19, 21, 1, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = 1;
        }));
        this.addWidget((Widget)new PreviewModeButtonWidget(193, 64, 19, 21, 0, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = 0;
        }));
        this.addWidget((Widget)new ConnectingToggleWidget(193, 99, 19, 21, () -> ((BaseChiselingContainer)this.container).connecting, () -> ((BaseChiselingContainer)this.container).currentEntry, this::toggleConnecting));
        this.chiselAllWidget = (ChiselAllWidget)this.addWidget((Widget)new ChiselAllWidget(127, 99, 19, 21, () -> ((BaseChiselingContainer)this.container).currentEntry, this::chiselAll));
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        if (this.previousRecipe != ((BaseChiselingContainer)this.container).currentRecipe) {
            this.rechiseledchipped$updateFilteredEntries();
            this.rechiseledchipped$updateScrollData();
            this.previousRecipe = ((BaseChiselingContainer)this.container).currentRecipe;
        }
        super.render(context, mouseX, mouseY);
    }

    @Unique
    private void rechiseledchipped$onSearchChanged(String text) {
        this.rechiseledchipped$updateFilteredEntries();
        this.rechiseledchipped$updateScrollData();
    }

    @Unique
    private void rechiseledchipped$updateFilteredEntries() {
        ChiselingRecipe recipe = ((BaseChiselingContainer)this.container).currentRecipe;
        this.filteredEntries.clear();
        if (recipe == null) {
            return;
        }
        String filter = this.searchBox.getText().toLowerCase();
        for (ChiselingEntry entry : recipe.getEntries()) {
            String itemName = "";
            if (entry.getRegularItem() != null) {
                itemName = entry.getRegularItem().m_41466_().getString().toLowerCase();
            } else if (entry.getConnectingItem() != null) {
                itemName = entry.getConnectingItem().m_41466_().getString().toLowerCase();
            }
            if (!itemName.contains(filter)) continue;
            this.filteredEntries.add(entry);
        }
    }

    @Unique
    private ChiselingEntry rechiseledchipped$getFilteredEntry(int index) {
        if (index < 0 || index >= this.filteredEntries.size()) {
            return null;
        }
        return this.filteredEntries.get(index);
    }

    @Unique
    private void rechiseledchipped$selectFilteredEntry(int index) {
        ChiselingEntry entry = this.rechiseledchipped$getFilteredEntry(index);
        if (entry != null) {
            this.selectEntry(((BaseChiselingContainer)this.container).currentRecipe.getEntries().indexOf(entry));
        }
    }

    @Unique
    private void rechiseledchipped$updateScrollData() {
        int size = this.filteredEntries.size();
        this.numScrolls = (int)Math.ceil((double)size / (double)this.numColumns) - this.numRows;
        if (this.numScrolls < 0) {
            this.numScrolls = 0;
        }
        if (this.currentScroll > this.numScrolls) {
            this.currentScroll = this.numScrolls;
        }
        if (this.scrollWidget != null) {
            this.scrollWidget.setIntSnapMax(this.numScrolls);
            this.scrollWidget.setIsActive(this.numScrolls > 0);
            this.scrollWidget.setScrollRatio(this.numScrolls == 0 ? 0.0f : (float)this.currentScroll / (float)this.numScrolls);
        }
    }

    @Unique
    private void scrollChanged() {
        this.currentScroll = (int)((float)this.numScrolls * this.scrollWidget.getScrollRatio());
        if (this.currentScroll < 0) {
            this.currentScroll = 0;
        }
        if (this.currentScroll > this.numScrolls) {
            this.currentScroll = this.numScrolls;
        }
    }

    public boolean mouseScrolled(int mouseX, int mouseY, double scrollAmount, boolean hasBeenHandled) {
        int top = 17;
        int bottom = top + 22 * this.numRows;
        int left = 8;
        int right = 110;
        if (mouseX >= left && mouseX <= right && mouseY >= top && mouseY <= bottom) {
            this.currentScroll -= scrollAmount > 0.0 ? 1 : -1;
            if (this.currentScroll < 0) {
                this.currentScroll = 0;
            }
            if (this.currentScroll > this.numScrolls) {
                this.currentScroll = this.numScrolls;
            }
            if (this.scrollWidget != null) {
                this.scrollWidget.setScrollRatio(this.numScrolls == 0 ? 0.0f : (float)this.currentScroll / (float)this.numScrolls);
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollAmount, hasBeenHandled);
    }

    public boolean keyPressed(int keyCode, boolean hasBeenHandled) {
        if (this.searchBox != null && this.searchBox.isFocused()) {
            boolean ctrl;
            boolean bl = ctrl = GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341) == 1 || GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)345) == 1;
            if (ctrl && keyCode == 65) {
                this.searchBox.setText("");
                return true;
            }
        }
        return super.keyPressed(keyCode, hasBeenHandled);
    }

    @Shadow
    protected abstract ChiselingEntry getEntry(int var1);

    @Shadow
    protected abstract void selectEntry(int var1);

    @Shadow
    protected abstract void toggleConnecting();

    @Shadow
    protected abstract void chiselAll();
}

