/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book.element;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;

public class ImageElement
extends SizedBookElement {
    public ImageData image;
    public int colorMultiplier;
    private ItemElement itemElement;

    public ImageElement(ImageData image) {
        this(image, 0xFFFFFF);
    }

    public ImageElement(ImageData image, int colorMultiplier) {
        this(image.x, image.y, image.width, image.height, image, colorMultiplier);
    }

    public ImageElement(int x, int y, int width, int height, ImageData image) {
        this(x, y, width, height, image, image.colorMultiplier);
    }

    public ImageElement(int x, int y, int width, int height, ImageData image, int colorMultiplier) {
        super(x, y, width, height);
        this.image = image;
        if (image.x != -1) {
            x = image.x;
        }
        if (image.y != -1) {
            y = image.y;
        }
        if (image.width != -1) {
            width = image.width;
        }
        if (image.height != -1) {
            height = image.height;
        }
        if (image.colorMultiplier != 0xFFFFFF) {
            colorMultiplier = image.colorMultiplier;
        }
        this.x = x == -1 ? 0 : x;
        this.y = y == -1 ? 0 : y;
        this.width = width;
        this.height = height;
        this.colorMultiplier = colorMultiplier;
        if (image.item != null) {
            this.itemElement = new ItemElement(0, 0, 1.0f, (Collection<ItemStack>)image.item.getItems());
        }
    }

    @Override
    public void setParent(BookScreen parent) {
        super.setParent(parent);
        if (this.itemElement != null) {
            this.itemElement.setParent(parent);
        }
    }

    @Override
    public void draw(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, Font fontRenderer) {
        float r = (float)(this.colorMultiplier >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.colorMultiplier >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.colorMultiplier & 0xFF) / 255.0f;
        graphics.m_280246_(r, g, b, 1.0f);
        if (this.image.item == null) {
            ResourceLocation texture = Objects.requireNonNullElse(this.image.location, TextureManager.f_118466_);
            graphics.m_280411_(texture, this.x, this.y, this.width, this.height, (float)this.image.u, (float)this.image.v, this.image.uw, this.image.vh, this.image.texWidth, this.image.texHeight);
        } else {
            PoseStack matrices = graphics.m_280168_();
            matrices.m_85836_();
            matrices.m_252880_((float)this.x, (float)this.y, 0.0f);
            matrices.m_85841_((float)this.width / 16.0f, (float)this.height / 16.0f, 1.0f);
            this.itemElement.draw(graphics, mouseX, mouseY, partialTicks, fontRenderer);
            matrices.m_85849_();
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

