/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.client;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.data.client.GenericTextureGenerator;

public class DeanimateTextureGenerator
extends GenericTextureGenerator {
    private static final Map<ResourceLocation, ResourceLocation> deanimate = new HashMap<ResourceLocation, ResourceLocation>();
    private final String folder;

    public DeanimateTextureGenerator(PackOutput packOutput, ExistingFileHelper existingFileHelper, String folder) {
        super(packOutput, existingFileHelper, folder);
        this.folder = folder;
    }

    public DeanimateTextureGenerator(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        this(packOutput, existingFileHelper, "textures");
    }

    public void deanimate(ResourceLocation source, ResourceLocation destination) {
        ResourceLocation existing = deanimate.putIfAbsent(destination, source);
        if (existing != null && !existing.equals((Object)source)) {
            throw new IllegalArgumentException("Multiple textures are deanimating with the same destination: original - " + existing + ", new - " + source);
        }
    }

    protected void addTextures() {
    }

    public final CompletableFuture<?> m_213708_(CachedOutput cached) {
        ArrayList openedImages = new ArrayList();
        this.addTextures();
        assert (this.existingFileHelper != null);
        return DeanimateTextureGenerator.allOf(deanimate.entrySet().stream().map(entry -> {
            CompletableFuture<?> completableFuture;
            block8: {
                NativeImage image = DeanimateTextureGenerator.read(this.existingFileHelper, this.folder, (ResourceLocation)entry.getValue());
                try {
                    NativeImage copy = new NativeImage(image.m_84982_(), image.m_84982_(), true);
                    copy.m_85054_(image);
                    openedImages.add(copy);
                    completableFuture = this.saveImage(cached, (ResourceLocation)entry.getKey(), copy);
                    if (image == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (image != null) {
                            try {
                                image.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return CompletableFuture.failedFuture(e);
                    }
                }
                image.close();
            }
            return completableFuture;
        })).thenRunAsync(() -> {
            for (NativeImage image : openedImages) {
                image.close();
            }
        });
    }

    public String m_6055_() {
        return "Texture Deanimator";
    }
}

