/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate.damage;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.TagPredicateRegistry;

public interface DamageSourcePredicate
extends IJsonPredicate<DamageSource> {
    public static final DamageSourcePredicate ANY = DamageSourcePredicate.simple(source -> true);
    public static final DamageSourcePredicate NONE = DamageSourcePredicate.simple(source -> false);
    public static final TagPredicateRegistry<DamageType, DamageSource> LOADER = new TagPredicateRegistry("Damage Source Predicate", ANY, NONE, Loadables.DAMAGE_TYPE_TAG, (tag, source) -> source.m_269533_(tag));
    public static final DamageSourcePredicate IS_INDIRECT = DamageSourcePredicate.simple(DamageSource::m_269014_);
    public static final DamageSourcePredicate HAS_ENTITY = DamageSourcePredicate.simple(source -> source.m_7639_() != null);
    public static final DamageSourcePredicate CAN_PROTECT = DamageSourcePredicate.simple(source -> !source.m_269533_(DamageTypeTags.f_268437_) && !source.m_269533_(DamageTypeTags.f_268413_) && !source.m_269533_(DamageTypeTags.f_268738_));

    @Override
    default public IJsonPredicate<DamageSource> inverted() {
        return LOADER.invert(this);
    }

    public static DamageSourcePredicate simple(final Predicate<DamageSource> predicate) {
        return SingletonLoader.singleton(loader -> new DamageSourcePredicate(){
            final /* synthetic */ RecordLoadable val$loader;
            {
                this.val$loader = recordLoadable;
            }

            @Override
            public boolean matches(DamageSource source) {
                return predicate.test(source);
            }

            @Override
            public RecordLoadable<? extends DamageSourcePredicate> getLoader() {
                return this.val$loader;
            }
        });
    }

    public static IJsonPredicate<DamageSource> tag(TagKey<DamageType> tag) {
        return LOADER.tag(tag);
    }

    @SafeVarargs
    public static IJsonPredicate<DamageSource> and(IJsonPredicate<DamageSource> ... predicates) {
        return LOADER.and(List.of(predicates));
    }

    @SafeVarargs
    public static IJsonPredicate<DamageSource> or(IJsonPredicate<DamageSource> ... predicates) {
        return LOADER.or(List.of(predicates));
    }
}

