/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.model;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.client.model.builder.ColoredModelBuilder;
import slimeknights.mantle.client.model.builder.ConnectedModelBuilder;
import slimeknights.mantle.client.model.builder.MantleItemLayerBuilder;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.registration.GeodeItemObject;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.world.TinkerWorld;

public class TinkerBlockStateProvider
extends BlockStateProvider {
    private final ModelFile.UncheckedModelFile GENERATED = new ModelFile.UncheckedModelFile("item/generated");

    public TinkerBlockStateProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "tconstruct", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.addFenceBuildingBlock(TinkerMaterials.blazewood, "block/wood/blazewood/", "planks", this.blockTexture("wood/blazewood"));
        this.addFenceBuildingBlock(TinkerMaterials.nahuatl, "block/wood/nahuatl/", "planks", this.blockTexture("wood/nahuatl"));
        this.addWood(TinkerWorld.greenheart, false, RenderType.m_110463_());
        this.addWood(TinkerWorld.skyroot, true, RenderType.m_110463_());
        this.addWood(TinkerWorld.bloodshroom, true, RenderType.m_110463_());
        this.addWood(TinkerWorld.enderbark, true, RenderType.m_110451_());
        this.basicBlock((Block)TinkerWorld.enderbarkRoots.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/wood/enderbark/roots/empty", "block/mangrove_roots")).renderType(RenderType.m_110463_().f_110133_)).texture("side", this.blockTexture("wood/enderbark/roots"))).texture("top", this.blockTexture("wood/enderbark/roots_top")));
        TinkerWorld.slimyEnderbarkRoots.forEach((type, block) -> {
            String name = type.m_7912_();
            this.cubeColumn((Block)block, "block/wood/enderbark/roots/" + name, this.blockTexture("wood/enderbark/roots/" + name), this.blockTexture("wood/enderbark/roots/" + name + "_top"));
        });
        this.glassBlock((Block)TinkerCommons.clearGlass.get(), (IronBarsBlock)TinkerCommons.clearGlassPane.get(), "clear_glass/", TConstruct.getResource("block/clear_glass"), -1, true, null);
        ResourceLocation clearStainedGlass = TConstruct.getResource("block/clear_stained_glass");
        RenderType translucent = RenderType.m_110466_();
        for (ClearStainedGlassBlock.GlassColor color : ClearStainedGlassBlock.GlassColor.values()) {
            this.glassBlock((Block)TinkerCommons.clearStainedGlass.get((Enum)color), (IronBarsBlock)TinkerCommons.clearStainedGlassPane.get((Enum)color), "clear_glass/" + color.m_7912_() + "/", clearStainedGlass, 0xFF000000 | color.getColor(), false, translucent);
        }
        this.glassBlock((Block)TinkerCommons.soulGlass.get(), (IronBarsBlock)TinkerCommons.soulGlassPane.get(), "soul_glass/", TConstruct.getResource("block/soul_glass"), -1, false, translucent);
        this.glassBlock((Block)TinkerSmeltery.searedGlass.get(), (IronBarsBlock)TinkerSmeltery.searedGlassPane.get(), "smeltery/glass/", TConstruct.getResource("block/smeltery/seared_glass"), -1, true, null);
        this.glassBlock((Block)TinkerSmeltery.searedSoulGlass.get(), (IronBarsBlock)TinkerSmeltery.searedSoulGlassPane.get(), "smeltery/soul_glass/", TConstruct.getResource("block/smeltery/soul_glass"), TConstruct.getResource("block/smeltery/seared_glass_top"), -1, true, translucent);
        this.glassBlock((Block)TinkerSmeltery.scorchedGlass.get(), (IronBarsBlock)TinkerSmeltery.scorchedGlassPane.get(), "foundry/glass/", TConstruct.getResource("block/foundry/glass"), -1, true, null);
        this.glassBlock((Block)TinkerSmeltery.scorchedSoulGlass.get(), (IronBarsBlock)TinkerSmeltery.scorchedSoulGlassPane.get(), "foundry/soul_glass/", TConstruct.getResource("block/foundry/soul_glass"), TConstruct.getResource("block/foundry/glass_top"), -1, true, translucent);
        ResourceLocation obsidian = new ResourceLocation("block/obsidian");
        this.paneBlock((IronBarsBlock)TinkerCommons.obsidianPane.get(), "obsidian_pane/", obsidian, obsidian, false, -1, false, RenderType.m_110451_());
        this.bud((Block)TinkerWorld.steelCluster.get(), "block/geode/steel_cluster", this.blockTexture("geode/steel_cluster"));
        this.bud((Block)TinkerWorld.knightmetalCluster.get(), "block/geode/knightmetal_cluster", this.blockTexture("geode/knightmetal_cluster"));
        this.geode(TinkerWorld.earthGeode, "earth");
        this.geode(TinkerWorld.skyGeode, "sky");
        this.geode(TinkerWorld.ichorGeode, "ichor");
        this.geode(TinkerWorld.enderGeode, "ender");
        this.basicBlock((Block)TinkerSmeltery.searedLamp.get(), "block/smeltery/seared/lamp", this.blockTexture("smeltery/seared/lamp"));
        this.basicBlock((Block)TinkerSmeltery.scorchedLamp.get(), "block/foundry/scorched/lamp", this.blockTexture("foundry/scorched/lamp"));
    }

    protected ResourceLocation blockTexture(String path) {
        return TConstruct.getResource("block/" + path);
    }

    protected ResourceLocation itemTexture(String path) {
        return TConstruct.getResource("item/" + path);
    }

    protected void addBuildingBlock(BuildingBlockObject block, String folder, String name, ResourceLocation texture) {
        ModelFile blockModel = this.basicBlock((Block)block.get(), folder + name, texture);
        this.slab(block.getSlab(), folder + "slab", blockModel, texture, texture, texture);
        this.stairs(block.getStairs(), folder + "stairs", texture, texture, texture);
    }

    protected void addFenceBuildingBlock(FenceBuildingBlockObject block, String folder, String name, ResourceLocation texture) {
        this.addBuildingBlock((BuildingBlockObject)block, folder, name, texture);
        this.fence(block.getFence(), folder + "fence/", texture);
    }

    protected void addWood(WoodBlockObject wood, boolean trapdoorOrientable, RenderType doorRenderType) {
        String plankPath = wood.getId().m_135815_();
        String name = plankPath.substring(0, plankPath.length() - "_planks".length());
        String folder = "block/wood/" + name + "/";
        Function<String, ResourceLocation> texture = suffix -> this.blockTexture("wood/" + name + "/" + suffix);
        ResourceLocation planks = texture.apply("planks");
        ResourceLocation log = texture.apply("log");
        ResourceLocation stripped = texture.apply("stripped_log");
        this.addFenceBuildingBlock((FenceBuildingBlockObject)wood, folder, "planks", planks);
        this.fenceGate(wood.getFenceGate(), folder + "fence/gate", planks);
        this.axisBlock(wood.getLog(), folder + "log/log", log, true);
        this.axisBlock(wood.getStrippedLog(), folder + "log/stripped", stripped, true);
        this.axisBlock(wood.getWood(), folder + "log/wood", log, false);
        this.axisBlock(wood.getStrippedWood(), folder + "log/wood_stripped", stripped, false);
        this.door(wood.getDoor(), folder, doorRenderType, texture.apply("door_bottom"), texture.apply("door_top"));
        this.basicItem((ItemLike)wood.getDoor(), "wood/");
        this.trapdoor(wood.getTrapdoor(), folder + "trapdoor_", texture.apply("trapdoor"), trapdoorOrientable);
        this.pressurePlate(wood.getPressurePlate(), folder + "pressure_plate", planks);
        this.button(wood.getButton(), folder + "button", planks);
        this.signBlock(wood.getSign(), wood.getWallSign(), (ModelFile)this.models().sign(folder + "sign", planks));
        this.basicItem((ItemLike)wood.getSign(), "wood/");
        ModelBuilder hangingSign = this.models().sign(folder + "hanging_sign", stripped);
        this.simpleBlock((Block)wood.getHangingSign(), (ModelFile)hangingSign);
        this.simpleBlock((Block)wood.getWallHangingSign(), (ModelFile)hangingSign);
        this.basicItem((ItemLike)wood.getHangingSign(), "wood/");
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block);
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation itemKey(ItemLike item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_());
    }

    private String itemName(ItemLike item) {
        return this.itemKey(item).m_135815_();
    }

    protected ItemModelBuilder basicItem(ItemLike item, String texturePrefix) {
        return this.basicItem(this.itemKey(item), texturePrefix);
    }

    protected ItemModelBuilder basicItem(ResourceLocation item, String texturePrefix) {
        return this.generated(item, this.itemTexture(texturePrefix + item.m_135815_()));
    }

    protected ItemModelBuilder generated(ResourceLocation item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(item.toString())).parent((ModelFile)this.GENERATED)).texture("layer0", texture);
    }

    public ModelFile basicBlock(Block block, ModelFile model) {
        this.simpleBlock(block, model);
        this.simpleBlockItem(block, model);
        return model;
    }

    public ModelFile basicBlock(Block block, String location, ResourceLocation texture) {
        return this.basicBlock(block, (ModelFile)this.models().cubeAll(location, texture));
    }

    public ModelFile cubeColumn(Block block, String location, ResourceLocation side, ResourceLocation top) {
        return this.basicBlock(block, (ModelFile)this.models().cubeColumn(location, side, top));
    }

    public void axisBlock(Block block, String location, ResourceLocation texture, boolean horizontal) {
        ResourceLocation endTexture = horizontal ? texture.m_266382_("_top") : texture;
        ModelBuilder model = this.models().cubeColumn(TConstruct.resourceString(location), texture, endTexture);
        this.axisBlock((RotatedPillarBlock)block, (ModelFile)model, (ModelFile)(horizontal ? this.models().cubeColumnHorizontal(TConstruct.resourceString(location + "_horizontal"), texture, endTexture) : model));
        this.simpleBlockItem(block, (ModelFile)model);
    }

    public void slab(SlabBlock block, String location, ModelFile doubleModel, ResourceLocation sideTexture, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        ModelBuilder slab = this.models().slab(location, sideTexture, bottomTexture, topTexture);
        this.slabBlock(block, (ModelFile)slab, (ModelFile)this.models().slabTop(location + "_top", sideTexture, bottomTexture, topTexture), doubleModel);
        this.simpleBlockItem((Block)block, (ModelFile)slab);
    }

    public void stairs(StairBlock block, String location, ResourceLocation sideTexture, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        ModelBuilder stairs = this.models().stairs(location, sideTexture, bottomTexture, topTexture);
        this.stairsBlock(block, (ModelFile)stairs, (ModelFile)this.models().stairsInner(location + "_inner", sideTexture, bottomTexture, topTexture), (ModelFile)this.models().stairsOuter(location + "_outer", sideTexture, bottomTexture, topTexture));
        this.simpleBlockItem((Block)block, (ModelFile)stairs);
    }

    public void fence(FenceBlock block, String prefix, ResourceLocation texture) {
        this.fourWayBlock((CrossCollisionBlock)block, (ModelFile)this.models().fencePost(prefix + "post", texture), (ModelFile)this.models().fenceSide(prefix + "side", texture));
        ((ItemModelBuilder)this.itemModels().withExistingParent(this.itemName((ItemLike)block), "minecraft:block/fence_inventory")).texture("texture", texture);
    }

    public void fenceGate(FenceGateBlock block, String baseName, ResourceLocation texture) {
        ModelBuilder model = this.models().fenceGate(baseName, texture);
        this.fenceGateBlock(block, (ModelFile)model, (ModelFile)this.models().fenceGateOpen(baseName + "_open", texture), (ModelFile)this.models().fenceGateWall(baseName + "_wall", texture), (ModelFile)this.models().fenceGateWallOpen(baseName + "_wall_open", texture));
        this.simpleBlockItem((Block)block, (ModelFile)model);
    }

    public void door(DoorBlock block, String prefix, RenderType doorRenderType, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        this.doorBlock(block, (ModelFile)((BlockModelBuilder)this.models().doorBottomLeft(prefix + "door/bottom_left", bottomTexture, topTexture)).renderType(doorRenderType.f_110133_), (ModelFile)((BlockModelBuilder)this.models().doorBottomLeftOpen(prefix + "door/bottom_left_open", bottomTexture, topTexture)).renderType(doorRenderType.f_110133_), (ModelFile)((BlockModelBuilder)this.models().doorBottomRight(prefix + "door/bottom_right", bottomTexture, topTexture)).renderType(doorRenderType.f_110133_), (ModelFile)((BlockModelBuilder)this.models().doorBottomRightOpen(prefix + "door/bottom_right_open", bottomTexture, topTexture)).renderType(doorRenderType.f_110133_), (ModelFile)((BlockModelBuilder)this.models().doorTopLeft(prefix + "door/top_left", bottomTexture, topTexture)).renderType(doorRenderType.f_110133_), (ModelFile)((BlockModelBuilder)this.models().doorTopLeftOpen(prefix + "door/top_left_open", bottomTexture, topTexture)).renderType(doorRenderType.f_110133_), (ModelFile)((BlockModelBuilder)this.models().doorTopRight(prefix + "door/top_right", bottomTexture, topTexture)).renderType(doorRenderType.f_110133_), (ModelFile)((BlockModelBuilder)this.models().doorTopRightOpen(prefix + "door/top_right_open", bottomTexture, topTexture)).renderType(doorRenderType.f_110133_));
    }

    public void trapdoor(TrapDoorBlock block, String prefix, ResourceLocation texture, boolean orientable) {
        ModelBuilder open;
        ModelBuilder top;
        ModelBuilder bottom;
        if (orientable) {
            bottom = ((BlockModelBuilder)this.models().trapdoorOrientableBottom(prefix + "bottom", texture)).renderType(RenderType.m_110463_().f_110133_);
            top = ((BlockModelBuilder)this.models().trapdoorOrientableTop(prefix + "top", texture)).renderType(RenderType.m_110463_().f_110133_);
            open = ((BlockModelBuilder)this.models().trapdoorOrientableOpen(prefix + "open", texture)).renderType(RenderType.m_110463_().f_110133_);
        } else {
            bottom = ((BlockModelBuilder)this.models().trapdoorBottom(prefix + "bottom", texture)).renderType(RenderType.m_110463_().f_110133_);
            top = ((BlockModelBuilder)this.models().trapdoorTop(prefix + "top", texture)).renderType(RenderType.m_110463_().f_110133_);
            open = ((BlockModelBuilder)this.models().trapdoorOpen(prefix + "open", texture)).renderType(RenderType.m_110463_().f_110133_);
        }
        this.trapdoorBlock(block, (ModelFile)bottom, (ModelFile)top, (ModelFile)open, orientable);
        this.simpleBlockItem((Block)block, (ModelFile)bottom);
    }

    public void pressurePlate(PressurePlateBlock block, String location, ResourceLocation texture) {
        ModelBuilder pressurePlate = this.models().pressurePlate(location, texture);
        this.pressurePlateBlock(block, (ModelFile)pressurePlate, (ModelFile)this.models().pressurePlateDown(location + "_down", texture));
        this.simpleBlockItem((Block)block, (ModelFile)pressurePlate);
    }

    public void button(ButtonBlock block, String location, ResourceLocation texture) {
        ModelBuilder button = this.models().button(location, texture);
        this.buttonBlock(block, (ModelFile)button, (ModelFile)this.models().buttonPressed(location + "_pressed", texture));
        ((ItemModelBuilder)this.itemModels().withExistingParent(this.itemName((ItemLike)block), "minecraft:block/button_inventory")).texture("texture", texture);
    }

    public void bud(Block block, String location, ResourceLocation texture) {
        ModelBuilder bud = ((BlockModelBuilder)this.models().cross(location, texture)).renderType(RenderType.m_110463_().f_110133_);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)bud).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)bud).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)bud).rotationX(90).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)bud).rotationX(90).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)bud).rotationX(90).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)bud).rotationX(90).rotationY(270).addModel();
    }

    public void geode(GeodeItemObject geode, String type) {
        this.basicItem((ItemLike)geode, "materials/");
        for (GeodeItemObject.BudSize size : GeodeItemObject.BudSize.values()) {
            Object name = size.getName();
            if (size != GeodeItemObject.BudSize.CLUSTER) {
                name = (String)name + "_bud";
            }
            Block bud = geode.getBud(size);
            ResourceLocation texture = this.blockTexture("geode/" + type + "/" + (String)name);
            this.bud(bud, "block/geode/" + type + "/" + (String)name, texture);
            ((ItemModelBuilder)this.itemModels().withExistingParent(this.itemName((ItemLike)bud), TConstruct.getResource("item/base/geode/" + (String)name))).texture("layer0", texture);
        }
        this.basicBlock(geode.getBlock(), "block/geode/" + type + "/block", this.blockTexture("geode/" + type + "/block"));
        this.basicBlock(geode.getBudding(), "block/geode/" + type + "/budding", this.blockTexture("geode/" + type + "/budding"));
    }

    private BlockModelBuilder paneModel(String baseName, String variant, ResourceLocation pane, @Nullable ResourceLocation edge, @Nullable RenderType renderType, boolean connected, int tint) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent("block/" + baseName + variant, TConstruct.getResource("block/template/pane/" + variant));
        builder.texture("pane", pane);
        if (edge != null) {
            builder.texture("edge", edge);
        }
        if (renderType != null) {
            builder.renderType(renderType.f_110133_);
        }
        if (connected) {
            ConnectedModelBuilder cBuilder = (ConnectedModelBuilder)builder.customLoader(ConnectedModelBuilder::new);
            cBuilder.connected("pane", "cornerless_full").setPredicate("pane");
            if (tint != -1) {
                cBuilder.color(tint);
            }
        } else if (tint != -1) {
            ((ColoredModelBuilder)builder.customLoader(ColoredModelBuilder::new)).color(tint);
        }
        return builder;
    }

    private void paneBlockWithEdge(IronBarsBlock block, ModelFile post, ModelFile side, ModelFile sideAlt, ModelFile noSide, ModelFile noSideAlt, ModelFile noSideEdge) {
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block).part().modelFile(post).addModel()).end();
        PipeBlock.f_55154_.forEach((dir, value) -> {
            if (dir.m_122434_().m_122479_()) {
                boolean alt = dir == Direction.SOUTH;
                ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(alt || dir == Direction.WEST ? sideAlt : side).rotationY(dir.m_122434_() == Direction.Axis.X ? 90 : 0).addModel()).condition((Property)value, (Comparable[])new Boolean[]{true}).end().part().modelFile(alt || dir == Direction.EAST ? noSideAlt : noSide).rotationY(dir == Direction.WEST ? 270 : (dir == Direction.SOUTH ? 90 : 0)).addModel()).condition((Property)value, (Comparable[])new Boolean[]{false}).end().part().modelFile(noSideEdge).rotationY((int)dir.m_122424_().m_122435_()).addModel()).condition((Property)value, (Comparable[])new Boolean[]{false}).condition((Property)PipeBlock.f_55154_.get(dir.m_122427_()), (Comparable[])new Boolean[]{false}).condition((Property)PipeBlock.f_55154_.get(dir.m_122428_()), (Comparable[])new Boolean[]{false}).end();
            }
        });
    }

    public void paneBlock(IronBarsBlock block, String baseName, ResourceLocation pane, ResourceLocation edge, boolean connected, int tint, boolean solidEdge, @Nullable RenderType renderType) {
        BlockModelBuilder post = this.paneModel(baseName, "post", pane, edge, renderType, connected, tint);
        BlockModelBuilder side = this.paneModel(baseName, "side", pane, edge, renderType, connected, tint);
        BlockModelBuilder sideAlt = this.paneModel(baseName, "side_alt", pane, edge, renderType, connected, tint);
        BlockModelBuilder noSide = this.paneModel(baseName, "noside", pane, null, renderType, connected, tint);
        BlockModelBuilder noSideAlt = this.paneModel(baseName, "noside_alt", pane, null, renderType, connected, tint);
        if (solidEdge && !pane.equals((Object)edge)) {
            BlockModelBuilder noSideEdge = this.paneModel(baseName, "noside_edge", pane, edge, renderType, false, tint);
            this.paneBlockWithEdge(block, (ModelFile)post, (ModelFile)side, (ModelFile)sideAlt, (ModelFile)noSide, (ModelFile)noSideAlt, (ModelFile)noSideEdge);
        } else {
            this.paneBlock(block, (ModelFile)post, (ModelFile)side, (ModelFile)sideAlt, (ModelFile)noSide, (ModelFile)noSideAlt);
        }
        ItemModelBuilder item = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.itemKey((ItemLike)block).toString())).parent((ModelFile)this.GENERATED)).texture("layer0", pane);
        if (tint != -1) {
            ((MantleItemLayerBuilder)item.customLoader(MantleItemLayerBuilder::new)).color(tint);
        }
        if (renderType != null) {
            item.renderType(renderType.f_110133_);
        }
    }

    public void glassBlock(Block glass, IronBarsBlock pane, String baseName, ResourceLocation front, int tint, boolean solidEdge, @Nullable RenderType renderType) {
        this.glassBlock(glass, pane, baseName, front, front.m_266382_("_top"), tint, solidEdge, renderType);
    }

    public void glassBlock(Block glass, IronBarsBlock pane, String baseName, ResourceLocation front, ResourceLocation edge, int tint, boolean solidEdge, @Nullable RenderType renderType) {
        BlockModelBuilder block = (BlockModelBuilder)this.models().cubeAll("block/" + baseName + "block", front);
        ConnectedModelBuilder cBuilder = (ConnectedModelBuilder)block.customLoader(ConnectedModelBuilder::new);
        cBuilder.connected("all", "cornerless_full");
        if (tint != -1) {
            cBuilder.color(tint);
        }
        if (renderType != null) {
            block.renderType(renderType.f_110133_);
        } else {
            block.renderType(RenderType.m_110463_().f_110133_);
        }
        this.basicBlock(glass, (ModelFile)block);
        this.paneBlock(pane, baseName + "pane_", front, edge, true, tint, solidEdge, renderType);
    }
}

