/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.spritetransformer;

import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.spritetransformer.GreyToColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.GreyToSpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;

public class AnimatedGreyToSpriteTransformer
extends GreyToSpriteTransformer {
    public static final ResourceLocation NAME = TConstruct.getResource("animated_sprite");
    public static GreyToSpriteTransformer.Deserializer<AnimatedGreyToSpriteTransformer> DESERIALIZER = new GreyToSpriteTransformer.Deserializer<AnimatedGreyToSpriteTransformer>((builder, json) -> builder.animated(JsonHelper.getResourceLocation((JsonObject)json, (String)"meta"), (Integer)IntLoadable.FROM_ONE.getIfPresent(json, "frames")));
    private final ResourceLocation metaPath;
    private final int frames;
    private JsonObject meta;

    protected AnimatedGreyToSpriteTransformer(List<GreyToSpriteTransformer.SpriteMapping> sprites, ResourceLocation metaPath, int frames) {
        super(sprites);
        this.metaPath = metaPath;
        this.frames = frames;
    }

    @Override
    public int getFrames() {
        return this.frames;
    }

    @Override
    public int getNewColor(int color, int x, int y, int frame) {
        if (FastColor.ABGR32.m_266503_((int)color) == 0) {
            return 0;
        }
        int grey = GreyToColorMapping.getGrey(color);
        int newColor = this.getSpriteRange(grey).getColor(x, y, frame, grey);
        return GreyToColorMapping.scaleColor(color, newColor, grey);
    }

    @Override
    public void transform(NativeImage image, boolean allowAnimated) {
        int frames;
        int n = frames = allowAnimated ? this.getFrames() : 1;
        if (frames <= 1) {
            super.transform(image, allowAnimated);
            return;
        }
        int width = image.m_84982_();
        int height = image.m_85084_() / frames;
        for (int f = frames - 1; f >= 0; --f) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    image.m_84988_(x, y + f * height, this.getNewColor(image.m_84985_(x, y), x, y, f));
                }
            }
        }
    }

    @Override
    public NativeImage copyImage(NativeImage image, boolean allowAnimated) {
        return ISpriteTransformer.copyImage(image, allowAnimated ? this.frames : 1);
    }

    @Override
    @Nullable
    public JsonObject animationMeta(NativeImage image) {
        if (this.meta == null) {
            if (READER == null) {
                throw new IllegalStateException("Cannot get image for a sprite without reader");
            }
            try {
                this.meta = READER.readMetadata(this.metaPath);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to load required image metadata from " + this.metaPath, ex);
            }
        }
        return this.meta;
    }

    @Override
    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject object = super.serialize(context);
        object.addProperty("type", NAME.toString());
        object.addProperty("meta", this.metaPath.toString());
        object.addProperty("frames", (Number)this.frames);
        return object;
    }
}

